<?php
session_start();
include("config.php");
include("log_activity.php");

$id = intval($_GET['id'] ?? 0);
$stmt = $conn->prepare("SELECT link,title, restriction FROM student_corner WHERE id=? AND status='Active'");
$stmt->bind_param("i", $id);
$stmt->execute();
$data = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$data) die("Content not found.");

$loggedIn = isset($_SESSION['subscriber_id']);
$subscribed = ($loggedIn 
               && isset($_SESSION['subscriber_status']) 
               && $_SESSION['subscriber_status'] === 'subscribed');

if ($data['restriction'] === 'Restricted') {

    if (!$loggedIn) {
        header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }

    if (!$subscribed) {
        header("Location: subscription.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
}

// ✅ ✅ LOG ACTIVITY — only for successful access
if ($loggedIn) {
    logActivity($conn, $_SESSION['subscriber_id'], "Opened Link: " . $data['title']);
}


header("Location: " . $data['link']);
exit;
?>
