<?php include_once('./config.php'); ?>
<?php
function getImagePath($path) {
    if (strpos($path, '../') === 0) {
        $path = substr($path, 3);
    }
    return $path;
}

// Fetch batches
$batches = [];
$res = $conn->query("SELECT id, title FROM batch WHERE status='Active' AND deleted_at IS NULL ORDER BY id DESC");
while ($row = $res->fetch_assoc()) {
    $batches[] = $row;
}

// Get allowed institute coordinates from settings
$institute_lat = $settings['latitude'] ?? '0';
$institute_lng = $settings['longitude'] ?? '0';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Attendance | <?= htmlspecialchars($settings['site_name']) ?></title>
  <link rel="icon" href="<?= getImagePath($settings['fevicon']) ?>" />
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />
  <link rel="stylesheet" href="assets/css/lineicons.css" />
  <link rel="stylesheet" href="style.css" />

  <!-- Select2 -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <style>
       body {
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      background-color: #f8f9fa;
      font-family: 'Poppins', sans-serif;
    }
    main { flex: 1; padding: 40px 15px; }

    .attendance-card {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      padding: 30px;
      max-width: 550px;
      margin: auto;
      animation: fadeIn .5s ease-in-out;
    }
    @keyframes fadeIn { from {opacity:0; transform:translateY(20px);} to {opacity:1; transform:translateY(0);} }
    .attendance-card {
      background:#fff; border-radius:15px; padding:30px;
      box-shadow:0 4px 10px rgba(0,0,0,.1);
      max-width:550px; margin:40px auto;
    }
    .submit-btn {
      background:linear-gradient(45deg,#007bff,#00b4d8);
      border:none; color:#fff; padding:10px 25px;
      border-radius:8px; transition:.3s;
    }
    .submit-btn:hover { transform:translateY(-2px); }
        footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 20px 0;
      text-align: center;
      color: #555;
    }
    footer a { color: #007bff; text-decoration: none; }
    footer a:hover { text-decoration: underline; }
  </style>
</head>
<body>
<header class="payment-header text-center shadow-sm">
  <div class="container">
    <img src="<?= getImagePath($settings['logo']) ?>" alt="logo" style="max-height:55px;" class="mb-2">
    <h3 class="title mb-1 text-primary">Attendance</h3>
  </div>
</header>

<main>
  <div class="attendance-card">
      
     <!-- Attendance Date -->
    <div class="mb-3">
      <h5 class="fw-bold text-primary mb-0">
        Attendance for <span id="attendanceDate"></span>
      </h5>
      <small class="text-muted">(Mark your attendance for today's date)</small>
      <hr class="mt-2 mb-4" style="border-top: 2px solid #e3f2fd;">
    </div>
      
      
    <form id="attendanceForm">
      <!-- Batch -->
      <div class="mb-3">
        <label class="form-label fw-semibold">Select Batch <span class="text-danger">*</span></label>
        <select name="batch_id" id="batchSelect" class="form-select" required>
          <option value="">-- Select Batch --</option>
          <?php foreach ($batches as $b): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['title']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <!-- Student -->
      <div class="mb-3" id="studentSelectDiv" style="display:none;">
        <label class="form-label fw-semibold">Select Student <span class="text-danger">*</span></label>
        <select name="student_mobile" id="studentSelect" class="form-select" required>
          <option value="">-- Select Student --</option>
        </select>
      </div>

      <div id="attendanceMsg" class="mt-3"></div>

      <div class="text-center">
        <button type="submit" class="submit-btn mt-2">Mark Attendance</button>
      </div>
    </form>
  </div>
</main>

<footer>
  <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
    <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
      <?= htmlspecialchars($settings['developer']); ?>
    </a>
  </p>
</footer>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@fingerprintjs/fingerprintjs@4/dist/fp.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/@fingerprintjs/fingerprintjs@3/dist/fp.min.js"></script>
<script>
$(document).ready(function() {
  // Initialize Select2
  $('#studentSelect').select2({
    placeholder: "Search or select Student",
    allowClear: true,
    width: '100%'
  });

  // --- Fetch students when batch changes ---
  $('#batchSelect').on('change', async function() {
    const batchId = $(this).val();
    const msg = $('#attendanceMsg');
    msg.html(''); // clear message

    if (!batchId) {
      $('#studentSelectDiv').hide();
      $('#studentSelect').html('<option value="">-- Select Student --</option>').trigger('change.select2');
      return;
    }

    msg.html(`<div class="alert alert-info text-center">Loading students...</div>`);

    try {
      const res = await fetch('get-student-by-batch.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ batch_id: batchId })
      });
      const data = await res.json();

      if (data.status === 'success') {
        $('#studentSelect').html(
          '<option value="">-- Select Student --</option>' +
          data.students.map(s => `<option value="${s.mobile}">${s.name} (${s.registration_no})</option>`).join('')
        ).trigger('change.select2');
        $('#studentSelectDiv').show();
        msg.html('');
      } 
      else if (data.status === 'empty') {
        $('#studentSelectDiv').hide();
        msg.html(`<div class="alert alert-info text-center">✅ ${data.message}</div>`);
      } 
      else {
        $('#studentSelectDiv').hide();
        msg.html(`<div class="alert alert-danger text-center">Failed to load students. Try again.</div>`);
      }

    } catch (error) {
      console.error('Error fetching students:', error);
      msg.html(`<div class="alert alert-danger">Network error while fetching students.</div>`);
      setTimeout(() => msg.html(''), 5000);
      $('#studentSelectDiv').hide();
    }
  });

  // --- Handle form submission ---
  $('#attendanceForm').on('submit', async function(e) {
    e.preventDefault();
    const msg = $('#attendanceMsg');
    msg.html('');

    const batchId = $('#batchSelect').val();
    const studentMobile = $('#studentSelect').val();

    if (!batchId || !studentMobile) {
      msg.html(`<div class="alert alert-danger">Please select both batch and student.</div>`);
      setTimeout(() => msg.html(''), 4000);
      return;
    }

    // --- Generate cross-browser device fingerprint ---
    const device_id = await generateHybridDeviceId();
    console.log('Device ID (Hybrid):', device_id);

    // --- Check HTTPS for geolocation ---
    if (location.protocol !== 'https:' && location.hostname !== 'localhost') {
      msg.html(`<div class="alert alert-warning">
        Location access requires HTTPS — please use a secure (https://) URL.
      </div>`);
      return;
    }

    // --- Get geolocation ---
    if (navigator.geolocation) {
      msg.html(`<div class="alert alert-info">Requesting your location... please allow access.</div>`);

      if (navigator.permissions) {
        const perm = await navigator.permissions.query({ name: 'geolocation' });
        if (perm.state === 'denied') {
          msg.html(`<div class="alert alert-danger">
            Location access is blocked. Please enable it in browser settings.
          </div>`);
          return;
        }
      }

      navigator.geolocation.getCurrentPosition(
        async position => {
          const lat = position.coords.latitude;
          const lng = position.coords.longitude;
          await submitAttendance(batchId, studentMobile, lat, lng, device_id);
        },
        error => {
          console.error('Geolocation error:', error);
          let errMsg = "Unable to get your location.";
          if (error.code === 1) errMsg = "Please allow location access to mark attendance.";
          else if (error.code === 2) errMsg = "Location unavailable — please enable GPS.";
          else if (error.code === 3) errMsg = "Location request timed out. Try again.";
          msg.html(`<div class="alert alert-danger">${errMsg}</div>`);
          setTimeout(() => msg.html(''), 5000);
        },
        { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 }
      );
    } else {
      msg.html(`<div class="alert alert-danger">Your browser does not support location access.</div>`);
      setTimeout(() => msg.html(''), 4000);
    }
  });

  // --- Submit attendance ---
  async function submitAttendance(batchId, studentMobile, lat, lng, deviceId) {
    const msg = $('#attendanceMsg');
    msg.html(`<div class="alert alert-info">Marking attendance...</div>`);

    const res = await fetch('submit-attendance.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/json'},
      body: JSON.stringify({
        batch_id: batchId,
        student_mobile: studentMobile,
        lat: lat,
        lng: lng,
        device_id: deviceId
      })
    });

    const data = await res.json();
    msg.html(`<div class="alert alert-${data.status === 'success' ? 'success' : 'danger'}">${data.message}</div>`);
    setTimeout(() => msg.html(''), 4000);

    if (data.status === 'success') {
      // ✅ Refresh student list
      $('#studentSelect').val('').trigger('change.select2');
      const res2 = await fetch('get-student-by-batch.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ batch_id: batchId })
      });
      const updated = await res2.json();
      if (updated.status === 'success') {
        $('#studentSelect').html(
          '<option value="">-- Select Student --</option>' +
          updated.students.map(s => `<option value="${s.mobile}">${s.name} (${s.registration_no})</option>`).join('')
        ).trigger('change.select2');
      } else {
        $('#studentSelectDiv').hide();
      }
    }
  }

  // --- Hybrid Device ID generator (cross-browser consistent) ---
  async function generateHybridDeviceId() {
    const fp = await FingerprintJS.load();
    const result = await fp.get();

    const info = [
      result.visitorId,
      navigator.userAgent,
      screen.width,
      screen.height,
      Intl.DateTimeFormat().resolvedOptions().timeZone,
      navigator.hardwareConcurrency || 0,
      navigator.deviceMemory || 0,
      navigator.platform
    ].join('|');

    const encoder = new TextEncoder();
    const data = encoder.encode(info);
    const hashBuffer = await crypto.subtle.digest('SHA-256', data);
    const hashArray = Array.from(new Uint8Array(hashBuffer));
    const hashHex = hashArray.map(b => b.toString(16).padStart(2, '0')).join('');
    return hashHex;
  }
});
</script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const today = new Date();
  const options = { year: 'numeric', month: 'long', day: 'numeric' };
  document.getElementById('attendanceDate').textContent = today.toLocaleDateString(undefined, options);
});
</script>



</body>
</html>
<?php $conn->close(); ?>

