<?php
// auth.php — protect admin or logged-in-only pages

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// If not logged in, redirect to login page
if (empty($_SESSION['user_id'])) {
    // Optional flash message
    $_SESSION['flash'] = 'Please log in to continue.';
    header('Location: login.php');
    exit;
}

// CSRF token generation (in case required in protected forms)
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Optional: Store CSRF token in a variable for easy access
$csrf = $_SESSION['csrf_token'];

// Optional: Load config if not already loaded
if (!isset($conn)) {
    require_once __DIR__ . '/../config.php';
}
?>
