<?php
include_once('../config.php');
if (session_status() === PHP_SESSION_NONE) session_start();

function getImagePath($path) {
    // Normalize path
    $path = ltrim($path, '/');

    // If the file exists in blog folder, return normal
    if (file_exists($path)) {
        return $path;
    }

    // If file exists one folder above (correct scenario)
    if (file_exists("../" . $path)) {
        return "../" . $path;
    }

    // Fallback
    return "../" . $path;
}

// Fetch settings
$logo_src = getImagePath($settings['logo'] ?? 'assets/default-logo.png');
$site_name = htmlspecialchars($settings['site_name'] ?? 'My Site');
$developer = htmlspecialchars($settings['developer'] ?? 'Developer');
$developer_website = htmlspecialchars($settings['developer_website'] ?? '#');

// Get category slug
$slug = $_GET['slug'] ?? '';
$slug = trim($slug);

// Fetch category
$stmt = $conn->prepare("SELECT id, category FROM blog_categories WHERE slug=? LIMIT 1");
$stmt->bind_param("s", $slug);
$stmt->execute();
$catRes = $stmt->get_result();

if (!$catRes || $catRes->num_rows == 0) {
    die("Invalid category.");
}
$category = $catRes->fetch_assoc();
$cid = $category['id'];

// Fetch posts
$posts = [];
$stmt2 = $conn->prepare("SELECT id, title, slug, image, posting_date FROM blog_post WHERE cid=? ORDER BY id DESC");
$stmt2->bind_param("i", $cid);
$stmt2->execute();
$res2 = $stmt2->get_result();

while ($row = $res2->fetch_assoc()) {
    $row['image'] = getImagePath($row['image']);
    $posts[] = $row;
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title><?= htmlspecialchars($category['category']) ?> - <?= $site_name ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
html, body {
  height: 100%;
}

body {
  background: linear-gradient(135deg, #f8f9fa, #e9ecef);
  display: flex;
  flex-direction: column;
  min-height: 100vh;
}

.payment-header {
  background:#fff;
  padding:20px 0;
  box-shadow:0 2px 10px rgba(0,0,0,0.05);
}

.payment-header .logo { max-height:60px; }

.card-cat {
  border:none;
  border-radius:20px;
  overflow:hidden;
  box-shadow:0 4px 15px rgba(0,0,0,0.1);
  transition:transform .2s;
}

.card-cat:hover {
  transform: translateY(-5px);
}

.card-cat img {
  width:100%;
  height:180px;
  object-fit:cover;
}

footer {
  margin-top: auto;  /* FIXED */
  background:#fff;
  text-align:center;
  padding:15px 0;
  font-size:14px;
  color:#555;
  border-top:1px solid #eee;
}

footer a {
  color:#0d6efd;
  text-decoration:none;
}

</style>
</head>

<body>

<!-- Header -->
<header class="payment-header text-center shadow-sm">
  <div class="container">
            <img src="<?= htmlspecialchars($logo_src, ENT_QUOTES, 'UTF-8') ?>" alt="Logo" class="logo">
  </div>
</header>

<div class="container py-5">

  <h3 class="fw-bold mb-4 text-center">
    <?= htmlspecialchars($category['category']) ?> Posts
  </h3>

  <div class="row g-4">
    <?php if (count($posts)): ?>
      <?php foreach ($posts as $p): ?>
        <div class="col-md-4 col-sm-6">
          <a href="blog-post.php?slug=<?= urlencode($p['slug']) ?>" class="text-decoration-none">
            <div class="card card-post">
              <img src="<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['title']) ?>">
              <div class="p-3">
                <h5 class="fw-semibold text-dark">
                  <?= htmlspecialchars($p['title']) ?>
                </h5>
                <small class="text-muted"><?= $p['posting_date'] ?></small>
              </div>
            </div>
          </a>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p class="text-center text-muted">No posts available in this category.</p>
    <?php endif; ?>
  </div>
</div>

<!-- Footer -->
<footer>
  © <?= date("Y") ?> <?= $site_name ?> |
  Designed by <a href="<?= $developer_website ?>" target="_blank"><?= $developer ?></a>
</footer>

</body>
</html>
