<?php
include_once('../config.php');
if (session_status() === PHP_SESSION_NONE) session_start();

// CSRF
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf = $_SESSION['csrf_token'];

// Fetch settings
$settings = $settings ?? [];

function getImagePath($path) {
    // Normalize path
    $path = ltrim($path, '/');

    // If the file exists in blog folder, return normal
    if (file_exists($path)) {
        return $path;
    }

    // If file exists one folder above (correct scenario)
    if (file_exists("../" . $path)) {
        return "../" . $path;
    }

    // Fallback
    return "../" . $path;
}


$logo_src = !empty($settings['logo']) ? getImagePath($settings['logo']) : 'assets/default-logo.png';
$site_name = htmlspecialchars($settings['site_name'] ?? 'My Site');
$developer = htmlspecialchars($settings['developer'] ?? 'Developer');
$developer_website = htmlspecialchars($settings['developer_website'] ?? '#');

// Fetch blog categories
$cats = [];
$sql = "SELECT id, category, slug, thumbnail FROM blog_categories ORDER BY id DESC";
$res = $conn->query($sql);
if ($res && $res->num_rows > 0) {
    while ($row = $res->fetch_assoc()) {
        $row['thumbnail'] = getImagePath($row['thumbnail']);
        $cats[] = $row;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Categories - <?= $site_name ?></title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
html, body {
  height: 100%;
}

body {
  background: linear-gradient(135deg, #f8f9fa, #e9ecef);
  display: flex;
  flex-direction: column;
  min-height: 100vh;
}

.payment-header {
  background:#fff;
  padding:20px 0;
  box-shadow:0 2px 10px rgba(0,0,0,0.05);
}

.payment-header .logo { max-height:60px; }

.card-cat {
  border:none;
  border-radius:20px;
  overflow:hidden;
  box-shadow:0 4px 15px rgba(0,0,0,0.1);
  transition:transform .2s;
}

.card-cat:hover {
  transform: translateY(-5px);
}

.card-cat img {
  width:100%;
  height:180px;
  object-fit:cover;
}

footer {
  margin-top: auto;  /* FIXED */
  background:#fff;
  text-align:center;
  padding:15px 0;
  font-size:14px;
  color:#555;
  border-top:1px solid #eee;
}

footer a {
  color:#0d6efd;
  text-decoration:none;
}

</style>
</head>

<body>

<!-- Header -->
<header class="payment-header text-center shadow-sm">
  <div class="container">
    <a href="index.php">
              <img src="<?= htmlspecialchars($logo_src, ENT_QUOTES, 'UTF-8') ?>" alt="Logo" class="logo">
    </a>
  </div>
</header>

<div class="container py-5">
  <h3 class="fw-bold mb-4 text-center">Browse Categories</h3>

  <div class="row g-4">
    <?php if (count($cats) > 0): ?>
      <?php foreach ($cats as $c): ?>
        <div class="col-md-4 col-sm-6">
          <a href="categories.php?slug=<?= urlencode($c['slug']) ?>" class="text-decoration-none">
            <div class="card card-cat">
              <img src="<?= htmlspecialchars($c['thumbnail']) ?>" alt="<?= htmlspecialchars($c['category']) ?>">
              <div class="p-3 text-center">
                <h5 class="fw-semibold mb-0 text-dark"><?= htmlspecialchars($c['category']) ?></h5>
              </div>
            </div>
          </a>
        </div>
      <?php endforeach; ?>

    <?php else: ?>
      <p class="text-center text-muted">No categories found.</p>
    <?php endif; ?>
  </div>

</div>

<!-- Footer -->
<footer>
  <p>© <?= date("Y"); ?> <?= $site_name ?> |
    Designed by <a href="<?= $developer_website ?>" target="_blank"><?= $developer ?></a>
  </p>
</footer>

</body>
</html>
