<?php include_once('./config.php'); ?>
<?php
$sliderImages = [];
$index = 1;

// ✅ MAX 20 sliders to avoid infinite loop
while ($index <= 20) {

    $sliderName = "Slider " . $index;
    $media = getMedia($conn, $sliderName);

    // ✅ Stop if empty OR file missing
    if (empty($media) || !file_exists($media)) {
        break;
    }

    $sliderImages[] = $media;
    $index++;
}
?>

<?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Home2' && $section['visiblity'] == '1'): ?>
  
  <!-- ✅ Start Carousel Section -->
  <section id="carousel-area" class="mt-2">
    <div id="homeCarousel" class="carousel slide" data-bs-ride="carousel">

      <!-- ✅ Indicators -->
      <div class="carousel-indicators">
        <?php foreach ($sliderImages as $i => $img): ?>
          <button type="button" data-bs-target="#homeCarousel" data-bs-slide-to="<?= $i ?>"
            class="<?= $i === 0 ? 'active' : '' ?>" aria-current="true"></button>
        <?php endforeach; ?>
      </div>

      <!-- ✅ Carousel Items -->
      <div class="carousel-inner">
        <?php foreach ($sliderImages as $i => $img): ?>
          <div class="carousel-item <?= $i === 0 ? 'active' : '' ?>">
            <img src="./<?= $img ?>" class="d-block w-100" alt="Slider <?= $i+1 ?>" style="height: 450px; object-fit: cover;">
          </div>
        <?php endforeach; ?>
      </div>

      <!-- ✅ Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#homeCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>

      <button class="carousel-control-next" type="button" data-bs-target="#homeCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>

    </div>
  </section>
  <!-- ✅ End Carousel Section -->

  <?php endif; ?>
<?php endforeach; ?>