<?php
header('Content-Type: application/json');
include_once('./config.php'); // make sure your $OPENAI_API_KEY is set there

$data = json_decode(file_get_contents('php://input'), true);
$user_message = $data['message'] ?? '';

if (!$user_message) {
    echo json_encode(['reply' => '❌ No message received.']);
    exit;
}

$payload = [
    "model" => "gpt-3.5-turbo",
    "messages" => [
        ["role" => "system", "content" => "You are a helpful assistant."],
        ["role" => "user", "content" => $user_message]
    ]
];

$ch = curl_init('https://api.openai.com/v1/chat/completions');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Authorization: ' . 'Bearer ' . $OPENAI_API_KEY
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
]);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['reply' => '❌ cURL Error: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    echo json_encode([
        'reply' => '❌ API returned HTTP ' . $http_code,
        'details' => json_decode($response, true)
    ]);
    exit;
}

$result = json_decode($response, true);
$reply = $result['choices'][0]['message']['content'] ?? null;

if (!$reply) {
    echo json_encode([
        'reply' => '❌ Unexpected API response format',
        'raw' => $result
    ]);
    exit;
}

echo json_encode(['reply' => $reply]);
?>
