<?php
ob_clean();
header('Content-Type: application/json');

require('razorpay/Razorpay.php');
use Razorpay\Api\Api;

// Load keys from database
include_once "config.php"; 
$keyId     = $settings['api_id'];      // Key ID from DB
$keySecret = $settings['secret_key'];  // Secret Key from DB



try {
    if (!isset($_POST['amount']) || !is_numeric($_POST['amount'])) {
        echo json_encode(['error' => 'Invalid amount']);
        exit;
    }

    $api = new Api($keyId, $keySecret);

    $order = $api->order->create([
        'receipt' => 'rcpt_' . time(),
        'amount' => $_POST['amount'] * 100,
        'currency' => 'INR'
    ]);

    echo json_encode(['order_id' => $order['id']]);

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}

