<?php include_once('./config.php'); ?>
<?php
function getImagePath($path) {
    if (strpos($path, '../') === 0) {
        $path = substr($path, 3);
    }
    return $path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Disclaimer | <?= htmlspecialchars($settings['site_name']) ?></title>
<link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">
  <!--====== Bootstrap css ======-->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />

  <!--====== Line Icons css ======-->
  <link rel="stylesheet" href="assets/css/lineicons.css" />

  <link rel="stylesheet" href="style.css" />

  <style>
    body {
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      background-color: #f8f9fa;
    }

    main {
      flex: 1;
      padding: 60px 0;
    }

    .terms-header {
      text-align: center;
      padding: 40px 20px 20px;
      background-color: #fff;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .terms-header img {
      max-width: 180px;
      height: auto;
      margin-bottom: 15px;
    }

    .terms-header h1 {
      font-size: 2rem;
      font-weight: 700;
      color: #333;
    }

    .terms-content {
      max-width: 900px;
      margin: 0 auto;
      background: #fff;
      padding: 40px 50px;
      border-radius: 8px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.05);
      color: #444;
      line-height: 1.7;
    }

    .terms-content p:last-child {
      margin-bottom: 0;
    }

    footer {
      background-color: #fff;
      border-top: 1px solid #ddd;
      padding: 20px 0;
      text-align: center;
      color: #555;
    }

    footer a {
      color: #007bff;
      text-decoration: none;
    }

    footer a:hover {
      text-decoration: underline;
    }

  </style>
</head>
<body>

  <!-- Header -->
  <header class="terms-header">
    <a href="index.php">
      <img src="<?= getImagePath($settings['logo']) ?>" alt="<?= htmlspecialchars($settings['site_name']) ?> Logo">
    </a>
    <h1>Disclaimer</h1>
  </header>

  <!-- Main Content -->
  <main>
    <div class="terms-content">
      <?php if (!empty(trim($settings['disclaimer']))): ?>
        <?= $settings['disclaimer'] ?>
      <?php else: ?>
        <p class="text-center">Our disclaimer will be updated soon. Please check back later.</p>
      <?php endif; ?>
    </div>
  </main>

  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> | Designed by 
      <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>

</body>
</html>
<?php $conn->close(); ?>
