<?php
// download.php — Secure file download handler

require_once 'auth.php'; // ensures user is logged in
require_once 'config.php';

// Validate and sanitize requested file
if (!isset($_GET['file']) || empty($_GET['file'])) {
    die('Invalid request.');
}

$filename = basename($_GET['file']); // Prevent directory traversal
$file_path = __DIR__ . "/uploads/" . $filename; // adjust folder if needed

if (!file_exists($file_path)) {
    die('File not found.');
}

// Set headers for secure download
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($file_path));

// Clear output buffer
ob_clean();
flush();

// Read and send file
readfile($file_path);
exit;
?>
