<?php include_once('./config.php'); ?>
<?php
function getImagePath($path) {
  if (strpos($path, '../') === 0) $path = substr($path, 3);
  return $path;
}

// fetch active batches
$batches = [];
$res = $conn->query("SELECT id, title FROM batch WHERE status='Active' AND deleted_at IS NULL ORDER BY id DESC");
while($row = $res->fetch_assoc()) $batches[] = $row;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Feedback | <?= htmlspecialchars($settings['site_name']) ?></title>
  <link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />
  <link rel="stylesheet" href="assets/css/lineicons.css" />
  <!-- Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <style>
    body {
      background: linear-gradient(135deg, #dbeafe 0%, #ffffff 100%);
      font-family: 'Poppins', sans-serif;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    main {
      flex: 1;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 30px;
    }
    .feedback-card {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 6px 18px rgba(0,0,0,0.1);
      padding: 30px;
      width: 100%;
      max-width: 550px;
      animation: fadeInUp .6s ease;
    }
    @keyframes fadeInUp {
      from { transform: translateY(40px); opacity: 0;}
      to { transform: translateY(0); opacity: 1;}
    }
    .rating-stars i {
      font-size: 24px;
      color: #ccc;
      cursor: pointer;
      transition: color .2s;
    }
    .rating-stars i.active { color: #FFD700; }
    .submit-btn {
      background: linear-gradient(45deg,#007bff,#00b4d8);
      border:none;
      color:#fff;
      padding:10px 20px;
      border-radius:8px;
      transition:.3s;
    }
    .submit-btn:hover { transform:translateY(-2px); }
  </style>
</head>
<body>

<header class="text-center py-3 shadow-sm bg-white">
  <a href="index.php"><img src="<?= getImagePath($settings['logo']) ?>" height="55" alt=""></a>
  <h4 class="mt-2 mb-0 text-primary fw-bold">Feedback</h4>
</header>

<main>
  <div class="feedback-card">
    <form id="feedbackForm">
      <!-- Batch -->
      <div class="mb-3">
        <label class="form-label fw-semibold">Select Batch <span class="text-danger">*</span></label>
        <select name="batch_id" id="batchSelect" class="form-select" required>
          <option value="">-- Select Batch --</option>
          <?php foreach($batches as $b): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['title']) ?></option>
          <?php endforeach; ?>
          <option value="other">Other / Not Enrolled</option>
        </select>
      </div>

      <!-- Student selector -->
      <div class="mb-3" id="studentSelectDiv" style="display:none;">
        <label class="form-label fw-semibold">Select Student <span class="text-danger">*</span></label>
        <select name="student_mobile" id="studentSelect" class="form-select" required></select>
      </div>

      <!-- Manual name + mobile -->
      <div id="manualInfo" style="display:none;">
        <div class="mb-3">
          <label class="form-label fw-semibold">Your Name <span class="text-danger">*</span></label>
          <input type="text" name="name" class="form-control" placeholder="Enter Your name">
        </div>
        <div class="mb-3">
          <label class="form-label fw-semibold">Mobile <span class="text-danger">*</span></label>
          <input type="tel" name="mobile" class="form-control" pattern="[0-9]{10}" maxlength="10" placeholder="Enter Your mobile">
        </div>
      </div>

      <!-- Ratings -->
      <div id="ratingSection" style="display:none;">
        <div class="mb-3">
          <label class="form-label">1)How was the Course Content ? <span class="text-danger">*</span></label>
          <div class="rating-stars" data-name="course_content">
            <?php for($i=1;$i<=5;$i++): ?><i class="lni lni-star"></i><?php endfor; ?>
          </div>
        </div>
        <div class="mb-3">
          <label class="form-label">2)How was the Trainer’s Teaching ? <span class="text-danger">*</span></label>
          <div class="rating-stars" data-name="trainer_teaching">
            <?php for($i=1;$i<=5;$i++): ?><i class="lni lni-star"></i><?php endfor; ?>
          </div>
        </div>
        <div class="mb-3">
          <label class="form-label">3)How was the Classroom/Lab Environment ? <span class="text-danger">*</span></label>
          <div class="rating-stars" data-name="environment">
            <?php for($i=1;$i<=5;$i++): ?><i class="lni lni-star"></i><?php endfor; ?>
          </div>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Message</label>
          <textarea name="message" class="form-control" rows="3" placeholder="Enter your feedback"></textarea>
        </div>

        <div id="feedbackMsg" class="mt-2"></div>

        <div class="text-center">
          <button type="submit" class="submit-btn">Submit</button>
        </div>
      </div>
    </form>
  </div>
</main>

<footer class="text-center py-3 bg-white border-top">
  <small>© <?= date("Y") ?> <?= htmlspecialchars($settings['site_name']) ?> | Designed by 
    <a href="<?= htmlspecialchars($settings['developer_website']) ?>" target="_blank"><?= htmlspecialchars($settings['developer']) ?></a>
  </small>
</footer>

<script src="assets/js/bootstrap.bundle.min.js"></script>
<script>
const batchSelect = document.getElementById('batchSelect');
const studentSelectDiv = document.getElementById('studentSelectDiv');
const studentSelect = document.getElementById('studentSelect');
const manualInfo = document.getElementById('manualInfo');
const ratingSection = document.getElementById('ratingSection');

batchSelect.addEventListener('change', async () => {
  const val = batchSelect.value;
  if (val === '') {
    studentSelectDiv.style.display = 'none';
    manualInfo.style.display = 'none';
    ratingSection.style.display = 'none';
    return;
  }
  if (val === 'other') {
    studentSelectDiv.style.display = 'none';
    manualInfo.style.display = 'block';
    ratingSection.style.display = 'block';
    return;
  }
  // fetch students for selected batch
  const res = await fetch('get-students-by-batch.php', {
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body:JSON.stringify({batch_id:val})
  });
  const data = await res.json();
  if (data.status === 'success') {
    studentSelect.innerHTML = '<option value="">-- Select Student --</option>' + data.students.map(s=>`<option value="${s.mobile}">${s.name} (${s.registration_no})</option>`).join('');
    studentSelectDiv.style.display = 'block';
    manualInfo.style.display = 'none';
    ratingSection.style.display = 'block';
  }
});

// stars
document.querySelectorAll('.rating-stars').forEach(group=>{
  const stars=group.querySelectorAll('i');
  stars.forEach((s,idx)=>{
    s.addEventListener('click',()=>{
      stars.forEach(x=>x.classList.remove('active'));
      for(let i=0;i<=idx;i++) stars[i].classList.add('active');
      group.dataset.value=idx+1;
    });
  });
});


document.getElementById('feedbackForm').addEventListener('submit', async e => {
  e.preventDefault();
  const form = e.target;
  const msg = document.getElementById('feedbackMsg');
  msg.innerHTML = '';



  // normalize values
  const batchId = (form.batch_id.value || '').trim().toLowerCase();
  const studentMobile = (form.student_mobile?.value || '').trim();
  const name = (form.name?.value || '').trim();
  const mobile = (form.mobile?.value || '').trim();
  const course = parseInt(form.querySelector('[data-name="course_content"]').dataset.value || 0);
  const trainer = parseInt(form.querySelector('[data-name="trainer_teaching"]').dataset.value || 0);
  const env = parseInt(form.querySelector('[data-name="environment"]').dataset.value || 0);
  const message = (form.message?.value || '').trim();

  
  console.log('Submitting for batch:', batchId);

  // Validation
  if (!batchId) {
    msg.innerHTML = `<div class="text-danger text-center">Please select a batch.</div>`;
    return;
  }

  if (batchId === 'other') {
    if (!name || !mobile) {
      msg.innerHTML = `<div class="text-danger text-center">Please enter your name and mobile number.</div>`;
      return;
    }
  } else {
    if (!studentMobile) {
      msg.innerHTML = `<div class="text-danger text-center">Please select a student.</div>`;
      return;
    }
  }

  if (!course || !trainer || !env) {
    msg.innerHTML = `<div class="text-danger text-center">Please give all three ratings before submitting.</div>`;
    return;
  }

  const payload = {
    batch_id: batchId,
    student_mobile: studentMobile,
    name,
    mobile,
    course_content: course,
    trainer_teaching: trainer,
    environment: env,
    message
  };

  try {
    const res = await fetch('submit-feedback.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });

    const text = await res.text(); // <-- read raw text to debug
    console.log('Response:', text);

    let data;
    try { data = JSON.parse(text); }
    catch { throw new Error('Invalid JSON from backend: ' + text); }

    msg.innerHTML = `<div class="text-center text-${data.status === 'success' ? 'success' : 'danger'}">${data.message}</div>`;
    setTimeout(() => msg.innerHTML = '', 4000);

    if (data.status === 'success') {
      form.reset();
      document.querySelectorAll('.rating-stars i').forEach(i => i.classList.remove('active'));
    }
  } catch (err) {
    console.error('Submit error:', err);
    msg.innerHTML = `<div class="text-center text-danger">Submission failed. Check console for details.</div>`;
    setTimeout(() => msg.innerHTML = '', 4000);
  }
});

</script>
<!-- jQuery (required for Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
  $('#studentSelect').select2({
    placeholder: "Search or select Student",
    allowClear: true,
    width: '100%'
  });
});
</script>
</body>
</html>
<?php $conn->close(); ?>

