<?php
session_start();
include_once('./config.php');

$type = $_GET['type'] ?? '';
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');
$limit = 10;
$offset = ($page - 1) * $limit;

// ✅ Map tab to DB type (Quiz & Live added)
$typeMap = [
  'notes' => 'Notes',
  'assignments' => 'Assignments',
  'study' => 'Study Materials',
  'downloads' => 'Downloads',
  'videos' => 'Videos',
  'links' => 'Links',
  'quiz' => 'Quiz',
  'live' => 'Live'
];

if (!isset($typeMap[$type])) {
  echo "<div class='alert alert-warning'>Invalid request.</div>";
  exit;
}

$typeValue = $typeMap[$type];

$where = "WHERE type='$typeValue' AND (deleted_at IS NULL OR deleted_at='') AND status='Active'";
if ($search) {
  $safeSearch = $conn->real_escape_string($search);
  $where .= " AND title LIKE '%$safeSearch%'";
}

$totalQuery = $conn->query("SELECT COUNT(*) AS total FROM student_corner $where");
$total = $totalQuery->fetch_assoc()['total'];
$totalPages = ceil($total / $limit);

if ($page > $totalPages && $totalPages > 0) $page = $totalPages;
$offset = ($page - 1) * $limit;

$query = $conn->query("
  SELECT id, title, link, restriction, created_at 
  FROM student_corner 
  $where ORDER BY created_at DESC 
  LIMIT $offset, $limit
");

if ($query->num_rows === 0) {
  echo "<div class='alert alert-info'>No " . htmlspecialchars($typeValue) . " found.</div>";
  exit;
}

$isLoggedIn = isset($_SESSION['subscriber_id']);
$isSubscribed = ($isLoggedIn 
                 && isset($_SESSION['subscriber_status']) 
                 && $_SESSION['subscriber_status'] === 'subscribed');


// -----------------------------
// 🎥 Videos Section
// -----------------------------
if ($type === 'videos') {
  echo "<div class='row g-4'>";
  while ($row = $query->fetch_assoc()) {
    $title = htmlspecialchars($row['title']);
    $restriction = $row['restriction'];
    $isRestricted = ($restriction === 'Restricted');
    $date = date('d M Y', strtotime($row['created_at']));

    $premiumBadge = $isRestricted 
      ? "<i class='bi bi-star-fill text-warning ms-1'></i>"
      : "";

    if ($isRestricted && !$isSubscribed) {

      $actionBtn = !$isLoggedIn 
        ? "<a href='login.php' class='btn btn-outline-primary btn-sm'>
               <i class='bi bi-box-arrow-in-right'></i> Login to Unlock
           </a>"
        : "<a href='subscription.php' class='btn btn-outline-warning btn-sm'>
               <i class='bi bi-star-fill'></i> Subscribe to Unlock
           </a>";

      echo "
      <div class='col-md-4 col-sm-6'>
        <div class='card shadow-sm border-0 h-100 text-center'>
          <div class='ratio' style='--bs-aspect-ratio: 60%; background:#000;'>
            <div class='d-flex justify-content-center align-items-center h-100'>
              <i class='bi bi-lock-fill text-white fs-2'></i>
            </div>
          </div>
          <div class='card-body p-3'>
            <h6 class='card-title text-muted fw-semibold mb-1'>$title $premiumBadge</h6>
            <p class='text-danger small mb-2'>Restricted Content</p>
            $actionBtn
          </div>
        </div>
      </div>";
    }

    else {
      $link = htmlspecialchars($row['link']);
      if (preg_match('/(youtube\.com\/watch\?v=|youtu\.be\/)([A-Za-z0-9_-]+)/', $link, $matches)) {
        $embedUrl = 'https://www.youtube.com/embed/' . $matches[2];
      } else {
        $embedUrl = $link;
      }

     echo "
<div class='col-md-4 col-sm-6'>
  <a href='watch.php?id=$row[id]' target='_block' class='text-decoration-none'>
    <div class='card shadow-sm border-0 h-100'>
      <div class='ratio' style='--bs-aspect-ratio: 60%;'>
        <iframe src='$embedUrl' allowfullscreen loading='lazy' class='rounded-top'></iframe>
      </div>
      <div class='card-body p-3'>
        <h6 class='card-title text-primary fw-semibold mb-1'>$title $premiumBadge</h6>
        <p class='text-muted small mb-0'>Uploaded on $date</p>
      </div>
    </div>
  </a>
</div>";

    }
  }
  echo '</div>';
}


// -----------------------------
// 📄 TABLE MODE (Files / Links / Quiz / Live)
// -----------------------------
else {

  echo "<div class='table-responsive'>
          <table class='table table-hover align-middle'>
          <thead class='table-light'>
          <tr>
            <th style='width:60px;'>#</th>
            <th>File</th>
          </tr>
          </thead>
          <tbody>";

  $counter = $offset + 1;

  while ($row = $query->fetch_assoc()) {
    $title = htmlspecialchars($row['title']);
    $restriction = $row['restriction'];
    $isRestricted = ($restriction === 'Restricted');
    $premiumBadge = $isRestricted ? "<i class='bi bi-star-fill text-warning ms-1'></i>" : "";
    $date = date('d M Y', strtotime($row['created_at']));
    $id = $row['id'];

    // ✅ All URL-based tabs: Links, Quiz, Live
    if (in_array($type, ['links', 'quiz', 'live'])) {

      if ($isRestricted && !$isSubscribed) {
        $titleLink = "<span class='text-muted'>$title $premiumBadge</span>
                      <small class='text-danger'>(Subscription required)</small>";
      }
      else {
        $titleLink = "<a href='access.php?id=$id' target='_blank' 
                        class='text-decoration-none text-primary fw-semibold'>
                        $title $premiumBadge 
                        <i class='bi bi-box-arrow-up-right small'></i>
                      </a>";
      }
    }

    // ✅ File-based types
    else {
      $titleLink = "<a href='student-corner-download.php?id=$id' 
                      class='text-decoration-none text-success fw-semibold'>
                      $title $premiumBadge <i class='bi bi-download small'></i>
                    </a>";
    }

    echo "<tr>
            <td class='fw-semibold'>$counter</td>
            <td>
              $titleLink<br>
              <small class='text-muted'>Uploaded on $date</small>
            </td>
          </tr>";
    $counter++;
  }

  echo "</tbody></table></div>";
}


// -----------------------------
// 📌 Pagination
// -----------------------------
if ($totalPages > 1) {
  echo "<div class='d-flex justify-content-center align-items-center mt-3'>
          <button class='btn btn-outline-primary btn-sm me-2' " . ($page <= 1 ? 'disabled' : '') . "
            onclick=\"loadData('$type', " . ($page - 1) . ")\">Prev</button>
          <span class='fw-semibold small text-muted'>Page $page of $totalPages</span>
          <button class='btn btn-outline-primary btn-sm ms-2' " . ($page >= $totalPages ? 'disabled' : '') . "
            onclick=\"loadData('$type', " . ($page + 1) . ")\">Next</button>
        </div>";
}

$conn->close();
?>





