<?php
include_once('./config.php');
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf = $_SESSION['csrf_token'];

// Optional flash message
$flash = $_SESSION['flash'] ?? null;
unset($_SESSION['flash']);

function getImagePath($path) {
  if (strpos($path, '../') === 0) {
      $path = substr($path, 3);
  }
  return $path;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Forgot Password | <?= htmlspecialchars($settings['site_name']) ?></title>
  <link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body { background-color: #f8f9fa; display: flex; flex-direction: column; min-height: 100vh; }
    main { flex: 1; }

    .payment-header { background-color: #fff; border-bottom: 2px solid #e3f2fd; padding: 20px 0; position: relative; }
    .payment-header .logo { max-height: 55px; }
    .payment-header .title { color: #007bff; font-weight: 700; font-size: 1.6rem; }

    footer { background-color: #fff; border-top: 1px solid #ddd; padding: 20px 0; text-align: center; color: #555; }
    footer a { color: #007bff; text-decoration: none; }

    #chatbotButton {
      position: fixed; bottom: 20px; right: 20px;
      background-color: #0d6efd; color: #fff; border: none; border-radius: 50%;
      width: 60px; height: 60px; font-size: 28px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
      display: flex; justify-content: center; align-items: center;
    }
    #chatbotButton:hover { transform: scale(1.1); background-color: #0b5ed7; }

    #chatWindow {
      position: fixed; bottom: 90px; right: 20px; width: 350px; max-height: 500px;
      background: #fff; border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.3);
      display: none; flex-direction: column; overflow: hidden; z-index: 1100;
      opacity: 0; transform: translateY(20px); transition: all 0.3s ease;
    }
    #chatWindow.show { display: flex; opacity: 1; transform: translateY(0); }
  </style>
</head>

<body>
  <!-- Header -->
  <header class="payment-header text-center shadow-sm">
    <div class="container">
      <a href="index.php"><img src="<?= getImagePath($settings['logo']) ?>" alt="Logo" class="logo"></a>
      
    </div>
  </header>

  <!-- Main Content -->
  <main>
    <div class="container py-5">
      <div class="row justify-content-center">
        <div class="col-md-6">
          <?php if ($flash): ?>
            <div class="alert alert-info"><?= htmlspecialchars($flash) ?></div>
          <?php endif; ?>

          <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
            <div class="card-header text-white text-center py-4"
                 style="background:linear-gradient(135deg, #007bff, #6610f2);">
              <h4 class="mb-0 fw-bold"><i class="bi bi-key-fill me-2"></i> Forgot Password</h4>
            </div>

            <div class="card-body p-4">
              <form method="post" action="forgot_action.php" novalidate>
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">

                <!-- Email -->
                <div class="mb-4">
                  <label class="form-label fw-semibold">Registered Email Address</label>
                  <div class="input-group">
                    <span class="input-group-text bg-light"><i class="bi bi-envelope"></i></span>
                    <input type="email" name="email" required class="form-control rounded-end" maxlength="255" placeholder="example@email.com">
                  </div>
                </div>

                <!-- Send Link Button -->
                <div class="d-grid mb-3">
                  <button type="submit" class="btn btn-warning btn-lg fw-semibold shadow-sm"
                          style="border-radius: 50px;">
                    <i class="bi bi-send-fill me-1"></i> Send Reset Link
                  </button>
                </div>

                <div class="text-center">
                  <small class="text-muted">Remember your password? 
                    <a href="login.php" class="fw-semibold text-decoration-none text-primary">Login</a>
                  </small>
                </div>
              </form>
            </div>
          </div>

        </div>
      </div>
    </div>
  </main>

  <!-- Chatbot -->
  <button id="chatbotButton"><i class="bi bi-chat-dots-fill"></i></button>
  <div id="chatWindow" class="d-flex flex-column">
    <div class="chat-header bg-primary text-white p-2 d-flex justify-content-between align-items-center">
      <span>AI Assistant</span>
      <button id="closeChat" class="btn btn-sm btn-light"><i class="bi bi-x"></i></button>
    </div>
    <div class="chat-body p-2" id="chatBody">
      <div class="msg bot"><span>👋 Hi! How can I help you today?</span></div>
    </div>
    <div class="chat-input d-flex border-top">
      <input type="text" id="userInput" placeholder="Type your message..." class="form-control border-0">
      <button id="sendBtn" class="btn btn-primary"><i class="bi bi-send"></i></button>
    </div>
  </div>

  <!-- Chatbot JS -->
  <script>
    const chatButton = document.getElementById("chatbotButton");
    const chatWindow = document.getElementById("chatWindow");
    const closeChat = document.getElementById("closeChat");
    const sendBtn = document.getElementById("sendBtn");
    const userInput = document.getElementById("userInput");
    const chatBody = document.getElementById("chatBody");

    chatButton.onclick = () => chatWindow.classList.toggle("show");
    closeChat.onclick = () => chatWindow.classList.remove("show");

    async function sendMessage() {
      const message = userInput.value.trim();
      if (!message) return;
      appendMessage("user", message);
      userInput.value = "";
      appendMessage("bot", "💭 Thinking...");

      try {
        const response = await fetch("chatbot.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ message })
        });
        const data = await response.json();
        removeThinking();
        appendMessage("bot", data.reply || "⚠️ No response from AI.");
      } catch (err) {
        removeThinking();
        appendMessage("bot", "⚠️ Server error. Please try again.");
      }
    }

    function appendMessage(sender, text) {
      const msgDiv = document.createElement("div");
      msgDiv.classList.add("msg", sender);
      msgDiv.innerHTML = `<span>${text}</span>`;
      chatBody.appendChild(msgDiv);
      chatBody.scrollTop = chatBody.scrollHeight;
    }
    function removeThinking() {
      const lastMsg = chatBody.querySelector(".msg.bot span:last-child");
      if (lastMsg && lastMsg.textContent === "💭 Thinking...") {
        lastMsg.parentElement.remove();
      }
    }
    sendBtn.onclick = sendMessage;
    userInput.addEventListener("keypress", (e) => { if (e.key === "Enter") sendMessage(); });
  </script>
<script>
document.addEventListener("DOMContentLoaded", () => {

    const form = document.querySelector('form[action="forgot_action.php"]');
    const submitBtn = form.querySelector("button[type='submit']");

    form.addEventListener("submit", async (e) => {
        e.preventDefault();

        const email = form.email.value.trim();
        const csrf = form.csrf_token.value;

        // Basic validation
        if (!email) {
            showAlert("Please enter your registered email.", "danger");
            return;
        }

        if (!/^\S+@\S+\.\S+$/.test(email)) {
            showAlert("Please enter a valid email address.", "danger");
            return;
        }

        // Disable button & show loader
        submitBtn.disabled = true;
        submitBtn.innerHTML = `<span class="spinner-border spinner-border-sm me-1"></span> Sending...`;

        try {
            // Send AJAX request
            const response = await fetch("forgot_action.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: new URLSearchParams({
                    email: email,
                    csrf_token: csrf
                })
            });

            const result = await response.json();

            if (result.status === "success") {
                showAlert(result.message, "success");
                form.reset();
            } else {
                showAlert(result.message || "Something went wrong.", "danger");
            }

        } catch (err) {
            showAlert("Request failed. Please try again later.", "danger");
        }

        // Reset button
        submitBtn.disabled = false;
        submitBtn.innerHTML = `<i class="bi bi-send-fill me-1"></i> Send Reset Link`;
    });

    // Helper alert function
    function showAlert(message, type = "info") {
        let alertBox = document.getElementById("formAlert");
        if (!alertBox) {
            alertBox = document.createElement("div");
            alertBox.id = "formAlert";
            form.prepend(alertBox);
        }

        alertBox.innerHTML = `
            <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
    }

});
</script>

  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= htmlspecialchars($settings['site_name']); ?> |
      Designed by <a href="<?= htmlspecialchars($settings['developer_website']); ?>" target="_blank">
        <?= htmlspecialchars($settings['developer']); ?>
      </a>
    </p>
  </footer>
</body>
</html>
<?php $conn->close(); ?>
