<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

require './office-login/PHPMailer/PHPMailer.php';
require './office-login/PHPMailer/SMTP.php';
require './office-login/PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// JSON helper
function out($status, $msg = "", $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $msg], $extra));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') out("error", "Invalid request");
if (empty($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token'])) {
    out("error", "CSRF validation failed");
}

// ====================================================
//  FETCH SUBSCRIBER BY EMAIL
// ====================================================

$email = trim($_POST['email'] ?? '');

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    out("error", "Invalid email format");
}

$stmt = $conn->prepare("SELECT id, name, email FROM subscriber WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    out("error", "Email not registered");
}

$user = $res->fetch_assoc();
$uid = $user['id'];

// ====================================================
//  GENERATE RESET TOKEN
// ====================================================

$token = bin2hex(random_bytes(32));
$hashed = password_hash($token, PASSWORD_DEFAULT);
$expires = date("Y-m-d H:i:s", time() + 3600); // valid for 1 hour

// delete old tokens and insert new one
$conn->query("DELETE FROM password_resets WHERE subscriber_id = $uid");

$stmt = $conn->prepare("INSERT INTO password_resets (subscriber_id, token, expires_at) VALUES (?, ?, ?)");
$stmt->bind_param("iss", $uid, $hashed, $expires);
$stmt->execute();

// ====================================================
//  BUILD RESET LINK
// ====================================================

$reset_link = $settings['base_url'] . "reset.php?id=" . $uid . "&token=" . $token;

// ====================================================
//  SELF-CONTAINED SENDMAIL FUNCTION
// ====================================================


function sendMail($to, $subject, $message) {
    global $conn;

    // Fetch SMTP settings from settings table
    $set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM settings LIMIT 1"));

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = $set['smtp_host'];
        $mail->SMTPAuth   = true;

        // If Brevo & credentials empty -> pull from environment
        if ($set['smtp_host'] == "smtp-relay.brevo.com" &&
            (empty($set['username']) || empty($set['password']))) {

            $mail->Username = getenv('SMTP_USER');
            $mail->Password = getenv('SMTP_PASS');

        } else {
            $mail->Username = $set['username'];
            $mail->Password = $set['password'];
        }

        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $set['port_number'];

        $mail->setFrom($set['sender_email'], $set['display_name_email']);
        $mail->addAddress($to);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;

        if ($mail->send()) return true;
        return $mail->ErrorInfo;

    } catch (Exception $e) {
        return "Mail Error: " . $e->getMessage() .
               ". Please ask admin to verify email settings.";
    }
}

// ====================================================
//  EMAIL TEMPLATE
// ====================================================

$subject = "Password Reset Request - " . $settings['site_name'];

$message = "
    <h2>Password Reset Request</h2>
    <p>Hello <strong>{$user['name']}</strong>,</p>

    <p>We received a request to reset your password for your account at <strong>" . $settings['site_name'] . "</strong>.</p>

    <p><a href='$reset_link' 
          style='padding:10px 20px; background:#ff9800; color:#fff; text-decoration:none; border-radius:5px;'>  
          Reset Password  
       </a></p>
       or
       <p><a href='$reset_link'> $reset_link </a></p>

    <p>If you did not request this, please ignore this email.  
       This link is valid for <strong>1 hour</strong>.</p>

    <br>
    <p>Regards,<br><strong>" . $settings['site_name'] . "</strong></p>
";

// ====================================================
//  SEND EMAIL
// ====================================================

$result = sendMail($user['email'], $subject, $message);

if ($result !== true) {
    out("error", "Email sending failed: " . $result);
}

out("success", "Password reset link sent to your email.");


