<?php
include_once('./config.php');
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$batch_id = intval($data['batch_id']);
$today = date('Y-m-d');

if (!$batch_id) {
  echo json_encode(['status' => 'error', 'message' => 'Missing batch_id']);
  exit;
}

// Fetch students enrolled in the selected batch, excluding those who already marked attendance today
$q = $conn->query("
  SELECT s.name, s.mobile, s.registration_no
  FROM enrolments e
  JOIN student s ON e.mobile = s.mobile
  WHERE e.bid = '$batch_id'
    AND s.deleted_at IS NULL
    AND s.mobile NOT IN (
      SELECT a.student_mobile FROM attendance a
      WHERE a.bid = '$batch_id'
        AND DATE(a.date) = '$today'
    )
  ORDER BY s.name ASC
");

$students = [];
while ($r = $q->fetch_assoc()) {
  $students[] = $r;
}

if (count($students) > 0) {
  echo json_encode(['status' => 'success', 'students' => $students]);
} else {
  echo json_encode(['status' => 'empty', 'message' => 'All students have marked attendance today.']);
}

$conn->close();
?>

