<?php
include_once('./config.php');
header('Content-Type: application/json; charset=utf-8');
ob_clean();

$data = json_decode(file_get_contents("php://input"), true);
$batch_id = isset($data['batch_id']) ? intval($data['batch_id']) : 0;

if (!$batch_id) {
  echo json_encode(['status' => 'error', 'message' => 'Missing batch_id']);
  exit;
}

$sql = "
  SELECT s.name, s.mobile, s.registration_no
  FROM enrolments e
  JOIN student s ON e.mobile = s.mobile
  WHERE e.bid = '$batch_id'
    AND s.deleted_at IS NULL
    AND s.status = 'Active'
";

$q = $conn->query($sql);

if (!$q) {
  echo json_encode(['status' => 'error', 'message' => 'Query failed: ' . $conn->error]);
  exit;
}

$students = [];
while ($r = $q->fetch_assoc()) {
  $students[] = $r;
}

// ✅ Handle all 3 conditions clearly
if (count($students) === 0) {
  echo json_encode([
    'status' => 'empty',
    'message' => 'All students have already marked attendance for this batch today.'
  ], JSON_UNESCAPED_UNICODE);
} else {
  echo json_encode([
    'status' => 'success',
    'students' => $students
  ], JSON_UNESCAPED_UNICODE);
}

$conn->close();
