<?php include_once('./config.php'); 


// Fetch ad banner paths from settings table
$settingsQuery = "SELECT * FROM settings LIMIT 1";
$settingsResult = mysqli_query($conn, $settingsQuery);
$settings = mysqli_fetch_assoc($settingsResult);


if (isset($settings['website_status']) && $settings['website_status'] === 'No') {
    header("Location: ./office-login");
    exit;
}

// ---- CHECK VALIDITY EXPIRY ----
if (!empty($settings['validity'])) {
    $today = date("Y-m-d");
    $validity = $settings['validity'];

    if ($today > $validity) {
        header("Location: ./expired.php");
        exit();
    }
}

function getImagePath($path) {
    // Remove leading "../" if present
    if (strpos($path, '../') === 0) {
        $path = substr($path, 3);
    }
    return $path;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <!--====== Required meta tags ======-->
  <meta charset="utf-8" />
  <meta http-equiv="x-ua-compatible" content="ie=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <!--====== Title ======-->
  <title><?= $settings['site_title'] ?></title>
  <meta name="description" content="<?= $settings['meta_description'] ?>">
  <meta name="keywords" content="<?= $settings['meta_keywords'] ?>">

  <!-- Social Media Open Graph -->
  <meta property="og:title" content="<?= $settings['site_title'] ?>">
  <meta property="og:description" content="<?= $settings['meta_description'] ?>">
  <meta property="og:type" content="website">
  <meta property="og:url" content="<?= $settings['base_url'] ?>">
  <meta property="og:image" content="<?= $settings['og_image'] ?>">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="<?= $settings['site_title'] ?>">
  <meta name="twitter:description" content="<?= $settings['meta_description'] ?>">
  <meta name="twitter:image" content="<?= $settings['og_image'] ?>">
  <?= $settings['head_scripts'] ?>

  <!--====== Favicon Icon ======-->

<link rel="icon" type="image/x-icon" href="<?= getImagePath($settings['fevicon']) ?>">

  <!--====== Bootstrap css ======-->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />

  <!--====== Line Icons css ======-->
  <link rel="stylesheet" href="assets/css/lineicons.css" />

  <!--====== Tiny Slider css ======-->
  <link rel="stylesheet" href="assets/css/tiny-slider.css" />

  <!--====== gLightBox css ======-->
  <link rel="stylesheet" href="assets/css/glightbox.min.css" />

  <link rel="stylesheet" href="style.css" />
  <script>
document.addEventListener("DOMContentLoaded", function () {
    const navLinks = document.querySelectorAll(".navbar-nav .nav-item .page-scroll");
    const navbar = document.getElementById("navbarNine");

    navLinks.forEach(link => {
        link.addEventListener("click", () => {
            // Close the menu if it is open
            if (navbar.classList.contains("show")) {
                let bsCollapse = new bootstrap.Collapse(navbar);
                bsCollapse.hide();
            }
        });
    });
});
</script>

</head>

<body>

  <!--====== NAVBAR NINE PART START ======-->

  <section class="navbar-area navbar-nine">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <nav class="navbar navbar-expand-lg">
            <a class="navbar-brand" href="<?= $base_url ?>">
              <img src="<?= getImagePath($settings['logo_light']) ?>" alt="Logo" width='220px' />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNine"
              aria-controls="navbarNine" aria-expanded="false" aria-label="Toggle navigation">
              <span class="toggler-icon"></span>
              <span class="toggler-icon"></span>
              <span class="toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse sub-menu-bar" id="navbarNine">
              <ul class="navbar-nav me-auto">
<?php foreach ($sections as $section): ?>
  <?php if ($section['header_visibility'] == '1'): ?>

    <?php
      // Determine the label for menu
      if ($section['name'] == 'Home2') {
        $label = "Home";
      } else {
        $label = htmlspecialchars($section['name']);
      }

      // Determine href ID
      switch ($section['name']) {
        case 'Home':
          $href = '#hero-area';
          break;
        case 'Home2':
          $href = '#carousel-area';
          break;
        case 'About':
          $href = '#about';
          break;
        default:
          $href = '#' . strtolower(str_replace(' ', '', $section['name']));
          break;
      }
    ?>

    <li class="nav-item">
      <a class="page-scroll<?= $section['name'] == 'Home' ? ' active' : '' ?>" href="<?= $href ?>">
        <?= $label ?>
      </a>
    </li>

  <?php endif; ?>
<?php endforeach; ?>

  
<?php foreach ($sections as $section): ?>
    <?php if ($section['name'] == 'Student Corner'): ?>

        <?php if ($section['visiblity'] == '1'): ?>
            <!-- Student Corner visible -->
            <li>
                <div class="d-inline-block d-lg-none text-center my-3">
                    <a href="student-corner.php" class="student-corner-btn">
                        🎓 Students Corner
                    </a>
                </div>
            </li>
        <?php else: ?>
            <!-- Student Corner hidden → show settings phone -->
            <li>
                <div class="d-inline-block d-lg-none text-center my-3">
                    <a href="tel:91<?= htmlspecialchars($settings['phone']) ?>" class="student-corner-btn">
                        📞 <?= htmlspecialchars($settings['phone']) ?>
                    </a>
                </div>
            </li>
        <?php endif; ?>

    <?php endif; ?>
<?php endforeach; ?>

</ul>

            </div>
<?php foreach ($sections as $section): ?>
    <?php if ($section['name'] == 'Student Corner'): ?>

        <?php if ($section['visiblity'] == '1'): ?>
            <!-- Student Corner visible (Desktop) -->
            <div class="d-none d-lg-inline-block">
                <a href="student-corner.php" class="student-corner-btn">
                    🎓 Students Corner
                </a>
            </div>

        <?php else: ?>
            <!-- Student Corner hidden → show phone (Desktop) -->
            <div class="d-none d-lg-inline-block">
                <a href="tel:91<?= htmlspecialchars($settings['phone']) ?>" class="student-corner-btn">
                    📞 <?= htmlspecialchars($settings['phone']) ?>
                </a>
            </div>

        <?php endif; ?>

    <?php endif; ?>
<?php endforeach; ?>

          </nav>
          <!-- navbar -->
        </div>
      </div>
      <!-- row -->
    </div>
    <!-- container -->
  </section>
<style>
section {
  scroll-margin-top: 120px; /* adjust based on your navbar height */
}
.student-corner-btn {
  display: inline-block;
  background: linear-gradient(45deg, #007bff, #ff0057);
  color: #fff;
  padding: 4px 8px;
  font-size: 15px;
  font-weight: 500;
  border-radius: 50px;
  text-decoration: none;
  box-shadow: 0 0 10px rgba(255, 0, 87, 0.6);
  transition: all 0.3s ease-in-out;
  position: relative;
  overflow: hidden;
}

.student-corner-btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 0 20px rgba(0, 123, 255, 0.7);
}

.student-corner-btn::before {
  content: "";
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: rgba(255,255,255,0.2);
  transform: skewX(-30deg);
  transition: left 0.4s ease;
}

.student-corner-btn:hover::before {
  left: 100%;
}
</style>

  <!--====== NAVBAR NINE PART ENDS ======-->

  
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Home' && $section['visiblity'] == '1'): ?>
  <!-- Start header Area -->
  <section id="hero-area" class="header-area header-eight">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6 col-md-12 col-12 order-2 order-md-1 mt-3">
          <div class="header-content">
            <h1> <?= getContent($conn,'Hero Title') ?></h1>
            <p>
              <?= getContent($conn,'Hero Description') ?>
            </p>
            <div class="button">
              <a href="#contact" class="btn primary-btn">Get Started</a>
              <a href="<?= $settings['youtube'] ?>?sub_confirmation=1" target="_blank"
                class="glightbox video-button">
                <span class="btn icon-btn rounded-full">
                  <i class="lni lni-youtube"></i>
                </span>
                <span class="text">Watch Videos</span>
              </a>
            </div>
          </div>
        </div>
        <div class="col-lg-6 col-md-12 col-12 order-1 order-md-2 mt-3">
  <div class="header-image">
    <div class="video-responsive">
      <img 
        src="./<?= getMedia($conn, 'Hero Image') ?>" 
        alt="Hero Image" 
        style="width: 100%; height: 100%; object-fit: cover;"
      />
    </div>
  </div>
</div>

      </div>
    </div>
  </section>
  <?php endif; ?>
<?php endforeach; ?>
  <style>
    .video-responsive {
        position: relative;
        width: 100%;
        /* 16:9 Aspect Ratio (9 / 16 = 0.5625) */
        padding-bottom: 63.25%; 
        height: 0;
        overflow: hidden;
      }

      .video-responsive img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border-radius:10px;
      }
  </style>
  <!-- End header Area -->
  
  <!--Carousel Area-->
<?php
$sliderImages = [];
$index = 1;

// ✅ MAX 20 sliders to avoid infinite loop
while ($index <= 20) {

    $sliderName = "Slider " . $index;
    $media = getMedia($conn, $sliderName);

    // ✅ Stop if empty OR file missing
    if (empty($media) || !file_exists($media)) {
        break;
    }

    $sliderImages[] = $media;
    $index++;
}
?>


<?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Home2' && $section['visiblity'] == '1'): ?>
  
  <!-- ✅ Start Carousel Section -->
  <section id="carousel-area" class="" style="margin-top:80px;">
<div id="smartCarousel" class="carousel slide carousel-fade" data-ride="carousel">
  <div class="carousel-inner">

    <?php $active = true; ?>
    <?php foreach ($sliderImages as $img): ?>
      <div class="carousel-item <?= $active ? 'active' : '' ?>">
        <img src="./<?= $img ?>" class="carousel-image" alt="Slider">
      </div>
      <?php $active = false; ?>
    <?php endforeach; ?>

  </div>

  <a class="carousel-control-prev" href="#smartCarousel" role="button" data-slide="prev">
    <span class="carousel-control-prev-icon"></span>
  </a>

  <a class="carousel-control-next" href="#smartCarousel" role="button" data-slide="next">
    <span class="carousel-control-next-icon"></span>
  </a>
</div>

  </section>
  <!-- ✅ End Carousel Section -->

  <?php endif; ?>
<?php endforeach; ?>
<style>
.carousel-image {
    width: 100%;
    height: auto;
    object-fit: contain;   /* ✅ No cropping */
    background-color: #00122d; /* optional padding color */
}
.carousel-item {
    text-align: center;
}
.carousel-fade .carousel-item {
    opacity: 0;
    transition: opacity 0.8s ease-in-out;
}

.carousel-fade .carousel-item.active {
    opacity: 1;
}

</style>



  
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Notice' && $section['visiblity'] == '1'): ?>

<?php

// Fetch active notices
$query = "SELECT * FROM notice WHERE deleted_at IS NULL AND status = 'Active' ORDER BY id DESC";
$result = $conn->query($query);
?>

<!-- Notice Marquee Section -->
<style>
.notice-bar {
  background: #FFF9C4;  /* very light yellow */
  color: #B30000;       /* dark red text */
  padding: 10px 0;
  font-family: 'Segoe UI', sans-serif;
  font-size: 16px;
  font-weight: 500;
  position: relative;
  overflow: hidden;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
}

.notice-bar::before {
  content: "";
  color: #B30000;
  margin-right: 15px;
  padding-left: 15px;
}

.notice-bar marquee {
  width: calc(100% - 100px);
}

.notice-text {
  display: inline-block;
  margin-right: 50px;
  background: rgba(255, 0, 0, 0.1); /* light red tint */
  padding: 5px 15px;
  border-radius: 20px;
  color: #B30000; /* dark red text */
  transition: background 0.3s ease;
}

.notice-text:hover {
  background: rgba(255, 0, 0, 0.2);
}

</style>

<div class="notice-bar">
  <marquee behavior="scroll" direction="left" scrollamount="5" onmouseover="this.stop();" onmouseout="this.start();">
    <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <span class="notice-text">🔔 NOTICE : <?= htmlspecialchars($row['notice'] ?? $row['notice']); ?></span>
        <?php endwhile; ?>
    <?php else: ?>
        <span class="notice-text">No active notices available.</span>
    <?php endif; ?>
  </marquee>
</div>




  <?php endif; ?>
<?php endforeach; ?>

<?php if (!empty($settings['home_header_ad'])): ?>
  <section class="ad-banner my-3 text-center">
    <img src="<?php echo htmlspecialchars($settings['home_header_ad']); ?>" alt="Header Ad" class="img-fluid rounded shadow-sm" style="max-width:100%; height:auto;">
  </section>
<?php endif; ?>



  <!--====== ABOUT FIVE PART START ======-->
 <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'About' && $section['visiblity'] == '1'): ?>
  <section id="about" class="about-area about-five">
    <div class="container">
        <center><h2 class="fw-bold"><?php echo $section['title'] ?></h2>
         <p class="mt-2"><?php echo $section['description'] ?></p></center>
      <div class="row align-items-center mt-5">
        <div class="col-lg-6 col-12">
          <div class="about-image-five">
            <svg class="shape" width="106" height="134" viewBox="0 0 106 134" fill="none"
              xmlns="http://www.w3.org/2000/svg">
              <circle cx="1.66654" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="1.66654" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="16.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="16.333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="30.9998" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6665" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="31" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="74.6668" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="45.6665" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="89.3333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="1.66679" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="16.3335" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="31.0001" r="1.66667" fill="#DADADA" />
              <circle cx="60.3333" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="45.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="60.3335" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="88.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="117.667" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="74.6668" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="103" r="1.66667" fill="#DADADA" />
              <circle cx="60.333" cy="132" r="1.66667" fill="#DADADA" />
              <circle cx="104" cy="132" r="1.66667" fill="#DADADA" />
            </svg>
            <img src="assets/images/about-img.jpg" alt="about" />
          </div>
        </div>
        <div class="col-lg-6 col-12">
          <div class="about-five-content">
            <!--<h2 class="main-title fw-bold"><?= $settings['about_site'] ?></h2>-->
            <div class="about-five-tab">
              <nav>
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                  <button class="nav-link active" id="nav-who-tab" data-bs-toggle="tab" data-bs-target="#nav-who"
                    type="button" role="tab" aria-controls="nav-who" aria-selected="true">Who We Are</button>
                  <button class="nav-link" id="nav-vision-tab" data-bs-toggle="tab" data-bs-target="#nav-vision"
                    type="button" role="tab" aria-controls="nav-vision" aria-selected="false">Vision & Mission</button>
                  <button class="nav-link" id="nav-history-tab" data-bs-toggle="tab" data-bs-target="#nav-history"
                    type="button" role="tab" aria-controls="nav-history" aria-selected="false">Philosophy</button>
                </div>
              </nav>
              <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade show active" id="nav-who" role="tabpanel" aria-labelledby="nav-who-tab">
                  <?= getContent($conn,'Who we are') ?>
                  
                </div>
                <div class="tab-pane fade" id="nav-vision" role="tabpanel" aria-labelledby="nav-vision-tab">
                  <?= getContent($conn,'Vision & Mission') ?>
                </div>
                <div class="tab-pane fade" id="nav-history" role="tabpanel" aria-labelledby="nav-history-tab">
                  <?= getContent($conn,'Philosophy') ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- container -->
  </section>
    <?php endif; ?>
<?php endforeach; ?>
<style>
    .about-area .about-image-five {
  position: sticky;         /* keeps image fixed relative to container */
  top: 0;                   /* sticks from top of section */
  align-self: flex-start;   /* keeps it aligned at the top */
}

.about-area .about-image-five img {
  width: 100%;
  height: auto;             /* keep original aspect ratio */
  object-fit: cover;        /* ensures no distortion */
}

.about-area .row.align-items-center {
  align-items: flex-start !important; /* prevents vertical stretching */
}

.about-area .col-lg-6 {
  display: flex;
  flex-direction: column;
}

.about-area .about-five-content {
  flex: 1;
}

</style>
  <!--====== ABOUT FIVE PART ENDS ======-->

  <!-- ===== service-area start ===== -->
  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Services' && $section['visiblity'] == '1'): ?>
<section id="services" class="services-area services-eight pt-100 pb-70">

  <!-- Section title -->
  <div class="section-title-five">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="content text-center">  
            <h2 class="fw-bold"><?= htmlspecialchars($section['title']) ?></h2>
            <p><?= htmlspecialchars($section['description']) ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Services cards -->
  <div class="container">
    <div class="row justify-content-center text-center">
      <?php
      $serviceQuery = "SELECT title, description, image FROM services 
                       WHERE status = 'Active' 
                         AND deleted_at IS NULL 
                       ORDER BY created_at ASC";
      $serviceResult = mysqli_query($conn, $serviceQuery);

      if ($serviceResult && mysqli_num_rows($serviceResult) > 0):
        while ($service = mysqli_fetch_assoc($serviceResult)):
      ?>
      <div class="col-lg-4 col-md-6 mb-4">
        <div class="single-services p-3 h-100">
          <?php if (!empty($service['image'])): ?>
          <div class="d-flex justify-content-center mb-3">
            <img src="./office-login/<?= htmlspecialchars($service['image']) ?>" 
                 alt="<?= htmlspecialchars($service['title']) ?>" 
                 class="img-fluid" 
                 style="max-height: 60px;">
          </div>
          <?php endif; ?>
          <div class="service-content">
            <h4><?= htmlspecialchars($service['title']) ?></h4>
            <p><?= nl2br(htmlspecialchars($service['description'])) ?></p>
          </div>
        </div>
      </div>
      <?php
        endwhile;
      else:
      ?>
        <div class="col-12">
          <p class="text-center">No services available at the moment.</p>
        </div>
      <?php endif; ?>
    </div>
  </div>

</section>
<?php endif; ?>
<?php endforeach; ?>

<!-- ===== service-area end ===== -->


<!-- Start Training Area -->
<?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Courses' && $section['visiblity'] == '1'): ?>
<section id="courses" class="pricing-area pricing-fourteen py-5">
  <div class="section-title-five">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="content text-center">
    <h2 class="fw-bold"><?php echo $section['title']; ?></h2>
    <?php echo $section['description']; ?>
</div>

        </div>
      </div>
    </div>
  </div>

  <div class="container">
    <div class="row justify-content-center">

      <?php
      // Fetch active courses from database
      $courseQuery = "SELECT name, description, image FROM course 
                      WHERE status = 'Active' 
                        AND deleted_at IS NULL 
                      ORDER BY created_at DESC";

      $courseResult = mysqli_query($conn, $courseQuery);

      if ($courseResult && mysqli_num_rows($courseResult) > 0):
        while ($course = mysqli_fetch_assoc($courseResult)):
      ?>

      <div class="col-lg-4 col-md-6 col-12 mb-4">
        <div class="pricing-style-fourteen h-100 d-flex flex-column">

          <!-- Optional image at top -->
          <?php if (!empty($course['image'])): ?>
            <img src="./office-login/<?= htmlspecialchars($course['image']) ?>" alt="<?= htmlspecialchars($course['name']) ?>" class="img-fluid mb-3 rounded">
          <?php endif; ?>

          <!-- Course content -->
          <div class="table-head">
    <h6 class="title"><?= htmlspecialchars($course['name']) ?></h6>
    <div style="text-align: left;">
        <?= $course['description'] ?>
    </div>
</div>


          <!-- Spacer to push button to bottom -->
          <div class="mt-auto pt-3 mb-2">
            <a href="#contact" class="btn primary-btn-outline w-100">
              Get Started
            </a>
          </div>

        </div>
      </div>

      <?php 
        endwhile;
      else:
      ?>
        <div class="col-12 text-center">
          <p>No training programs available at the moment.</p>
        </div>
      <?php endif; ?>

    </div>
  </div>
</section>
<style>
    .pricing-style-fourteen img {
    width: 100%;       /* Makes image full width of the card */
    height: 200px;     /* Fixed height */
    object-fit: cover; /* Crops image to fit without stretching */
    border-radius: 0.5rem; /* Optional: matches existing rounded style */
}

</style>
 <?php endif; ?>
<?php endforeach; ?>
<!--/ End Training Area -->



<!--/ Start Gallery Area -->
<?php foreach ($sections as $section): ?>
<?php if ($section['name'] == 'Gallery' && $section['visiblity'] == '1'): ?>

<?php
$gallery = [];
$sql = "SELECT * FROM gallery WHERE deleted_at IS NULL AND status='Active' ORDER BY id DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
  while ($row = $result->fetch_assoc()) {
    $gallery[] = $row;
  }
}
$tags = array_unique(array_column($gallery, 'tag'));
?>

<section id="gallery" class="gallery-area py-5">
  <div class="container text-center">
    <h2 class="fw-bold mb-4">Gallery</h2>

    <?php if (!empty($gallery)): ?>
      <!-- Filter Buttons -->
      <div id="gallery-filters" class="mb-4">
        <button class="filter-btn active" data-filter="all">All</button>
        <?php foreach ($tags as $tag): ?>
          <button class="filter-btn" data-filter="<?php echo htmlspecialchars($tag); ?>">
            <?php echo ucfirst($tag); ?>
          </button>
        <?php endforeach; ?>
      </div>

      <!-- Gallery Grid -->
<div class="row g-4 gallery-grid justify-content-center">
  <?php foreach ($gallery as $item): ?>
    <?php
      $tag = htmlspecialchars($item['tag']);
      $path = htmlspecialchars($item['image_path']);
      $isYoutube = preg_match('/(youtube\.com|youtu\.be)/i', $path);
      $youtubeId = '';

      // Extract YouTube video ID
      if ($isYoutube) {
        if (preg_match('/(?:youtube\.com\/.*v=|youtu\.be\/)([^&]+)/', $path, $matches)) {
          $youtubeId = $matches[1];
        }
      }
    ?>
    <div class="col-lg-3 col-md-4 col-sm-6 gallery-item" data-tag="<?= $tag ?>">
      <div class="gallery-box position-relative">
        
        <?php if ($isYoutube && $youtubeId): ?>
          <!-- YouTube Thumbnail -->
          <div class="gallery-media youtube-thumb" data-video-id="<?= $youtubeId ?>">
            <img src="https://img.youtube.com/vi/<?= $youtubeId ?>/hqdefault.jpg" class="img-fluid rounded" alt="<?= $tag ?>">
            <div class="video-overlay">
              <button class="play-btn"><i class="lni lni-play"></i></button>
            </div>
          </div>
        <?php else: ?>
          <!-- Image Thumbnail -->
          <img src="./office-login/<?= $path ?>" class="img-fluid rounded gallery-media" alt="<?= $tag ?>">
        <?php endif; ?>

        <div class="gallery-caption text-center">
          <span><?= ucfirst($tag) ?></span>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>


    <?php else: ?>
      <div class="no-gallery-message mt-5">
        <p class="text-muted fs-5">No images or videos have been added yet.</p>
      </div>
    <?php endif; ?>
  </div>
</section>

<!-- Overlay Lightbox -->
<div id="lightboxOverlay" class="lightbox-overlay">
  <span class="close-btn">&times;</span>
  <div class="lightbox-content text-center">
    <img id="lightboxImage" src="" alt="Gallery" class="img-fluid rounded d-none">
    <video id="lightboxVideo" class="d-none" controls></video>
  </div>
</div>

<style>
/* ---------- Gallery Styles ---------- */
.gallery-area {
  background: #f9f9f9;
}

.filter-btn {
  background: #fff;
  border: 1px solid #ccc;
  border-radius: 25px;
  padding: 7px 16px;
  margin: 5px;
  cursor: pointer;
  transition: all 0.3s ease;
}
.filter-btn.active,
.filter-btn:hover {
  background: #007bff;
  color: #fff;
  border-color: #007bff;
}

.gallery-box {
  position: relative;
  overflow: hidden;
  border-radius: 12px;
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  cursor: pointer;
}
.gallery-media {
  width: 100%;
  height: 230px;
  object-fit: cover;
  transition: transform 0.3s ease;
}
.gallery-box:hover .gallery-media {
  transform: scale(1.05);
}

.gallery-caption {
  position: absolute;
  bottom: 0;
  width: 100%;
  background: rgba(0, 0, 0, 0.6);
  color: #fff;
  padding: 6px 0;
  font-size: 14px;
  border-bottom-left-radius: 12px;
  border-bottom-right-radius: 12px;
}

.video-overlay {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  background: rgba(0, 0, 0, 0.5);
  border-radius: 50%;
  padding: 12px 15px;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: background 0.3s;
}
.play-btn {
  background: none;
  border: none;
  color: #fff;
  font-size: 26px;
}
.video-overlay:hover {
  background: rgba(0, 0, 0, 0.7);
}

/* ---------- Lightbox Overlay ---------- */
.lightbox-overlay {
  display: none;
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0, 0, 0, 0.9);
  z-index: 1050;
  justify-content: center;
  align-items: center;
  overflow: auto;
  padding: 30px 0;
}
.lightbox-overlay.active {
  display: flex;
}

.lightbox-content {
  position: relative;
  width: 95%;
  max-width: 1200px;
  max-height: 95vh;
  display: flex;
  justify-content: center;
  align-items: center;
}
.lightbox-content img,
.lightbox-content video {
  width: 100%;
  height: auto;
  max-height: 90vh;
  border-radius: 10px;
  box-shadow: 0 0 20px rgba(0,0,0,0.6);
}

.close-btn {
  position: absolute;
  top: 25px;
  right: 35px;
  font-size: 35px;
  color: #fff;
  cursor: pointer;
  z-index: 1100;
  background: rgba(0,0,0,0.5);
  border-radius: 50%;
  padding: 5px 12px;
  transition: background 0.3s;
}
.close-btn:hover {
  background: rgba(255,255,255,0.2);
}

.no-gallery-message {
  background: #f8f9fa;
  border: 1px dashed #ccc;
  padding: 40px;
  border-radius: 10px;
  display: inline-block;
}
.youtube-thumb {
  position: relative;
  width: 100%;
  height: 230px;
  overflow: hidden;
  border-radius: 12px;
  cursor: pointer;
}

.youtube-thumb img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

</style>

<script>
// ---------- Filtering ----------
document.querySelectorAll('.filter-btn').forEach(btn => {
  btn.addEventListener('click', function() {
    document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
    this.classList.add('active');
    const filter = this.dataset.filter;
    document.querySelectorAll('.gallery-item').forEach(item => {
      if (filter === 'all' || item.dataset.tag === filter) {
        item.style.display = 'block';
      } else {
        item.style.display = 'none';
      }
    });
  });
});

const overlay = document.getElementById('lightboxOverlay');
const lightboxImg = document.getElementById('lightboxImage');
const lightboxVid = document.getElementById('lightboxVideo');
const closeBtn = document.querySelector('.close-btn');
let youtubeFrame = null;

document.querySelectorAll('.gallery-media').forEach(media => {
  media.addEventListener('click', () => {
    overlay.classList.add('active');
    lightboxVid.classList.add('d-none');
    lightboxImg.classList.add('d-none');
    if (youtubeFrame) youtubeFrame.remove();

    if (media.tagName === 'IMG' && !media.classList.contains('youtube-thumb')) {
      // Regular image
      lightboxImg.classList.remove('d-none');
      lightboxImg.src = media.src;
    } else if (media.classList.contains('youtube-thumb')) {
      // YouTube video
      const videoId = media.getAttribute('data-video-id');
      youtubeFrame = document.createElement('iframe');
      youtubeFrame.src = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
      youtubeFrame.allow = "autoplay; encrypted-media";
      youtubeFrame.classList.add('rounded');
      youtubeFrame.style.width = '100%';
      youtubeFrame.style.maxHeight = '90vh';
      youtubeFrame.style.border = 'none';
      overlay.querySelector('.lightbox-content').appendChild(youtubeFrame);
    } else if (media.tagName === 'VIDEO') {
      // Local video (fallback)
      lightboxVid.classList.remove('d-none');
      const source = media.querySelector('source') ? media.querySelector('source').src : media.src;
      lightboxVid.src = source;
      lightboxVid.play();
    }
  });
});

closeBtn.addEventListener('click', closeLightbox);
overlay.addEventListener('click', e => { if (e.target === overlay) closeLightbox(); });

function closeLightbox() {
  overlay.classList.remove('active');
  lightboxVid.pause();
  if (youtubeFrame) youtubeFrame.remove();
}
</script>



<?php endif; ?>
<?php endforeach; ?>
<!--/ End Gallery Area -->


  <!-- Start Cta Area -->
  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'CTA' && $section['visiblity'] == '1'): ?>
  <section id="call-action" class="call-action">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xxl-6 col-xl-7 col-lg-8 col-md-9">
          <div class="inner-content">
            <h2><?= getContent($conn,'Cta Title') ?></h2>
            <?= getContent($conn,'Cta Description') ?>
            <div class="light-rounded-buttons">
              <a href="#contact" class="btn primary-btn-outline">Get Started</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php endif; ?>
<?php endforeach; ?>
  <!-- End Cta Area -->
  
   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Testimonials' && $section['visiblity'] == '1'): ?> 
<section id="testimonials" class="testimonials py-5 bg-light">
  <div class="container">
    <h2 class="text-center mb-5"><?php echo $section['title'] ?></h2>

    <?php
    // Fetch only active text testimonials
    $query = "SELECT testimonial_id, name, review 
              FROM testimonials 
              WHERE status = 'Active' 
                AND type = 'Text' 
                AND deleted_at IS NULL 
              ORDER BY created_at DESC";

    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0): 
      $testimonials = mysqli_fetch_all($result, MYSQLI_ASSOC);
    ?>

    <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000">
      
      <!-- Carousel Items -->
      <div class="carousel-inner">
        <?php foreach ($testimonials as $index => $testimonial): ?>
          <div class="carousel-item text-center <?= $index === 0 ? 'active' : '' ?>">
            <p class="lead">“<?= htmlspecialchars($testimonial['review']) ?>”</p>
            <h5>- <?= htmlspecialchars($testimonial['name']) ?></h5>
          </div>
        <?php endforeach; ?>
      </div>

      <!-- Carousel Indicators -->
      <div class="carousel-indicators">
        <?php foreach ($testimonials as $index => $_): ?>
          <button 
            type="button" 
            data-bs-target="#testimonialCarousel" 
            data-bs-slide-to="<?= $index ?>" 
            class="<?= $index === 0 ? 'active' : '' ?>" 
            aria-current="<?= $index === 0 ? 'true' : 'false' ?>" 
            aria-label="Slide <?= $index + 1 ?>">
          </button>
        <?php endforeach; ?>
      </div>

      <!-- Carousel Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>

    </div>

    <?php else: ?>
      <p class="text-center">No text testimonials available at the moment.</p>
    <?php endif; ?>
<!--  </div>-->
<!--</section>-->

<!--<section id="video-testimonials" class="testimonials py-5 bg-light">-->
<!--  <div class="container">-->
<!--    <h2 class="text-center mb-5">What IKP'ans Share in Videos</h2>-->

    <?php
    
    function getEmbedUrl($url) {
    if (strpos($url, 'youtube.com/watch') !== false) {
        parse_str(parse_url($url, PHP_URL_QUERY), $params);
        if (isset($params['v'])) {
            return 'https://www.youtube.com/embed/' . $params['v'];
        }
    }
    // Add Vimeo or other platforms if needed
    return $url; // fallback
}

    // Fetch only active video testimonials
    $videoQuery = "SELECT testimonial_id, name, review 
                   FROM testimonials 
                   WHERE status = 'active' 
                     AND type = 'Video' 
                     AND deleted_at IS NULL 
                   ORDER BY created_at DESC";

    $videoResult = mysqli_query($conn, $videoQuery);

    if ($videoResult && mysqli_num_rows($videoResult) > 0): 
      $videos = mysqli_fetch_all($videoResult, MYSQLI_ASSOC);
    ?>

    <div class="row justify-content-center mt-5">
      <?php foreach ($videos as $video): ?>
        <div class="col-lg-3 col-md-4 mb-4">
          <div class="card shadow-sm">
            <div class="ratio ratio-16x9">
              <iframe 
    src="<?= htmlspecialchars(getEmbedUrl($video['review'])) ?>" 
    title="Video Testimonial by <?= htmlspecialchars($video['name']) ?>" 
    frameborder="0" 
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
    allowfullscreen>
</iframe>

            </div>
            <div class="card-body text-center">
              <h5 class="card-title mb-0"><?= htmlspecialchars($video['name']) ?></h5>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <?php else: ?>
      <p class="text-center">No video testimonials available at the moment.</p>
    <?php endif; ?>
  </div>
</section>
  <?php endif; ?>
<?php endforeach; ?>


   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Review' && $section['visiblity'] == '1'): ?>
<!-- 🌟 Google Review Invitation Section -->
<section id="review-section" class="py-5 review-section">
  <div class="container text-center">
    <div class="review-card p-5 rounded-4 shadow-lg">
      <div class="animate-fade-in">
        <img src="./assets/images/Google-Review-Logo.png" 
             alt="Google Reviews" class="review-logo mb-4">
        <h3 class="text-white fw-bold mb-3">Loved Your Experience at <?php echo $settings['site_title'] ?>?</h3>
        <p class="text-light mb-4 fs-5">
          Your feedback means a lot! 🌟  
          Share your thoughts and help others discover the <?php echo $settings['site_title'] ?>.
        </p>
        <a href="<?php echo $settings['google_review'] ?>" 
           target="_blank" 
           class="btn btn-lg btn-review">
           ⭐ Leave a Review
        </a>
      </div>
    </div>
  </div>
</section>

<!-- 🌈 CSS Styles -->
<style>
.review-section {
    background: radial-gradient(circle at center, #0a1930 0%, #1a1a2e 30%, #33001b 100%);
  position: relative;
  overflow: hidden;
}

.review-card {
  background: rgba(255, 255, 255, 0.05);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(255, 255, 255, 0.1);
}

.review-logo {
  width: 180px;
  filter: brightness(1.1);
}

.btn-review {
  background: #4285F4;
  color: #fff;
  border: none;
  padding: 12px 28px;
  border-radius: 50px;
  font-weight: 600;
  letter-spacing: 0.5px;
  transition: all 0.3s ease;
}
.btn-review:hover {
  background: #34A853;
  transform: translateY(-2px);
}

/* Soft animated gradient glow */
.review-section::before {
  content: "";
  position: absolute;
  top: -100px;
  left: -100px;
  width: 300px;
  height: 300px;
  background: radial-gradient(circle, rgba(66,133,244,0.3), transparent 70%);
  animation: moveGlow 10s infinite alternate ease-in-out;
  z-index: 0;
}
.review-section::after {
  content: "";
  position: absolute;
  bottom: -120px;
  right: -120px;
  width: 350px;
  height: 350px;
  background: radial-gradient(circle, rgba(234,67,53,0.3), transparent 70%);
  animation: moveGlow 12s infinite alternate ease-in-out;
  z-index: 0;
}

@keyframes moveGlow {
  0% { transform: translate(0, 0) scale(1); }
  100% { transform: translate(30px, 40px) scale(1.2); }
}

/* Fade-in effect */
.animate-fade-in {
  opacity: 0;
  transform: translateY(30px);
  animation: fadeInUp 1s forwards ease-out;
}
@keyframes fadeInUp {
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
</style>

  <?php endif; ?>
<?php endforeach; ?>

<!--Faq section-->
   <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'FAQ' && $section['visiblity'] == '1'): ?>
<section id="faq" class="faq-area py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-12">
        <h2 class="text-center mb-4"><?php echo $section['title']; ?></h2>

        <?php
        // Fetch active FAQs from the database
        $faqQuery = "SELECT faq_id, question, answer FROM faq 
                     WHERE status = 'Active' 
                       AND deleted_at IS NULL 
                     ORDER BY created_at ASC";

        $faqResult = mysqli_query($conn, $faqQuery);
         $sl=1;
        if ($faqResult && mysqli_num_rows($faqResult) > 0): 
          $faqs = mysqli_fetch_all($faqResult, MYSQLI_ASSOC);
        ?>

        <div class="accordion" id="faqAccordion">
          <?php foreach ($faqs as $index => $faq): 
            $faqId = 'faq' . $faq['faq_id'];
            $collapseId = 'collapse' . $faq['faq_id'];
            $isFirst = $index === 0;
          ?>
            <div class="accordion-item">
              <h2 class="accordion-header" id="<?= $faqId ?>">
                <button class="accordion-button <?= !$isFirst ? 'collapsed' : '' ?>" 
                        type="button" 
                        data-bs-toggle="collapse" 
                        data-bs-target="#<?= $collapseId ?>" 
                        aria-expanded="<?= $isFirst ? 'true' : 'false' ?>" 
                        aria-controls="<?= $collapseId ?>">
                   <?= $sl ?>. &nbsp;<?= $faq['question'] ?>
                </button>
              </h2>
              <div id="<?= $collapseId ?>" 
                   class="accordion-collapse collapse <?= $isFirst ? 'show' : '' ?>" 
                   aria-labelledby="<?= $faqId ?>" 
                   data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                  <?= $faq['answer'] ?>
                </div>
              </div>
            </div>
          <?php $sl++; endforeach; ?>
        </div>

        <?php else: ?>
          <p class="text-center">No FAQs available at the moment.</p>
        <?php endif; ?>
        
      </div>
    </div>
  </div>
</section>
  <?php endif; ?>
<?php endforeach; ?>

  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Newsletter' && $section['visiblity'] == '1'): ?>
<!-- Newsletter Section -->
<section class="newsletter-section py-5 text-center">
  <div class="container">
    <h2 class="text-white mb-3 fw-bold animate-fade">Stay Updated!</h2>
    <p class="text-light mb-4 animate-slide">
      Subscribe to get the latest updates, offers, and news from <strong><?php echo $settings['site_title'] ?></strong>.
    </p>

    <form id="newsletterForm" class="newsletter-form mx-auto">
      <div class="input-group input-group-lg justify-content-center">
        <input 
          type="email" 
          id="newsletterEmail" 
          class="form-control" 
          placeholder="Enter your email address" 
          required
        >
        <button class="btn btn-primary px-4" type="submit">
          Subscribe
        </button>
      </div>
    </form>

    <div id="newsletterResult" class="mt-3"></div>
  </div>
</section>

<style>
/* Animated gradient background */
.newsletter-section {
  background: linear-gradient(-45deg, #0d1b2a, #1b263b, #2d0a1f, #1a1a2e);
  background-size: 400% 400%;
  animation: bgShift 15s ease infinite;
  color: white;
  position: relative;
  overflow: hidden;
}

@keyframes bgShift {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

.newsletter-form .form-control {
  max-width: 400px;
  border-radius: 30px 0 0 30px;
  border: none;
  padding-left: 20px;
  box-shadow: none;
}

.newsletter-form .btn {
  border-radius: 0 30px 30px 0;
  background-color: #ff4c60;
  border: none;
  transition: all 0.3s ease;
}

.newsletter-form .btn:hover {
  background-color: #ff6f61;
}

.animate-fade {
  animation: fadeIn 1.2s ease-in;
}

.animate-slide {
  animation: slideIn 1.4s ease-in-out;
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-20px); }
  to { opacity: 1; transform: translateY(0); }
}

@keyframes slideIn {
  from { opacity: 0; transform: translateY(30px); }
  to { opacity: 1; transform: translateY(0); }
}
</style>

<script>
document.getElementById('newsletterForm').addEventListener('submit', async function(e) {
  e.preventDefault();
  
  const emailInput = document.getElementById('newsletterEmail');
  const email = emailInput.value.trim();
  const resultDiv = document.getElementById('newsletterResult');

  // Simple email validation
  const emailPattern = /^[^ ]+@[^ ]+\.[a-z]{2,3}$/;
  if (!email.match(emailPattern)) {
    resultDiv.innerHTML = `<div class="text-warning py-2">Please enter a valid email address.</div>`;
    emailInput.focus();
    removeAlertAfterDelay();
    return;
  }

  resultDiv.innerHTML = `<div class="text-warning small">Submitting...</div>`;

  try {
    const res = await fetch('newsletter-submit.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ email })
    });
    const data = await res.json();

    if (data.status === 'success') {
      resultDiv.innerHTML = `<div class="text-warning py-2">Thank you for subscribing!</div>`;
      emailInput.value = '';
    } else {
      resultDiv.innerHTML = `<div class="text-warning py-2">${data.message || 'Something went wrong.'}</div>`;
    }
  } catch (err) {
    console.error(err);
    resultDiv.innerHTML = `<div class="text-warning py-2">An error occurred. Please try again later.</div>`;
  }

  removeAlertAfterDelay();
});

function removeAlertAfterDelay() {
  setTimeout(() => {
    const alertBox = document.querySelector('#newsletterResult .alert');
    if (alertBox) {
      alertBox.classList.add('fade');
      setTimeout(() => {
        alertBox.remove();
      }, 500); // fade-out time
    }
  }, 4000); // 4 seconds before removal
}
</script>


  <?php endif; ?>
<?php endforeach; ?>

<!-- ========================= contact-section start ========================= -->
<?php
// Fetch subjects and references from the database before rendering the form
$query_subjects = "SELECT * FROM enquiries_subjects";
$result_subjects = mysqli_query($conn, $query_subjects);
$result_courses = mysqli_query($conn, "SELECT id, name FROM course WHERE status='Active' AND deleted_at IS NULL");

?>
  <?php foreach ($sections as $section): ?>
  <?php if ($section['name'] == 'Contact' && $section['visiblity'] == '1'): ?>
<section id="contact" class="contact-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-12">
        <div class="contact-form-wrapper">
          <div class="row">
            <div class="col-xl-10 col-lg-8 mx-auto">
              <div class="section-title text-center">
                <h2><?php echo $section['title']; ?></h2>
                <p><?php echo $section['description']; ?></p>
              </div>
            </div>
          </div>
          <!-- Form for Enquiry -->
          <form id="enquiry-form" class="contact-form">
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="name" id="name" placeholder="Name *" required />
              </div>
              <div class="col-md-6">
                <input type="email" name="email" id="email" placeholder="Email *" required />
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <input type="text" name="phone" id="phone" placeholder="Phone *" required />
              </div>
              <div class="col-md-6">
                <select name="subject" id="subject" class="form-select" required>
                  <option value="">Select Subject *</option>
                  <?php while ($row_subject = mysqli_fetch_assoc($result_subjects)) { ?>
                    <option value="<?php echo $row_subject['id']; ?>">
                      <?php echo htmlspecialchars($row_subject['subjects']); ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <input type="hidden" id="reference" name="reference" value="">

            </div>
              <!-- Dynamic Section -->
  <div class="row mt-3" id="dynamic-section" style="display:none;">
    <!-- Course Dropdown (hidden by default) -->
    <div class="col-md-12" id="course-section" style="display:none;">
      <select name="course_id" id="course_id" class="form-select">
        <option value="">Select Course</option>
        <?php while ($row_course = mysqli_fetch_assoc($result_courses)) { ?>
          <option value="<?php echo $row_course['id']; ?>">
            <?php echo htmlspecialchars($row_course['name']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <!-- General Enquiry Input (hidden by default) -->
    <div class="col-md-12" id="general-section" style="display:none;">
      <input type="text" name="subject_description" id="subject_description" placeholder="Subject of general enquiry" />
    </div>
  </div>
            <div class="row">
              <div class="col-12">
                <textarea name="message" id="message" placeholder="Type your message *" rows="5" required></textarea>
              </div>
            </div>
            <div class="row">
                <input type="hidden" name="source" id="source" value="Online" />
            </div>
            <div class="row">
              <div class="col-12">
                <div class="button text-center rounded-buttons">
                  <button type="button" id="submit-btn" class="btn primary-btn rounded-full">
                    Send Enquiry
                  </button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>
 <?php endif; ?>
<?php endforeach; ?>
<!-- JS Script for Dynamic Display -->
<script>
document.addEventListener("DOMContentLoaded", function() {
  // ===== Your existing dynamic subject logic =====
  const subjectSelect = document.getElementById("subject");
  const dynamicSection = document.getElementById("dynamic-section");
  const courseSection = document.getElementById("course-section");
  const generalSection = document.getElementById("general-section");

  subjectSelect.addEventListener("change", function() {
    const selected = this.value.trim();
    courseSection.style.display = "none";
    generalSection.style.display = "none";
    dynamicSection.style.display = "none";

    if (selected === "1") {
      dynamicSection.style.display = "flex";
      courseSection.style.display = "block";
    } else if (selected === "2") {
      dynamicSection.style.display = "flex";
      generalSection.style.display = "block";
    }
  });

  // ===== NEW: Capture "r" parameter from URL =====
  const urlParams = new URLSearchParams(window.location.search);
  const referenceValue = urlParams.get("r"); // e.g. ?r=fb → "fb"
  
  if (referenceValue) {
    document.getElementById("reference").value = referenceValue;
  }
});
</script>

<!-- ========================= contact-section end ========================= -->




<?php if (!empty($settings['home_footer_ad'])): ?>
  <section class="ad-banner my-3 text-center">
    <img src="<?php echo htmlspecialchars($settings['home_footer_ad']); ?>" alt="Footer Ad" class="img-fluid rounded shadow-sm" style="max-width:100%; height:auto;">
  </section>
<?php endif; ?>





  <!-- Start Footer Area -->
  <footer class="footer-area footer-eleven">
    <!-- Start Footer Top -->
    <div class="footer-top">
      <div class="container">
        <div class="inner-content">
          <div class="row">
            <div class="col-lg-6 col-md-6 col-12">
              <!-- Single Widget -->
              <div class="footer-widget f-about">
                <div class="logo">
                  <a href="index.php">
                    <img src="<?= getImagePath($settings['logo']) ?>" width="220px" alt="#" class="img-fluid" />
                  </a>
                </div>
                <p>
                  <?= $settings['about_site'] ?>
                </p>
                
              

            <!-- Start Social Links -->
              <div class="social-links" style="margin-top: 20px;">
                <a href="<?= $settings['youtube'] ?>" target="_blank"><i class="lni lni-youtube"></i></a>
                <a href="<?= $settings['facebook'] ?>" target="_blank"><i class="lni lni-facebook-filled"></i></a>
                <a href="<?= $settings['instagram'] ?>" target="_blank"><i class="lni lni-instagram-original"></i></a>
                <a href="<?= $settings['x'] ?>" target="_blank"><i class="lni lni-twitter-original"></i></a>
                <a href="<?= $settings['linkedin'] ?>" target="_blank"><i class="lni lni-linkedin-original"></i></a>
              </div>
               
                <!-- End Social Links -->

                <style>
                .social-links a {
                    display: inline-block;
                    margin: 0 10px;
                    font-size: 24px;
                    color: #fff; /* icon color */
                    transition: color 0.3s;
                  }

                  .social-links a:hover {
                    color: #007bff; /* color on hover */
                  }

                </style>


              </div>
              <!-- End Single Widget -->
            </div>
            <div class="col-lg-2 col-md-6 col-12">
              <!-- Single Widget -->
              <div class="footer-widget f-link">
                <h5>Navigation</h5>
                <ul>
  <?php foreach ($sections as $section): ?>
    <?php
      // Skip if not visible in footer or if it's the Hero-Home section
      if ($section['footer_visibility'] != '1' || $section['title'] === 'Hero-Home') {
        continue;
      }

      $label = htmlspecialchars($section['name']);

      // Handle special href cases
      switch ($section['name']) {
        case 'About':
          $href = '#about';
          break;
        default:
          $href = '#' . strtolower(str_replace(' ', '', $section['name']));
          break;
      }
    ?>
    <li><a href="<?= $href ?>"><?= $label ?></a></li>
  <?php endforeach; ?>
</ul>

              </div>
              <!-- End Single Widget -->
            </div>
            
            <div class="col-lg-4 col-md-6 col-12 text-white">
              <!-- Single Widget -->
              <div class="footer-widget f-link">
                <h5>Contact</h5>
                <ul>
<?php
$address = trim($settings['address']);
$mapUrl  = trim($settings['google_map']);

// Google Map SVG Icon (clean + lightweight)
$mapIcon = '<img src="./assets/images/google-map.png" width="16" height="16" style="margin-right:6px;">';

if (!empty($mapUrl)) {
?>
    <li>
        <?= $mapIcon ?>
        <a href="<?= htmlspecialchars($mapUrl) ?>" target="_blank">
            <?= !empty($address) ? htmlspecialchars($address) : "View on Google Maps" ?>
        </a>
    </li>
<?php
} elseif (!empty($address)) {
?>
    <li>
        <?= $mapIcon ?>
        <?= htmlspecialchars($address) ?>
    </li>
<?php
}
?>


  <?php if (!empty($settings['phone'])): ?>
    <li><i class="lni lni-phone"></i> <?= htmlspecialchars($settings['phone']) ?></li>
  <?php endif; ?>

  <?php if (!empty($settings['email'])): ?>
    <li><i class="lni lni-envelope"></i> <?= htmlspecialchars($settings['email']) ?></li>
  <?php endif; ?>
</ul>

                    
                  </div>
              </div>
              <!-- End Single Widget -->
            </div>
          </div>
        </div>
      </div>

    <!--/ End Footer Top -->
    <br><br> 
                <!-- Start Online Payment -->
<div class="text-center flex-wrap d-flex justify-content-center gap-2">
    <?php if($settings['attendance_button']=="1") { ?>
        <a href="attendance.php" target="_blank" class="btn btn-warning action-btn">
            Attendance
        </a>
    <?php } ?>

    <?php if($settings['pay_online_button']=="1") { ?>
        <a href="online-payment.php" target="_blank" class="btn btn-info action-btn">
            Pay Online
        </a>
    <?php } ?>

    <?php if($settings['feedback_button']=="1") { ?>
        <a href="feedback.php" target="_blank" class="btn btn-success action-btn">
            Feedback
        </a>
    <?php } ?>
</div>

<style>
/* Base style for buttons */
.action-btn {
  font-size: 15px;
  padding: 4px 12px;
  line-height: 1;
  white-space: nowrap;
  transition: all 0.2s ease;
}

/* Medium screen adjustments (tablets) */
@media (max-width: 992px) {
  .action-btn {
    font-size: 14px;
    padding: 4px 10px;
  }
}

/* Small screen adjustments (mobile) */
@media (max-width: 768px) {
  .action-btn {
    font-size: 13px;
    padding: 3px 8px;
  }
}

/* Extra small screen adjustments (tiny phones) */
@media (max-width: 576px) {
  .action-btn {
    font-size: 12px;
    padding: 2px 6px;
  }
}
</style>

    <!-- Start Footer Links -->
<div class="footer-links text-center mb-3 mt-5">
    
    <?php
    $footerPages = [
        ['label' => 'Terms & Conditions', 'link' => 'terms.php'],
        ['label' => 'Privacy Policy', 'link' => 'privacy.php'],
        ['label' => 'Disclaimer', 'link' => 'disclaimer.php']
    ];
    
    foreach ($footerPages as $index => $page):
    ?>
        <a target="_blank" href="<?= $page['link'] ?>" class="footer-link text-white"><?= $page['label'] ?></a>
        <?php if ($index < count($footerPages) - 1): ?>
            <span class="footer-separator text-white"> | </span>
        <?php endif; ?>
    <?php endforeach; ?>
</div>
<!-- End Footer Links -->

    
    <hr class="text-white">   
    <p class="copyright-text text-center text-white">
      <span>© <?php echo date("Y"); ?> <?= $settings['site_name'] ?></span> | Designed by
      <a href="<?= $settings['developer_website'] ?>">  <?= $settings['developer'] ?></a>
    </p>
  </footer>
  <!--/ End Footer Area -->

	<!-- WhatsApp Floating Button -->
	<?php if($settings['whatsapp']!='') { ?>
<a href="https://wa.me/91<?= $settings['whatsapp'] ?>?text=Hii <?= $settings['site_name'] ?>" target="_blank" class="whatsapp-button">
  <i class="lni lni-whatsapp"></i>
</a>
<?php } ?>

<a href="toggle-hero.php" class="hero-toggle-btn">Switch Hero</a>

<style>
.hero-toggle-btn {
    position: fixed;
    bottom: 20px;
    left: 20px;
    background: #222;
    color: #fff;
    padding: 10px 18px;
    border-radius: 50px;
    text-decoration: none;
    font-size: 14px;
    z-index: 99999;
    opacity: 0.85;
}
.hero-toggle-btn:hover {
    opacity: 1;
}
</style>


<!-- CSS -->
<style>
.whatsapp-button {
  position: fixed;
  bottom: 90px;
  right: 20px; /* changed from right to left */
  background-color: #25D366;
  color: #fff;
  padding: 12px 18px;
  border-radius: 50px;
  font-size: 16px;
  text-decoration: none;
  display: flex;
  align-items: center;
  gap: 8px;
  box-shadow: 0 4px 6px rgba(0,0,0,0.2);
  z-index: 9999;
  transition: transform 0.2s, box-shadow 0.2s;
}

.whatsapp-button:hover {
  transform: scale(1.1);
  box-shadow: 0 6px 12px rgba(0,0,0,0.3);
}

.whatsapp-button i {
  font-size: 24px;
}

.ad-banner {
  max-width: 1000px;   /* ⬅ responsive width */
  width: 100%;         /* ⬅ allows shrinking on mobile */
  margin-left: auto;
  margin-right: auto;  /* ⬅ centers container */
}

.ad-banner img {
  width: 100%;          /* ⬅ make image fill container */
  height: 300px;        /* fixed height */
  object-fit: cover;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}


</style>


  <a href="#" class="scroll-top btn-hover">
    <i class="lni lni-chevron-up"></i>
  </a>

  <!--====== js ======-->
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script src="assets/js/glightbox.min.js"></script>
  <script src="assets/js/main.js"></script>
  <script src="assets/js/tiny-slider.js"></script>
  <?= $settings['footer_scripts'] ?>


  <script>

    // ==== left sidebar toggle
    let sidebarLeft = document.querySelector(".sidebar-left");
    let overlayLeft = document.querySelector(".overlay-left");
    let sidebarClose = document.querySelector(".sidebar-close .close");

    overlayLeft.addEventListener("click", function () {
      sidebarLeft.classList.toggle("open");
      overlayLeft.classList.toggle("open");
    });
    sidebarClose.addEventListener("click", function () {
      sidebarLeft.classList.remove("open");
      overlayLeft.classList.remove("open");
    });

    // ===== navbar nine sideMenu
    let sideMenuLeftNine = document.querySelector(".navbar-nine .menu-bar");

    sideMenuLeftNine.addEventListener("click", function () {
      sidebarLeft.classList.add("open");
      overlayLeft.classList.add("open");
    });

    //========= glightbox
    GLightbox({
      'href': 'https://www.youtube.com/watch?v=r44RKWyfcFw&fbclid=IwAR21beSJORalzmzokxDRcGfkZA1AtRTE__l5N4r09HcGS5Y6vOluyouM9EM',
      'type': 'video',
      'source': 'youtube',
      'width': 900,
      'autoplayVideos': true,
    });

    // ===== FIXED NAVBAR TOGGLE LOGIC =====

    let navbarTogglerNine = document.querySelector(".navbar-nine .navbar-toggler");
    let navbarCollapse = document.getElementById("navbarNine");

    // toggler click animation
    navbarTogglerNine.addEventListener("click", function () {
      navbarTogglerNine.classList.toggle("active");
    });

    // menu opened
    navbarCollapse.addEventListener("shown.bs.collapse", function () {
      navbarTogglerNine.classList.add("active");
    });

    // menu closed
    navbarCollapse.addEventListener("hidden.bs.collapse", function () {
      navbarTogglerNine.classList.remove("active");
    });

    // close menu when clicking a link
    document.querySelectorAll("#navbarNine a").forEach((link) => {
      link.addEventListener("click", () => {
        const bsCollapse = new bootstrap.Collapse(navbarCollapse, {
          toggle: false
        });
        bsCollapse.hide();
      });
    });

</script>

<script>
// JavaScript for form validation and sending the data via AJAX

document.getElementById('submit-btn').addEventListener('click', function(event) {
    event.preventDefault(); // Prevent form submission

    // Get form values
    let name = document.getElementById('name').value.trim();
    let email = document.getElementById('email').value.trim();
    let phone = document.getElementById('phone').value.trim();
    let subject = document.getElementById('subject').value.trim();
    let reference = document.getElementById('reference').value.trim();
    let message = document.getElementById('message').value.trim();
    let source = document.getElementById('source').value.trim();

    // Dynamic fields
    let course_id = document.getElementById('course_id') ? document.getElementById('course_id').value.trim() : '';
    let subject_description = document.getElementById('subject_description') ? document.getElementById('subject_description').value.trim() : '';

    // Validate required fields
    if (!name || !email || !phone || !subject || !message) {
        alert("Please fill in all required fields.");
        return;
    }

    // Validate phone number
    let phoneRegex = /^[0-9]{10}$/;
    if (!phoneRegex.test(phone)) {
        alert("Please enter a valid 10-digit phone number.");
        return;
    }

    // Validate email
    let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
        alert("Please enter a valid email address.");
        return;
    }

    // Clean name input (remove unwanted symbols)
    name = name.replace(/[^a-zA-Z0-9 ]/g, '');

    // Check for specific subject type and validate accordingly
    const selectedSubjectText = document.getElementById('subject').options[document.getElementById('subject').selectedIndex].text.trim();

    if (selectedSubjectText === "Course Enquiry" && !course_id) {
        alert("Please select a course for Course Enquiry.");
        return;
    }

    if (selectedSubjectText === "General Enquiry" && !subject_description) {
        alert("Please provide a short description of your general enquiry.");
        return;
    }

    // Create JSON object
    let formData = {
        name: name,
        email: email,
        phone: phone,
        subject: subject,
        reference: reference,
        message: message,
        source: source,
        course_id: course_id,
        subject_description: subject_description
    };

    // Disable button while submitting
    const submitBtn = document.getElementById('submit-btn');
    submitBtn.disabled = true;
    submitBtn.textContent = "Submitting...";

    // Send data via Fetch API
    fetch('submit-enquiry.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(formData),
    })
    .then(response => response.text())
    .then(responseText => {
        console.log('Raw response:', responseText);

        try {
            let data = JSON.parse(responseText);
            if (data.success) {
                alert('✅ Enquiry submitted successfully! We will contact you shortly.');
                document.getElementById('enquiry-form').reset();

                // Hide dynamic fields after submit
                document.getElementById('dynamic-section').style.display = "none";
                document.getElementById('course-section').style.display = "none";
                document.getElementById('general-section').style.display = "none";
            } else {
                alert('❌ Error: ' + data.message);
            }
        } catch (error) {
            console.error('Failed to parse JSON:', error);
            alert('Something went wrong, please try again later.');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Something went wrong, please try again later.');
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.textContent = "Send Enquiry";
    });
});
</script>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

</body>
</html>
<?php $conn->close(); ?>