<?php
function logActivity($conn, $subscriberId, $activityText) {

    // Fetch subscriber mobile_no
    $stmt = $conn->prepare("SELECT mobile_no FROM subscriber WHERE id=? LIMIT 1");
    $stmt->bind_param("i", $subscriberId);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$user) return; // fail silently

    $mobile = $user['mobile_no'];

    // Insert activity
    $stmt2 = $conn->prepare("INSERT INTO activity_log (mobile_no, activity, created_at) VALUES (?, ?, NOW())");
    $stmt2->bind_param("ss", $mobile, $activityText);
    $stmt2->execute();
    $stmt2->close();
}
?>
