<?php
include_once('./config.php');
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
$csrf = $_SESSION['csrf_token'];

$flash = $_SESSION['flash'] ?? null;
unset($_SESSION['flash']);

// ✅ define getImagePath like register page
function getImagePath($path) {
  if (strpos($path, '../') === 0) {
      $path = substr($path, 3);
  }
  return $path;
}

// Defensive defaults
$settings = $settings ?? [];
$logo_src = !empty($settings['logo']) ? getImagePath($settings['logo']) : 'assets/default-logo.png';
$site_name = htmlspecialchars($settings['site_name'] ?? 'My Site', ENT_QUOTES, 'UTF-8');
$developer = htmlspecialchars($settings['developer'] ?? 'Developer', ENT_QUOTES, 'UTF-8');
$developer_website = htmlspecialchars($settings['developer_website'] ?? '#', ENT_QUOTES, 'UTF-8');
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Login - <?= $site_name ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- ✅ Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #f8f9fa, #e9ecef);
      min-height: 100vh;
    }
    .card {
      border: none;
      border-radius: 20px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .payment-header {
      background: #fff;
      padding: 20px 0;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    .payment-header .logo {
      max-height: 60px;
    }
    footer {
      background: #fff;
      text-align: center;
      padding: 15px 0;
      margin-top: 40px;
      font-size: 14px;
      color: #555;
      border-top: 1px solid #eee;
    }
    footer a {
      text-decoration: none;
      color: #0d6efd;
    }
  </style>
</head>
<body>

  <!-- Header -->
  <header class="payment-header text-center shadow-sm">
    <div class="container">
      <a href="index.php">
        <img src="<?= htmlspecialchars($logo_src, ENT_QUOTES, 'UTF-8') ?>" alt="Logo" class="logo">
      </a>
    </div>
  </header>

  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-5">
        <?php if ($flash): ?>
          <div class="alert alert-info"><?= htmlspecialchars($flash, ENT_QUOTES, 'UTF-8') ?></div>
        <?php endif; ?>

        <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
  <div class="card-header text-white text-center py-4"
       style="background:linear-gradient(135deg, #007bff, #6610f2);">
    <h4 class="mb-0 fw-bold"><i class="bi bi-box-arrow-in-right me-2"></i> Login to Your Account</h4>
  </div>

  <div class="card-body p-4">
    <form method="post" action="login_action.php" novalidate>
      <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf, ENT_QUOTES, 'UTF-8') ?>">

      <!-- Email -->
      <div class="mb-3">
        <label class="form-label fw-semibold">Email Address</label>
        <div class="input-group">
          <span class="input-group-text bg-light"><i class="bi bi-envelope"></i></span>
          <input type="email" name="email" required class="form-control rounded-end" maxlength="255" placeholder="example@email.com">
        </div>
      </div>

      <!-- Password -->
      <div class="mb-4">
        <label class="form-label fw-semibold">Password</label>
        <div class="input-group">
          <span class="input-group-text bg-light"><i class="bi bi-lock"></i></span>
          <input type="password" name="password" required class="form-control rounded-end" minlength="8" placeholder="Enter your password">
        </div>
      </div>

      <!-- Login Button -->
      <div class="d-grid mb-3">
        <button type="submit" class="btn btn-primary btn-lg fw-semibold shadow-sm"
                style="border-radius: 50px;">
          <i class="bi bi-box-arrow-in-right me-1"></i> Login
        </button>
      </div>

      <div class="text-center">
        <small class="text-muted">Don’t have an account?
          <a href="register.php" class="fw-semibold text-decoration-none text-primary">Register</a>
        </small>
      </div>
    </form>

    <hr>
    <div class="text-center small">
      <a href="forgot.php">Forgot password?</a> 
    </div>
  </div>
</div>


      </div>
    </div>
  </div>

  <!-- Footer -->
  <footer>
    <p>© <?= date("Y"); ?> <?= $site_name ?> |
      Designed by <a href="<?= $developer_website ?>" target="_blank"><?= $developer ?></a>
    </p>
  </footer>

</body>
</html>
