<?php
require 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

function bad($msg){ $_SESSION['flash']=$msg; header("Location: login.php"); exit; }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') bad('Invalid request method');
if (empty($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token'])) bad('CSRF validation failed');

$email = trim($_POST['email'] ?? '');
$pwd = $_POST['password'] ?? '';

if (!$email || !$pwd) bad('Missing email or password');

$stmt = $conn->prepare("SELECT id, name, email, password,status,mobile_no, deleted_at FROM subscriber WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();

if ($row = $res->fetch_assoc()) {
    if (!is_null($row['deleted_at'])) {
        bad('Account not found.');
    }
    if (password_verify($pwd, $row['password'])) {
        // login success
        session_regenerate_id(true);
        $_SESSION['subscriber_id'] = $row['id'];
        $_SESSION['subscriber_name'] = $row['name'];
        $_SESSION['subscriber_email'] = $row['email'];
        $_SESSION['subscriber_status'] = $row['status'];
        $_SESSION['subscriber_mobile_no'] = $row['mobile_no'];
        // optionally set last activity
        header("Location: student-corner.php"); // create dashboard.php or change path
        exit;
    } else {
        bad('Invalid credentials.');
    }
} else {
    bad('Invalid credentials.');
}
