<?php
class DashboardData {
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    /**
     * Get count from a table
     * @param string $table - Table name
     * @param string $filter - 'today', 'week', 'month', 'all'
     * @return int
     */
    public function getCount($table, $filter = 'today') {
        $sql = "SELECT COUNT(*) as count FROM `$table` WHERE `deleted_at` IS NULL";

        // Only apply date filter if not 'all'
        if ($filter !== 'all') {
            switch ($filter) {
                case 'week':
                    $sql .= " AND YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1)";
                    break;
                case 'month':
                    $sql .= " AND MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())";
                    break;
                default: // today
                    $sql .= " AND DATE(created_at) = CURDATE()";
            }
        }

        $stmt = $this->conn->prepare($sql);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        return (int)$result['count'];
    }
}
?>

