<?php
// ✅ Enable debugging safely without breaking sessions or config.php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
ini_set('display_errors', 1);

include("auth.php");
include("../config.php");

// ✅ CSRF Token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// ✅ Fetch current ad data
$settingsQuery = "SELECT id, s_corner_header_ad, s_corner_footer_ad, home_header_ad, home_footer_ad FROM settings LIMIT 1";
$result = mysqli_query($conn, $settingsQuery);
$settings = mysqli_fetch_assoc($result);

// ✅ Handle remove banner
if (isset($_GET['remove'])) {
  $field = mysqli_real_escape_string($conn, $_GET['remove']);
  $query = "UPDATE settings SET `$field` = NULL"; // ✅ removed updated_at
  if (mysqli_query($conn, $query)) {
    $msg = "🗑 Banner removed successfully!";
  } else {
    $msg = "❌ Failed to remove banner: " . mysqli_error($conn);
  }
$_SESSION['flash_msg'] = $msg;
header("Location: ad_settings.php");
exit;

}

// ✅ Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ad_type'])) {
  $adType = $_POST['ad_type'];
  $uploadDir = "../assets/ads/";

  // Ensure folder exists
  if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
  }

  if (isset($_FILES['ad_banner']) && $_FILES['ad_banner']['error'] === UPLOAD_ERR_OK) {
    $ext = pathinfo($_FILES['ad_banner']['name'], PATHINFO_EXTENSION);
    $newName = time() . "_" . $adType . "." . $ext;
    $path = $uploadDir . $newName;
    $dbPath = "assets/ads/" . $newName;

    if (move_uploaded_file($_FILES['ad_banner']['tmp_name'], $path)) {
      $update = "UPDATE settings SET `$adType` = '$dbPath'"; // ✅ removed updated_at
      mysqli_query($conn, $update);
      $_SESSION['flash_msg'] = $msg;
header("Location: ad_settings.php");
exit;

    } else {
      $msg = "❌ Failed to move uploaded image.";
    }
  } else {
    $msg = "⚠️ No file uploaded or file error.";
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Ad Settings</title>

  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">

  <style>
    .ad-card {
      border: 1px solid #ddd;
      border-radius: 10px;
      padding: 20px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
      transition: 0.3s;
    }
    .ad-card:hover {
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    .ad-preview {
      width: 100%;
      max-width: 1000px;
      height: 300px;
      object-fit: cover;
      border-radius: 8px;
      border: 1px solid #ccc;
      margin-bottom: 10px;
    }
    #uploadLoader {
      display: none;
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(255,255,255,0.8);
      z-index: 1000;
      justify-content: center;
      align-items: center;
      font-size: 20px;
      font-weight: bold;
    }
  </style>
</head>
<body>

<div id="uploadLoader">
  <div class="spinner-border text-primary me-2"></div> Uploading... Please wait
</div>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">
  <div class="pagetitle">
    <h1>Ad Settings</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
        <li class="breadcrumb-item active">Ad Settings</li>
      </ol>
    </nav>
  </div>

  <section class="section">
    <div class="container-fluid">
      <?php if (!empty($_SESSION['flash_msg'])): ?>
  <div class="alert alert-info"><?php echo htmlspecialchars($_SESSION['flash_msg']); ?></div>
  <?php unset($_SESSION['flash_msg']); ?>
<?php endif; ?>

      <div class="row">
        <?php
        $ads = [
          's_corner_header_ad' => 'Student Corner Header Ads',
          's_corner_footer_ad' => 'Student Corner Footer Ads',
          'home_header_ad' => 'Home Page Header Ads',
          'home_footer_ad' => 'Home Page Footer Ads'
        ];

        foreach ($ads as $field => $label):
          $img = $settings[$field] ?? null;
        ?>
        <div class="col-md-6 mb-4">
          <div class="ad-card">
            <h5><?php echo $label; ?></h5>
            <form method="POST" enctype="multipart/form-data" class="mt-2 adForm">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
              <input type="hidden" name="ad_type" value="<?php echo $field; ?>">

              <?php if ($img): ?>
                <img src="../<?php echo htmlspecialchars($img); ?>" class="ad-preview" alt="Ad Banner">
                <a href="?remove=<?php echo $field; ?>" class="btn btn-danger btn-sm mb-2" onclick="return confirm('Remove this banner?')">
                  <i class="bi bi-trash"></i> Remove
                </a>
              <?php else: ?>
                <p class="text-muted">No banner uploaded.</p>
              <?php endif; ?>

              <div class="mt-3">
                <input type="file" name="ad_banner" accept="image/*" class="form-control mb-2" required>
                <small class="text-muted">Recommended size: <b>1000×300px</b></small><br>
                <button type="submit" class="btn btn-primary btn-sm mt-2"><i class="bi bi-upload"></i> Upload</button>
              </div>
            </form>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
</main>

<?php include("templates/footer.php"); ?>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
  // ✅ Show loader during upload
  document.querySelectorAll('.adForm').forEach(form => {
    form.addEventListener('submit', () => {
      document.getElementById('uploadLoader').style.display = 'flex';
    });
  });
</script>
<script>
  const alertBox = document.querySelector('.alert');
  if (alertBox) {
    setTimeout(() => {
      alertBox.style.transition = 'opacity 0.5s';
      alertBox.style.opacity = '0';
      setTimeout(() => alertBox.remove(), 500);
    }, 3000);
  }
</script>

</body>
</html>
