<?php
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Validate and sanitize inputs
$date = mysqli_real_escape_string($conn, $_GET['date'] ?? '');
$batch_id = mysqli_real_escape_string($conn, $_GET['batch_id'] ?? '');

if (empty($date) || empty($batch_id)) {
  die("Invalid request. Please go back and select valid filters.");
}

// Fetch batch details
$batch_sql = "SELECT title, trainer, mode FROM batch WHERE id='$batch_id' AND deleted_at IS NULL";
$batch_res = mysqli_query($conn, $batch_sql);
$batch = mysqli_fetch_assoc($batch_res);
$batch_name = $batch['title'] ?? 'Unknown Batch';
$trainer = $batch['trainer'] ?? 'N/A';
$mode = $batch['mode'] ?? 'N/A';

// Fetch attendance details
$att_sql = "SELECT * FROM attendance 
            WHERE deleted_at IS NULL 
            AND bid='$batch_id' 
            AND DATE(date)='$date'
            ORDER BY status DESC, student_mobile ASC";
$att_res = mysqli_query($conn, $att_sql);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Attendance Details - <?php echo $settings['site_name']; ?></title>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Fonts & CSS -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">

    <div class="pagetitle d-flex justify-content-between align-items-center">
      <div>
        <h1>Attendance Details</h1>
        <nav>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
            <li class="breadcrumb-item"><a href="attendance-reports.php">Attendance Reports</a></li>
            <li class="breadcrumb-item active">Details</li>
          </ol>
        </nav>
      </div>
      <a href="attendance-reports.php" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back
      </a>
    </div>

    <section class="section">
      <div class="row">
        <!-- Batch Info Card -->
        <div class="col-lg-12 mb-3">
          <div class="card info-card">
            <div class="card-body">
              <h5 class="card-title">Batch Information</h5>
              <div class="row">
                <div class="col-md-3">
                  <strong>Batch:</strong> <?php echo htmlspecialchars($batch_name); ?>
                </div>
                <div class="col-md-3">
                  <strong>Trainer:</strong> <?php echo htmlspecialchars($trainer); ?>
                </div>
                <div class="col-md-3">
                  <strong>Mode:</strong> <?php echo htmlspecialchars($mode); ?>
                </div>
                <div class="col-md-3">
                  <strong>Date:</strong> <?php echo htmlspecialchars($date); ?>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- End Batch Info Card -->

        <!-- Attendance Details Table -->
        <div class="col-lg-12">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Student Attendance List</h5>

              <div class="table-responsive">
                <table class="table datatable">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Student Mobile</th>
                      <th>Status</th>
                      <th>Device ID</th>
                      <th>IP Address</th>
                      <th>Marked By</th>
                      <th>Marked At</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    if ($att_res && mysqli_num_rows($att_res) > 0) {
                      $sl = 1;
                      while ($row = mysqli_fetch_assoc($att_res)) {
                        $status_class = $row['status'] == 'Present' ? 'text-success fw-bold' : 'text-danger fw-bold';
                        echo "<tr>";
                        echo "<td>{$sl}</td>";
                        echo "<td>" . htmlspecialchars($row['student_mobile']) . "</td>";
                        echo "<td class='{$status_class}'>" . htmlspecialchars($row['status']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['device_id'] ?? '-') . "</td>";
                        echo "<td>" . htmlspecialchars($row['ip_address'] ?? '-') . "</td>";
                        echo "<td>" . htmlspecialchars($row['marked_by'] ?? '-') . "</td>";
                        echo "<td>" . htmlspecialchars($row['created_at']) . "</td>";
                        echo "</tr>";
                        $sl++;
                      }
                    } else {
                      echo "<tr><td colspan='7' class='text-center'>No attendance records found for this date.</td></tr>";
                    }
                    ?>
                  </tbody>
                </table>
              </div>

            </div>
          </div>
        </div>
        <!-- End Table -->
      </div>
    </section>
  </main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/js/main.js"></script>
  
  
  

</body>
</html>
