<?php
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Attendance Reports - <?php echo $settings['site_name']; ?></title>
<script>
// Disable NiceAdmin Simple-DataTables before it loads
window.SimpleDataTables = null;

// Disable auto-init function used by NiceAdmin
document.addEventListener("DOMContentLoaded", function(e) {
    e.stopImmediatePropagation();
}, true);
</script>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">
  
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <!--<link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">-->
  <link href="assets/css/style.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<style>
.dataTables_length {
    margin-right: 15px !important;
}

.dt-buttons .btn {
    margin-right: 5px;
}

</style>
<style>
@media (max-width: 768px) {
    /* Container becomes flex */
    .dataTables_wrapper .dt-buttons,
    .dataTables_wrapper .dataTables_length {
        float: none;
        display: inline-flex;
        align-items: center;
        margin-bottom: 8px;
    }

    /* Put length + buttons on same row */
    .dataTables_wrapper .dataTables_length {
        margin-right: 10px;
    }

    /* Allow wrapping if needed without stacking vertically */
    .dataTables_wrapper .dt-buttons {
        flex-wrap: nowrap;
    }

    /* Search goes below */
    .dataTables_wrapper .dataTables_filter {
        float: none;
        margin-top: 10px;
        width: 100%;
        text-align: left;
    }
}
</style>
</head>

<body>
  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Attendance Reports</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Attendance Reports</li>
        </ol>
      </nav>
    </div>

    <section class="section">
      <div class="row">

        <!-- Filter Card -->
        <div class="col-lg-12 mb-3">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title mb-3">Filter Attendance</h5>

              <form method="GET" class="row g-3">
                <div class="col-md-3">
                  <label class="form-label">From Date</label>
                  <input type="date" name="from_date" value="<?php echo htmlspecialchars($_GET['from_date'] ?? ''); ?>" class="form-control">
                </div>

                <div class="col-md-3">
                  <label class="form-label">To Date</label>
                  <input type="date" name="to_date" value="<?php echo htmlspecialchars($_GET['to_date'] ?? ''); ?>" class="form-control">
                </div>

                <div class="col-md-3">
                  <label class="form-label">Select Batch</label>
                  <select name="batch_id" class="form-select">
                    <option value="">-- Select Batch --</option>
                    <?php
                    $batch_sql = "SELECT id, title FROM batch WHERE deleted_at IS NULL AND status='Active'";
                    $batch_res = mysqli_query($conn, $batch_sql);
                    while ($b = mysqli_fetch_assoc($batch_res)) {
                      $selected = (isset($_GET['batch_id']) && $_GET['batch_id'] == $b['id']) ? 'selected' : '';
                      echo "<option value='{$b['id']}' $selected>" . htmlspecialchars($b['title']) . "</option>";
                    }
                    ?>
                  </select>
                </div>

                <div class="col-md-3 d-flex align-items-end">
                  <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search"></i> Search
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <!-- End Filter Card -->

        <!-- Data Table -->
        <div class="col-lg-12">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title d-flex justify-content-between align-items-center">Attendance Summary</h5>

              <div class="table-responsive">
                <table class="table data-table table-hover" id="excel">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Date</th>
                      <th>Total Enrolled</th>
                      <th>Total Present</th>
                      <th>Total Absent</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $from_date = mysqli_real_escape_string($conn, $_GET['from_date'] ?? '');
                    $to_date   = mysqli_real_escape_string($conn, $_GET['to_date'] ?? '');
                    $batch_id  = mysqli_real_escape_string($conn, $_GET['batch_id'] ?? '');

                    if (!empty($from_date) && !empty($to_date) && !empty($batch_id)) {

                      // Total enrolled for this batch
                      $enroll_sql = "SELECT COUNT(*) AS total_enrolled FROM enrolments 
                                     WHERE bid='$batch_id' AND deleted_at IS NULL";
                      $enroll_res = mysqli_query($conn, $enroll_sql);
                      $enroll_data = mysqli_fetch_assoc($enroll_res);
                      $total_enrolled = $enroll_data['total_enrolled'] ?? 0;

                      // Attendance summary grouped by date
                      $att_sql = "SELECT 
                                    DATE(date) AS att_date,
                                    SUM(CASE WHEN status='Present' THEN 1 ELSE 0 END) AS total_present,
                                    SUM(CASE WHEN status='Absent' THEN 1 ELSE 0 END) AS total_absent
                                  FROM attendance
                                  WHERE deleted_at IS NULL
                                  AND bid='$batch_id'
                                  AND DATE(date) BETWEEN '$from_date' AND '$to_date'
                                  GROUP BY DATE(date)
                                  ORDER BY DATE(date) DESC";
                      $att_res = mysqli_query($conn, $att_sql);

                      $sl = 1;
                      if ($att_res && mysqli_num_rows($att_res) > 0) {
                        while ($row = mysqli_fetch_assoc($att_res)) {
                          $date = $row['att_date'];
                          $present = $row['total_present'];
                          $absent = $row['total_absent'];

                          echo "<tr onclick=\"window.location='attendance-report-details.php?date=$date&batch_id=$batch_id'\" style='cursor:pointer'>";
                          echo "<td>{$sl}</td>";
                          echo "<td>" . htmlspecialchars($date) . "</td>";
                          echo "<td>{$total_enrolled}</td>";
                          echo "<td>{$present}</td>";
                          echo "<td>{$absent}</td>";
                          echo "</tr>";

                          $sl++;
                        }
                      } else {
                        
                        
                        echo "<tbody class='dt-ignore'><tr><td colspan='5' class='text-center'>No attendance records found.</td></tr></tbody>";

                      }
                    } else {
                        
echo "<tbody class='dt-ignore'>
<tr style='display:none;'>
  <td></td><td></td><td></td><td></td><td></td>
</tr>
<tr><td colspan='5' class='text-center'>Please select all filters to view data.</td></tr>
</tbody>";

                    }
                    ?>
                  </tbody>
                </table>
              </div>

            </div>
          </div>
        </div>
        <!-- End Data Table -->
      </div>
    </section>
  </main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

<script>
// Prevent Simple-DataTables from loading only on this page
window.addEventListener("DOMContentLoaded", function() {

    // Find all tables that Simple-DataTables might auto-initialize
    document.querySelectorAll("table").forEach(tbl => {
        // Remove the class that triggers Simple-DataTables
        tbl.classList.remove("datatable");

        // Remove attribute used by auto-init (exists in some NiceAdmin versions)
        tbl.removeAttribute("data-table");
    });

    // Disable auto-init script (NiceAdmin)
    window.SimpleDataTables = null;
});
</script>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <!--<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>-->
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/js/main.js"></script>



<!-- jQuery (must load first) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- jQuery DataTables Core -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">

<!-- PDF Export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>


<script>
$(document).ready(function() {
$('.data-table').DataTable({
    dom: 'lBfrtip',
    buttons: [
        {
            extend: 'csvHtml5',
            text: '<i class="bi bi-file-earmark-spreadsheet"></i>',
            className: 'btn btn-primary btn-sm'
        },
        {
            extend: 'pdfHtml5',
            orientation: 'landscape',
            pageSize: 'A4',
            text: '<i class="bi bi-file-earmark-pdf"></i>',
            className: 'btn btn-danger btn-sm'
        },
        {
            extend: 'print',
            text: '<i class="bi bi-printer"></i>',
            className: 'btn btn-secondary btn-sm'
        }
    ],
     language: {
        emptyTable: "",      // Hide "No data available"
        zeroRecords: ""      // Hide "No matching records found"
    },
    initComplete: function () {
        // Remove label text ("Search:")
        $('.dataTables_filter label').contents().filter(function() {
            return this.nodeType === 3;
        }).remove();

        // Add placeholder for search
        $('.dataTables_filter input').attr('placeholder', 'Search here...');

        // Remove text from "Show X entries" label
        $('.dataTables_length label').contents().filter(function() {
            return this.nodeType === 3;
        }).remove();
    }
});

});

</script>
</body>
</html>
