<?php  include ("auth.php");
include ("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Attendance - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
<style>
#studentList tr.highlight {
  background-color: #e7f1ff !important;
  transition: background-color 0.3s;
}
#studentSearch {
  border-radius: 20px;
  padding-left: 12px;
}
#studentSearch:focus {
  border-color: #0d6efd;
  box-shadow: 0 0 3px rgba(13,110,253,0.5);
}
</style>



</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Attendance</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Attendance</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

          <div class="card">
  <div class="card-body">
    <h5 class="card-title">Mark Attendance</h5>

    <!-- Filter Section -->
    <div class="row mb-3">
      <div class="col-md-4">
        <label for="batch" class="form-label">Select Batch</label>
        <select id="batch" name="batch" class="form-select">
          <option value="">-- Select Batch --</option>
          <?php
          $batches = $conn->query("SELECT id, title FROM batch WHERE deleted_at IS NULL AND status='Active'");
          while($b = $batches->fetch_assoc()) {
              echo "<option value='{$b['id']}'>{$b['title']}</option>";
          }
          ?>
        </select>
      </div>
      <div class="col-md-4">
        <label for="date" class="form-label">Attendance Date</label>
        <input type="date" id="date" class="form-control" value="<?= date('Y-m-d'); ?>">
      </div>
      <div class="col-md-4 d-flex align-items-end">
        <button id="loadStudents" class="btn btn-primary w-100"><i class="bi bi-search"></i> Load Students</button>
      </div>
    </div>

    <!-- Attendance Table -->
<!-- Attendance Table -->
<form id="attendanceForm">
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token']; ?>">

  <div class="d-flex justify-content-between align-items-center mb-2">
    <h6 class="mb-0">Students List</h6>
    <input type="text" id="studentSearch" class="form-control form-control-sm" 
           placeholder="Search by name or mobile..." 
           style="width: 250px;">
  </div>

  <div class="table-responsive">
    <table class="table table-bordered" id="attendanceTable">
      <thead>
        <tr>
          <th><input type="checkbox" id="selectAll"></th>
          <th>Student Name</th>
          <th>Mobile</th>
          <th class="text-end">
  <div class="d-flex justify-content-between align-items-center">
    <span>Status</span>
    <button type="button" id="markNMAbsent" class="btn btn-warning btn-sm ms-2" title="Change 'Not Marked' status to 'Absent'">
      Not Marked → Absent
    </button>
  </div>
</th>

        </tr>
      </thead>
      <tbody id="studentList">
        <tr><td colspan="4" class="text-center">Select a batch to view students</td></tr>
      </tbody>
    </table>
  </div>
  
<div class="d-flex justify-content-between align-items-center mt-3">
  
  <div class="text-danger small mb-0">
    <i class="bi bi-info-circle"></i> Make sure to <strong>save attendance</strong> after every change.
  </div>

  <button type="submit" class="btn btn-success ms-3">
    <i class="bi bi-check-circle"></i> Save Attendance
  </button>

</div>

</form>

  </div>
</div>


        </div>
      </div>
    </section>

  </main><!-- End #main -->


  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
 <script>
document.getElementById('loadStudents').addEventListener('click', function() {
  const bid = document.getElementById('batch').value;
  const date = document.getElementById('date').value;
  
  if(!bid) return alert('Please select a batch.');
  if(!date) return alert('Please select a date.');
  
  fetch('fetch-students.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'bid=' + bid + '&date=' + date
  })
  .then(res => res.text())
  .then(data => document.getElementById('studentList').innerHTML = data);
});

// Select All toggle
document.addEventListener('change', function(e) {
  if (e.target.id === 'selectAll') {
    document.querySelectorAll('.student-check').forEach(chk => chk.checked = e.target.checked);
  }
});

// Submit Attendance
document.getElementById('attendanceForm').addEventListener('submit', function(e) {
  e.preventDefault();
  const bid = document.getElementById('batch').value;
  const date = document.getElementById('date').value;

  const formData = new FormData(this);
  formData.append('bid', bid);
  formData.append('date', date);

  fetch('save-attendance.php', {method:'POST', body: formData})
  .then(res => res.text())
.then(resp => {
  resp = resp.trim();
  if (resp === 'success') {
    alert('Attendance saved successfully!');
    location.reload();
  } else {
    alert('No students selected or error saving attendance.');
    console.log(resp);
  }
});

});
</script>
<script>
document.getElementById('studentSearch').addEventListener('keyup', function() {
  const searchValue = this.value.toLowerCase().trim();
  const tbody = document.getElementById('studentList');
  const rows = Array.from(tbody.querySelectorAll('tr'));

  if (!searchValue) {
    // If input is empty → reset to original order and remove highlights
    rows.forEach(row => row.classList.remove('highlight'));
    tbody.innerHTML = '';
    rows.forEach(row => tbody.appendChild(row));
    return;
  }

  // Separate matching and non-matching rows
  const matching = [];
  const nonMatching = [];

  rows.forEach(row => {
    const name = row.children[1]?.textContent.toLowerCase() || '';
    const mobile = row.children[2]?.textContent.toLowerCase() || '';

    if (name.includes(searchValue) || mobile.includes(searchValue)) {
      row.classList.add('highlight');
      matching.push(row);
    } else {
      row.classList.remove('highlight');
      nonMatching.push(row);
    }
  });

  // Clear and re-append: matching first, then non-matching
  tbody.innerHTML = '';
  matching.concat(nonMatching).forEach(row => {
    tbody.appendChild(row);
  });
});
</script>
<script>
document.getElementById("markNMAbsent").addEventListener("click", function () {
    document.querySelectorAll("#studentList tr").forEach(row => {
        let select = row.querySelector(".status-select");
        let checkbox = row.querySelector(".student-check");

        if (select && select.value === "Not Marked") {
            select.value = "Absent";   // set status
            checkbox.checked = true;   // check row
        }
    });

    // alert("All Not Marked students have been marked Absent.");
});
</script>

</body>

</html>