<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Unknown error'];


// Get POST parameters
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$title = trim($_POST['title'] ?? '');
$details = trim($_POST['details'] ?? '');
$mode = trim($_POST['mode'] ?? '');
$trainer = trim($_POST['trainer'] ?? '');
$cid = $_POST['cid'] ?? '';
$batch_start = $_POST['batch_start'] ?? '';
$batch_end = $_POST['batch_end'] ?? '';

// Sanitize content_title to remove HTML and scripts
$title = htmlspecialchars(strip_tags($title), ENT_QUOTES, 'UTF-8');
$mode = htmlspecialchars(strip_tags($mode), ENT_QUOTES, 'UTF-8');
$details = htmlspecialchars(strip_tags($details), ENT_QUOTES, 'UTF-8');
$trainer = htmlspecialchars(strip_tags($trainer), ENT_QUOTES, 'UTF-8');
$cid = htmlspecialchars(strip_tags($cid), ENT_QUOTES, 'UTF-8');

// Validate that required fields are not empty
if ($action!='delete' && $action!='Activate' && $action!='Deactivate' && (empty($title) || empty($mode) || empty($details) || empty($trainer) || empty($cid) || empty($batch_start) || empty($batch_end)) ) {
    $response['message'] = '* marked inputs cannot be empty.';
    echo json_encode($response);
    exit;
}

// Handle the delete action via POST (AJAX)
if ($action === 'delete' && $id > 0) {
    try {
        // Prepare and execute the soft delete query
        $stmt = $conn->prepare("UPDATE batch SET deleted_at = NOW() WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Batch deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete batch.';
        }

        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    // Return JSON response after the delete action
    echo json_encode($response);
    $conn->close();
    exit;
}


// === ACTIVATE / DEACTIVATE COURSE ===
if (($action === 'Activate' || $action === 'Deactivate') && $id > 0) {
    $newStatus = ($action === 'Activate') ? 'Active' : 'Deactive';
    try {
        $stmt = $conn->prepare("UPDATE batch SET status = ?, updated_at = NOW() WHERE id = ?");
        $stmt->bind_param("si", $newStatus, $id);
        if ($stmt->execute()) {
            $response = [
                'success' => true,
                'message' => "Batch {$newStatus}d successfully."
            ];
        } else {
            $response['message'] = "Failed to {$action} batch.";
        }
        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    echo json_encode($response);
    $conn->close();
    exit;
}


// For Add and Edit actions
try {
    if ($action === 'Add') {
        // Insert new content
        $stmt = $conn->prepare("INSERT INTO batch (title, cid, details, mode,trainer,batch_start,batch_end) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sisssss", $title, $cid, $details, $mode, $trainer, $batch_start, $batch_end);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Batch added successfully', 'redirect' => 'batches.php'];
        } else {
            $response['message'] = 'Failed to add batch';
        }

        $stmt->close();

    } elseif ($action === 'Edit' && $id > 0) {
        // Edit existing content
        $stmt = $conn->prepare("UPDATE batch SET title=?, cid=?, details=?, mode=?, trainer=?, batch_start=?, batch_end=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param("sisssssi", $title, $cid, $details, $mode, $trainer, $batch_start, $batch_end, $id);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'Batch updated successfully', 'redirect' => 'batches.php'];
        } else {
            $response['message'] = 'Failed to update batch';
        }

        $stmt->close();

    } else {
        $response['message'] = 'Invalid action or missing batch ID';
    }

} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

// Return JSON response
echo json_encode($response);
$conn->close();
exit;
?>


