<?php  
include("auth.php"); 
include("../config.php");

// CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Blog Categories - <?php echo $settings['site_name']; ?></title>

  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">
  <div class="pagetitle">
    <h1>Blog Categories</h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item active">Blog Categories</li>
    </ol>
  </div>

  <section class="section">
    <div class="row">

      <div class="col-lg-12">
        <a href="blog-category.php" class="btn btn-primary btn-sm">
          <i class="bi bi-plus"></i> Add New
        </a>

        <div class="card mt-2">
          <div class="card-body">
            <h5 class="card-title">Category List</h5>

            <input type="hidden" id="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

            <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>Category</th>
                    <th>Slug</th>
                    <th>Thumbnail</th>
                    <th>Created At</th>
                  </tr>
                </thead>
                <tbody>

                <?php
                $sql = "SELECT * FROM blog_categories ORDER BY category ASC";
                $res = mysqli_query($conn, $sql);
                $sl = 1;

                if ($res && mysqli_num_rows($res) > 0) {
                  while ($row = mysqli_fetch_assoc($res)) {
                    echo "<tr>";
                    echo "<td>$sl</td>";

                    echo "<td>
                      <a href='blog-category.php?id=" . base64_encode($row['id']) . "' class='btn btn-warning btn-sm'><i class='bi bi-pencil'></i></a>
                      <button class='btn btn-danger btn-sm' onclick='deleteCategory(".$row['id'].")'><i class='bi bi-trash'></i></button>
                    </td>";

                    echo "<td>".htmlspecialchars($row['category'])."</td>";
                    echo "<td>".htmlspecialchars($row['slug'])."</td>";

                    if ($row['thumbnail']) {
                      echo "<td><img src='../".htmlspecialchars($row['thumbnail'])."' style='max-width:80px'></td>";
                    } else {
                      echo "<td>—</td>";
                    }

                    echo "<td>".$row['created_at']."</td>";
                    echo "</tr>";
                    $sl++;
                  }
                }
                ?>

                </tbody>
              </table>
            </div>

          </div>
        </div>

      </div>

    </div>
  </section>

</main>

<?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>


<script>
function deleteCategory(id) {
  if (!confirm("Are you sure?")) return;

  const token = document.getElementById("csrf_token").value;

  fetch("blog-category-action.php", {
    method: "POST",
    body: new FormData(Object.assign(document.createElement('form'), {
      action: 'delete',
      id: id,
      csrf_token: token
    }))
  }).then(res => res.json()).then(data => {
    alert(data.message);
    if (data.success) location.reload();
  });
}
</script>

</body>
</html>
