<?php  
include("auth.php");
include("../config.php");

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
  echo json_encode(['success'=>false, 'message'=>'Invalid request']);
  exit;
}

if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
  echo json_encode(['success'=>false, 'message'=>'CSRF failed']);
  exit;
}

$action = $_POST['action'];
$id = $_POST['id'] ?? null;
$category = $_POST['category'] ?? '';
$slug = $_POST['slug'] ?? '';
$thumbnailPath = "";

// File upload 
if (!empty($_FILES['thumbnail']['name'])) {
  $uploadDir = "../uploads/category/";
  if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

  $fileName = time() . "_" . basename($_FILES['thumbnail']['name']);
  $fileTmp = $_FILES['thumbnail']['tmp_name'];
  $upload = $uploadDir . $fileName;

  if (move_uploaded_file($fileTmp, $upload)) {
    $thumbnailPath = "uploads/category/".$fileName;
  }
}

// ---------- ADD ----------
if ($action === "Add") {
  $stmt = $conn->prepare("INSERT INTO blog_categories (category, slug, thumbnail) VALUES (?, ?, ?)");
  $stmt->bind_param("sss", $category, $slug, $thumbnailPath);
  $stmt->execute();

  echo json_encode(['success'=>true, 'message'=>"Category added"]);
  exit;
}

// ---------- EDIT ----------
if ($action === "Edit" && $id) {

  if ($thumbnailPath == "") {
    $old = $conn->query("SELECT thumbnail FROM blog_categories WHERE id=$id")->fetch_assoc();
    $thumbnailPath = $old['thumbnail'];
  }

  $stmt = $conn->prepare("UPDATE blog_categories SET category=?, slug=?, thumbnail=? WHERE id=?");
  $stmt->bind_param("sssi", $category, $slug, $thumbnailPath, $id);
  $stmt->execute();

  echo json_encode(['success'=>true, 'message'=>"Category updated"]);
  exit;
}

// ---------- DELETE ----------
if ($action === "delete" && $id) {
  $conn->query("DELETE FROM blog_categories WHERE id=$id");
  echo json_encode(['success'=>true, 'message'=>"Category deleted"]);
  exit;
}

echo json_encode(['success'=>false, 'message'=>"Unknown action"]);
