<?php  
include("auth.php"); 
include("../config.php");

$category = [];
$id = '';

if (isset($_GET['id'])) {
  $id = base64_decode($_GET['id']);

  $stmt = $conn->prepare("SELECT * FROM blog_categories WHERE id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();
  $result = $stmt->get_result();

  if ($result->num_rows > 0) $category = $result->fetch_assoc();
  else { echo "Category not found"; exit; }

  $stmt->close();
}

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width">
  <title><?php echo ($id ? "Edit" : "Add"); ?> Category</title>

 <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

<div class="pagetitle">
  <h1><?php echo ($id ? "Edit" : "Add"); ?> Category</h1>
</div>

<section class="section">
  <div class="row">

    <div class="col-lg-12">

      <a href="blog-categories.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Back</a>

      <div class="card mt-2">
        <div class="card-body">
            
            <h5 class="card-title">Categories Details</h5>

          <form id="categoryForm" class="row g-3" enctype="multipart/form-data">

            <div class="col-md-6">
              <label class="form-label">Category *</label>
              <input type="text" class="form-control" id="category" name="category"
                     value="<?php echo $category['category'] ?? ''; ?>" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Slug *</label>
              <input type="text" class="form-control" id="slug" name="slug"
                     value="<?php echo $category['slug'] ?? ''; ?>" required>
            </div>

            <div class="col-md-12">
              <label class="form-label">Thumbnail</label>
              <input type="file" class="form-control" name="thumbnail" accept="image/*">

              <?php if (!empty($category['thumbnail'])): ?>
                <img src="../<?php echo $category['thumbnail']; ?>" style="max-width:150px;margin-top:10px">
              <?php endif; ?>
            </div>

            <div id="msg"></div>

            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
            <input type="hidden" name="action" value="<?php echo ($id ? "Edit" : "Add"); ?>">
            <?php if ($id): ?>
              <input type="hidden" name="id" value="<?php echo $id; ?>">
            <?php endif; ?>

            <div class="col-12">
              <button class="btn btn-success" type="submit"><?php echo ($id ? "Update" : "Submit"); ?></button>
            </div>

          </form>

        </div>
      </div>

    </div>

  </div>
</section>

</main>


 <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  
<script>
document.getElementById("category").addEventListener("keyup", function() {
  let text = this.value.toLowerCase();
  text = text.replace(/[^a-z0-9]+/g, "-").replace(/(^-|-$)/g, "");
  document.getElementById("slug").value = text;
});

document.getElementById("categoryForm").onsubmit = function(e) {
  e.preventDefault();

  let form = new FormData(this);

  fetch("blog-category-action.php", {
    method: "POST",
    body: form
  }).then(r => r.json()).then(data => {
    document.getElementById("msg").innerHTML =
      `<div class="alert alert-${data.success ? 'success':'danger'}">${data.message}</div>`;
    if (data.success) setTimeout(() => location.href = "blog-categories.php", 1000);
  });
};
</script>

</body>
</html>
