<?php
include("auth.php");
include("../config.php");

header('Content-Type: application/json');

// Only POST allowed
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success'=>false,'message'=>'Invalid request method.']);
    exit;
}

// CSRF
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    echo json_encode(['success'=>false,'message'=>'CSRF validation failed.']);
    exit;
}

$response = ['success'=>false,'message'=>'Something went wrong.'];
$action = $_POST['action'] ?? '';

// sanitize helper
function slugify($text){
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = iconv('utf-8','us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    $text = strtolower($text);
    return $text;
}

// Handle delete
if ($action === 'delete' && isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $stmt = $conn->prepare("DELETE FROM blog_post WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        $response = ['success'=>true,'message'=>'Post deleted successfully.'];
    } else $response['message'] = 'Failed to delete.';
    $stmt->close();
    echo json_encode($response);
    exit;
}

// Common fields
$cid = intval($_POST['cid'] ?? 0);
$title = trim($_POST['title'] ?? '');
$slug = trim($_POST['slug'] ?? '');
$description = $_POST['description'] ?? '';
$content = $_POST['content'] ?? '';
$tags = trim($_POST['tags'] ?? '');
$keyword = trim($_POST['keyword'] ?? '');
$posted_by = trim($_POST['posted_by'] ?? ($users['name'] ?? ''));

$statusList = ['Draft','Published','Unpublished'];
$status = in_array($_POST['status'] ?? 'Draft', $statusList) ? $_POST['status'] : 'Draft';
$posting_date = date('Y-m-d H:i:s');

if ($action === 'Add' || $action === 'Edit') {

    if (empty($title)) {
        echo json_encode(['success'=>false,'message'=>'Title is required.']);
        exit;
    }

    // slug
    if (empty($slug)) $slug = slugify($title);
    else $slug = slugify($slug);

    // ensure slug unique (for Add and Edit)
    if ($action === 'Add') {
        $stmt = $conn->prepare("SELECT id FROM blog_post WHERE slug = ? LIMIT 1");
        $stmt->bind_param("s", $slug);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            // try append timestamp
            $slug .= '-' . time();
        }
        $stmt->close();
    } else {
        // Edit: allow same slug for same id
        $id = intval($_POST['id'] ?? 0);
        $stmt = $conn->prepare("SELECT id FROM blog_post WHERE slug = ? AND id != ? LIMIT 1");
        $stmt->bind_param("si", $slug, $id);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $slug .= '-' . time();
        }
        $stmt->close();
    }

    // Handle image upload (optional). Same rules as media module
    function handleImageUpload($fileField){
        $uploadDirectory = "../uploads/blog/";
        if (!is_dir($uploadDirectory)) @mkdir($uploadDirectory, 0755, true);

        $allowed = ['image/jpeg', 'image/png'];
        if (!isset($_FILES[$fileField]) || $_FILES[$fileField]['error'] == UPLOAD_ERR_NO_FILE) {
            return ['success'=>true, 'image_path'=>'']; // no file uploaded
        }
        if ($_FILES[$fileField]['error'] !== UPLOAD_ERR_OK) {
            return ['success'=>false,'message'=>'File upload error.'];
        }
        $file = $_FILES[$fileField];
        $fileType = $file['type'];
        $fileSize = $file['size'];
        if (!in_array($fileType, $allowed)) return ['success'=>false,'message'=>'Invalid image type.'];
        if ($fileSize > 5 * 1024 * 1024) return ['success'=>false,'message'=>'Image too large (max 5MB).'];

        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
        $dest = $uploadDirectory . $filename;
        if (move_uploaded_file($file['tmp_name'], $dest)) {
            return ['success'=>true,'image_path'=>'uploads/blog/'.$filename];
        } else return ['success'=>false,'message'=>'Failed to move uploaded file.'];
    }

    $imagePath = '';
    $imageResult = handleImageUpload('image');
    if (!$imageResult['success']) {
        echo json_encode(['success'=>false,'message'=>$imageResult['message']]);
        exit;
    } else {
        $imagePath = $imageResult['image_path'];
    }

    // Add
    if ($action === 'Add') {
        // if no image uploaded, imagePath may be empty string
        $stmt = $conn->prepare("INSERT INTO blog_post (cid, title, slug, image, description, content, posted_by, posting_date, views, keyword, tags, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 0, ?, ?, ?)");
        $stmt->bind_param("issssssssss", $cid, $title, $slug, $imagePath, $description, $content, $posted_by, $posting_date, $keyword, $tags, $status);
        if ($stmt->execute()) {
            $response = ['success'=>true,'message'=>'Post added successfully!','redirect'=>'blog-posts.php'];
        } else {
            $response['message'] = 'Error adding post.';
        }
        $stmt->close();
        echo json_encode($response);
        exit;
    }

    // Edit
    if ($action === 'Edit') {
        $id = intval($_POST['id'] ?? 0);
        // get existing image
        $existing = '';
        $stmt = $conn->prepare("SELECT image FROM blog_post WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res && $res->num_rows > 0) {
            $existing = $res->fetch_assoc()['image'];
        }
        $stmt->close();

        // if no new image uploaded, keep existing
        if (empty($imagePath)) $imagePath = $existing;

        $stmt = $conn->prepare("UPDATE blog_post SET cid = ?, title = ?, slug = ?, image = ?, description = ?, content = ?, posted_by = ?, keyword = ?, tags = ?, status = ? WHERE id = ?");
        $stmt->bind_param("isssssssssi", $cid, $title, $slug, $imagePath, $description, $content, $posted_by, $keyword, $tags, $status, $id);
        if ($stmt->execute()) {
            $response = ['success'=>true,'message'=>'Post updated successfully!','redirect'=>'blog-posts.php'];
        } else {
            $response['message'] = 'Error updating post.';
        }
        $stmt->close();
        echo json_encode($response);
        exit;
    }
}

echo json_encode($response);
exit;
?>
