<?php
include("auth.php");
include("../config.php");

$post = [];
$id = '';
if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);
    $stmt = $conn->prepare("SELECT * FROM blog_post WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res && $res->num_rows > 0) {
        $post = $res->fetch_assoc();
    } else {
        echo "Post not found.";
        exit;
    }
    $stmt->close();
}

// categories for dropdown
$cats = [];
$catSql = "SELECT id, category FROM blog_categories ORDER BY category";
$catRes = mysqli_query($conn, $catSql);
if ($catRes) {
    while ($r = mysqli_fetch_assoc($catRes)) $cats[] = $r;
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?php echo isset($post['id']) ? 'Edit' : 'Add'; ?> Blog Post - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">

</head>
<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">
  <div class="pagetitle">
    <h1><?php echo isset($post['id']) ? 'Edit' : 'Add'; ?> Blog Post</h1>
    <nav><ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item active">Blog Post</li>
    </ol></nav>
  </div>

  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <a href="blog-posts.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Back to List</a>
        <div class="card mt-2">
          <div class="card-body">
            <h5 class="card-title">Post Details</h5>

            <form id="postForm" class="row g-3" enctype="multipart/form-data">
              <div class="col-md-6">
                <label class="form-label">Category <span class="text-danger">*</span></label>
                <select name="cid" id="cid" class="form-select" required>
                  <option value="">Select Category</option>
                  <?php foreach($cats as $c): ?>
                    <option value="<?php echo $c['id']; ?>" <?php echo (isset($post['cid']) && $post['cid'] == $c['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($c['category']); ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              
              <div class="col-md-6">
                <label class="form-label">Tags (Optional)</label>
                <input type="text" name="tags" id="tags" class="form-control" value="<?php echo htmlspecialchars($post['tags'] ?? ''); ?>">
              </div>

              <div class="col-md-12">
                <label class="form-label">Title <span class="text-danger">*</span></label>
                <input type="text" name="title" id="title" class="form-control" required value="<?php echo htmlspecialchars($post['title'] ?? ''); ?>">
              </div>

              <div class="col-md-12">
                <label class="form-label">Slug <small>(auto)</small></label>
                <input type="text" name="slug" id="slug" class="form-control" value="<?php echo htmlspecialchars($post['slug'] ?? ''); ?>">
              </div>

              

              <div class="col-md-6">
                <label class="form-label">Post Image</label>
                <div class="mb-2">
                  <?php if (!empty($post['image'])): ?>
                    <img src="<?php echo '../' . htmlspecialchars($post['image']); ?>" style="max-width:200px; display:block; margin-bottom:8px;" alt="post-image">
                  <?php endif; ?>
                </div>
                <input type="file" name="image" id="image" class="form-control" accept="image/jpeg,image/png">
                <small class="text-muted">Allowed: JPG, PNG. Max 5MB.</small>
              </div>
              
    

              

              <div class="col-md-12">
                <label class="form-label">Content</label>
                <textarea name="content" id="content" class="form-control" rows="12"><?php echo htmlspecialchars($post['content'] ?? ''); ?></textarea>
              </div>
              
              

              
                <div class="col-md-12">
                <label class="form-label">Meta Description</label>
                <textarea name="description" id="description" class="form-control"><?php echo htmlspecialchars($post['description'] ?? ''); ?></textarea>
              </div>
              
              <div class="col-md-12">
                <label class="form-label">Meta Keyword</label>
                <textarea  name="keyword" id="keyword" class="form-control" value="<?php echo htmlspecialchars($post['keyword'] ?? ''); ?>"></textarea>
              </div>
              
              
            <div class="col-md-6">
                <label class="form-label">Posted By</label>
                <input type="text" name="posted_by" id="posted_by" 
                 class="form-control" 
                 value="<?php echo htmlspecialchars($users['name'] ?? $post['posted_by'] ?? ''); ?>">
                </div>
          
          
              <div class="col-md-6">
                    <label class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="Draft" <?php echo (isset($post['status']) && $post['status']=='Draft') ? 'selected' : ''; ?>>Draft</option>
                        <option value="Published" <?php echo (isset($post['status']) && $post['status']=='Published') ? 'selected' : ''; ?>>Published</option>
                        <option value="Unpublished" <?php echo (isset($post['status']) && $post['status']=='Unpublished') ? 'selected' : ''; ?>>Unpublished</option>
                    </select>
                </div>


              <div class="col-md-12">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <?php if (isset($post['id'])): ?>
                  <input type="hidden" name="action" value="Edit">
                  <input type="hidden" name="id" value="<?php echo htmlspecialchars($post['id']); ?>">
                  <button type="submit" class="btn btn-success">Update</button>
                  <a href="blog-posts.php" class="btn btn-secondary">Cancel</a>
                <?php else: ?>
                  <input type="hidden" name="action" value="Add">
                  <button type="submit" class="btn btn-success">Submit</button>
                  <button type="reset" class="btn btn-secondary">Reset</button>
                <?php endif; ?>
                <div id="msg" class="mt-2"></div>
              </div>

            </form>

          </div>
        </div>
      </div>
    </div>
  </section>
</main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  
<script>
tinymce.init({
  selector: '#content',
  plugins: 'link image code lists table media',
  toolbar: 'undo redo | formatselect | bold italic | alignleft aligncenter alignright | bullist numlist | link image media | code',
  height: 400
});

// auto-generate slug
document.getElementById('title').addEventListener('input', function(){
    var slug = this.value.toLowerCase().trim()
      .replace(/[^\w\s-]/g,'')
      .replace(/[\s_-]+/g,'-')
      .replace(/^-+|-+$/g,'');
    document.getElementById('slug').value = slug;
});

// handle form submit via fetch
document.getElementById('postForm').addEventListener('submit', function(e){
    e.preventDefault();
    var form = document.getElementById('postForm');
    // trigger tinyMCE to update textareas
    tinymce.triggerSave();
    var formData = new FormData(form);
    fetch('blog-post-action.php', {
        method: 'POST',
        body: formData
    }).then(r=>r.json()).then(res=>{
        var msg = document.getElementById('msg');
        if(res.success){
            msg.innerHTML = '<div class="alert alert-success">'+res.message+'</div>';
            if(res.redirect) setTimeout(function(){ location.href = res.redirect; }, 800);
        } else {
            msg.innerHTML = '<div class="alert alert-danger">'+res.message+'</div>';
        }
    }).catch(err=>{
        console.error(err);
        document.getElementById('msg').innerHTML = '<div class="alert alert-danger">Request failed.</div>';
    });
});
</script>
</body>
</html>
