<?php
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Blog Posts - <?php echo htmlspecialchars($settings['site_name']); ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">
  <div class="pagetitle">
    <h1>Blog Posts</h1>
    <nav><ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item active">Blog Posts</li>
    </ol></nav>
  </div>

  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <?php if(($_SESSION['role'] ?? '') === 'Admin') { ?>
          <a href="blog-post.php" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> Add New</a>
        <?php } ?>
        <div class="card mt-2">
          <div class="card-body">
            <h5 class="card-title">Posts</h5>
            <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
            <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Action</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Image</th>
                    <th>Description</th>
                    <th>Posted</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                <?php
                $sql = "SELECT p.*, c.category FROM blog_post p LEFT JOIN blog_categories c ON p.cid = c.id WHERE p.status IS NOT NULL ORDER BY p.posting_date DESC";
                $result = mysqli_query($conn, $sql);
                $sl = 1;
                if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td style='white-space:nowrap;'>".$sl."</td>";
                        // Action buttons
                        echo "<td style='white-space:nowrap;'>";
                        echo "<a href='blog-post.php?id=" . base64_encode($row['id']) . "' class='btn btn-sm btn-warning'><i class='bi bi-pen'></i></a> ";
                        if(($_SESSION['role'] ?? '') === 'Admin'){
                            echo "<button class='btn btn-sm btn-danger' onclick='deletePost(".$row['id'].")'><i class='bi bi-trash'></i></button>";
                        }
                        echo "</td>";

                        echo "<td>".htmlspecialchars($row['title'])."</td>";
                        echo "<td style='white-space:nowrap;'>".htmlspecialchars($row['category'] ?? 'Uncategorized')."</td>";

                        // Image thumb
                        $imgHtml = '<span class="text-muted">No Image</span>';
                        if (!empty($row['image'])) {
                            $imgPath = '../' . ltrim($row['image'], '/');
                            $imgHtml = "<img src='".htmlspecialchars($imgPath)."' style='max-width:80px; max-height:60px;' alt='thumb'>";
                        }
                        echo "<td>".$imgHtml."</td>";

                        // Short description (2-4 words + ...)
                        $desc = strip_tags($row['description'] ?? '');
                        $words = preg_split('/\s+/', trim($desc));
                        if (count($words) > 4) {
                            $short = implode(' ', array_slice($words,0,4)) . '...';
                        } else {
                            $short = $desc ?: '—';
                        }
                        echo "<td style='max-width:200px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;'>".htmlspecialchars($short)."</td>";

                        echo "<td style='white-space:nowrap;'>".htmlspecialchars($row['posting_date'])."</td>";
                        echo "<td style='white-space:nowrap;'>".htmlspecialchars($row['status'])."</td>";
                        echo "</tr>";
                        $sl++;
                    }
                } else {
                    echo "<tr><td colspan='8' class='text-center'>No posts found.</td></tr>";
                }
                ?>
                </tbody>
              </table>
            </div> <!-- end table responsive -->
          </div>
        </div>
      </div>
    </div>
  </section>
</main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  
<script>
function deletePost(id){
    if(!confirm('Are you sure you want to delete this post?')) return;
    var token = document.getElementById('csrf_token').value;
    fetch('blog-post-action.php', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: 'action=delete&id=' + encodeURIComponent(id) + '&csrf_token=' + encodeURIComponent(token)
    }).then(r=>r.json()).then(res=>{
        alert(res.message || (res.success ? 'Deleted' : 'Failed'));
        if(res.success) location.reload();
    }).catch(e=>{ console.error(e); alert('Request failed'); });
}
</script>
</body>
</html>
