<?php
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Handle file upload (AJAX Request)
if (isset($_POST['ajax']) && $_POST['ajax'] === '1') {
  header('Content-Type: application/json');
  $response = ['inserted' => 0, 'skipped' => []];

  $course_id = intval($_POST['course_id']);
  $batch_id  = intval($_POST['batch_id']);

  if ($course_id && $batch_id && isset($_FILES['csv_file']['tmp_name'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    $handle = fopen($file, "r");

    if ($handle !== FALSE) {
      $row = 0;
      while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
        if ($row == 0) { $row++; continue; }

        $name  = trim($data[0]);
        $mobile = trim($data[1]);
        $email = trim($data[2]);
        $dob   = trim($data[3]);

        // Missing fields
        if (empty($name) || empty($mobile) || empty($email)) {
          $response['skipped'][] = [
            'row' => $row,
            'name' => $name,
            'mobile' => $mobile,
            'email' => $email,
            'reason' => 'Missing required fields'
          ];
          $row++;
          continue;
        }

        // Duplicate mobile check
        $check = $conn->prepare("SELECT id FROM student WHERE mobile = ?");
        $check->bind_param("s", $mobile);
        $check->execute();
        $check->store_result();
        if ($check->num_rows > 0) {
          $response['skipped'][] = [
            'row' => $row,
            'name' => $name,
            'mobile' => $mobile,
            'email' => $email,
            'reason' => 'Mobile already exists'
          ];
          $check->close();
          $row++;
          continue;
        }
        $check->close();

        // Insert new student
        $reg_no = "SI" . rand(10000000, 99999999);
        $password = password_hash("123456", PASSWORD_DEFAULT);

        $stmt = $conn->prepare("INSERT INTO student (registration_no, name, mobile, email, dob, reference, password, status, created_at, updated_at)
                                VALUES (?, ?, ?, ?, ?, '', ?, 'Active', NOW(), NOW())");
        $stmt->bind_param("ssssss", $reg_no, $name, $mobile, $email, $dob, $password);

        if ($stmt->execute()) {
          $student_id = $stmt->insert_id;
          $response['inserted']++;

          // Enrolment entry
          $enrol = $conn->prepare("INSERT INTO enrolments (cid, bid, fee_status, mobile, enrolment_date, status, created_at, updated_at)
                                   VALUES (?, ?, 'Pending', ?, CURDATE(), 'Enrolled', NOW(), NOW())");
          $enrol->bind_param("iis", $course_id, $batch_id, $mobile);
          $enrol->execute();
          $enrol->close();
        } else {
          $response['skipped'][] = [
            'row' => $row,
            'name' => $name,
            'mobile' => $mobile,
            'email' => $email,
            'reason' => 'Database insertion failed'
          ];
        }

        $stmt->close();
        $row++;
      }
      fclose($handle);
    }
  }

  echo json_encode($response);
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Bulk Student Upload - <?php echo $settings['site_name']; ?></title>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <style>
    #progress-container { display: none; margin-top: 15px; }
    #progress-bar { width: 0%; height: 20px; background: #28a745; text-align: center; color: #fff; }
  </style>
</head>

<body>
  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Bulk Student Upload</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Bulk Upload</li>
        </ol>
      </nav>
    </div>

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
<a href="students.php" class="btn btn-primary btn-sm mb-2"><i class="bi bi-arrow-left"></i>Student List</a>
          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Upload Students CSV</h5>

              <div id="result-message"></div>

              <form id="uploadForm" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <input type="hidden" name="ajax" value="1">

                <div class="row mb-3">
                  <div class="col-md-4">
                    <label class="form-label">Select Course</label>
                    <select name="course_id" class="form-select" required>
                      <option value="">-- Select Course --</option>
                      <?php
                      $res = mysqli_query($conn, "SELECT * FROM course WHERE deleted_at IS NULL AND status='Active'");
                      while ($c = mysqli_fetch_assoc($res)) {
                        echo "<option value='{$c['id']}'>" . htmlspecialchars($c['name']) . "</option>";
                      }
                      ?>
                    </select>
                  </div>

                  <div class="col-md-4">
                    <label class="form-label">Select Batch</label>
                    <select name="batch_id" class="form-select" required>
                      <option value="">-- Select Batch --</option>
                      <?php
                      $res2 = mysqli_query($conn, "SELECT * FROM batch WHERE deleted_at IS NULL AND status='Active'");
                      while ($b = mysqli_fetch_assoc($res2)) {
                        echo "<option value='{$b['id']}'>" . htmlspecialchars($b['title']) . "</option>";
                      }
                      ?>
                    </select>
                  </div>

                  <div class="col-md-4">
                    <label class="form-label">Upload CSV File</label>
                    <input type="file" name="csv_file" accept=".csv" class="form-control" required>
                  </div>
                </div>

                <div id="progress-container" class="mb-3">
                  <div id="progress-bar">0%</div>
                </div>

                <div class="text-center">
                  <button type="submit" class="btn btn-success">
                    <i class="bi bi-upload"></i> Upload & Import
                  </button>
                  <a href="sample_student.csv" class="btn btn-outline-primary ms-2">
                    <i class="bi bi-download"></i> Download Sample CSV
                  </a>
                </div>
              </form>

              <div id="skipped-section" class="mt-4" style="display:none;">
                <h5>Skipped Rows</h5>
                <div class="table-responsive">
                  <table class="table table-bordered">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>Reason</th>
                      </tr>
                    </thead>
                    <tbody id="skipped-body"></tbody>
                  </table>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
  </main>

  <?php include("templates/footer.php"); ?>

  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script>
    document.getElementById("uploadForm").addEventListener("submit", function(e) {
      e.preventDefault();
      const form = e.target;
      const formData = new FormData(form);
      const xhr = new XMLHttpRequest();

      const progressContainer = document.getElementById("progress-container");
      const progressBar = document.getElementById("progress-bar");
      const resultMsg = document.getElementById("result-message");
      const skippedSection = document.getElementById("skipped-section");
      const skippedBody = document.getElementById("skipped-body");

      progressContainer.style.display = "block";
      progressBar.style.width = "0%";
      progressBar.textContent = "0%";
      skippedSection.style.display = "none";
      skippedBody.innerHTML = "";
      resultMsg.innerHTML = "";

      xhr.upload.addEventListener("progress", function(e) {
        if (e.lengthComputable) {
          const percent = Math.round((e.loaded / e.total) * 100);
          progressBar.style.width = percent + "%";
          progressBar.textContent = percent + "%";
        }
      });

      xhr.onreadystatechange = function() {
        if (xhr.readyState === 4 && xhr.status === 200) {
          const res = JSON.parse(xhr.responseText);
          resultMsg.innerHTML = `<div class='alert alert-info'>
            ${res.inserted} students uploaded successfully.
          </div>`;

          if (res.skipped && res.skipped.length > 0) {
            skippedSection.style.display = "block";
            res.skipped.forEach((row, i) => {
              skippedBody.innerHTML += `
                <tr>
                  <td>${i + 1}</td>
                  <td>${row.name || '-'}</td>
                  <td>${row.mobile || '-'}</td>
                  <td>${row.email || '-'}</td>
                  <td>${row.reason}</td>
                </tr>`;
            });
          }
        }
      };

      xhr.open("POST", "", true);
      xhr.send(formData);
    });
  </script>
</body>
</html>
