<?php
include("../config.php");

header('Content-Type: application/json');

// Validate input
if (!isset($_POST['issue_list']) || empty($_POST['issue_list'])) {
    echo json_encode([
        "success" => false,
        "message" => "No students selected."
    ]);
    exit;
}

$issued_count = 0;

foreach ($_POST['issue_list'] as $data) {

    // mobile|cid|bid
    list($mobile, $cid, $bid) = explode("|", $data);

    // Check duplicate
    $check = $conn->query("
        SELECT id FROM issue_certificate
        WHERE mobile = '$mobile'
          AND cid = '$cid'
          AND bid = '$bid'
          AND deleted_at IS NULL
        LIMIT 1
    ");

    if ($check->num_rows > 0) {
        continue; // Skip already issued
    }

    // Generate certificate number
 $certificate_no = "CERT-" . strtoupper(bin2hex(random_bytes(7)));


    $insert = $conn->query("
        INSERT INTO issue_certificate
        (certificate_no, mobile, cid, bid, issue_date, status)
        VALUES
        ('$certificate_no', '$mobile', '$cid', '$bid', NOW(), 'Issued')
    ");

    if ($insert) {
        $issued_count++;
    }
}

echo json_encode([
    "success" => true,
    "message" => "$issued_count Certificate(s) issued successfully!"
]);

exit;
?>

