<?php
session_start();

// Generate random 5-character string
$chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
$captcha_text = substr(str_shuffle($chars), 0, 5);

// Save in session
$_SESSION['captcha_text'] = $captcha_text;

// Create image
$width = 120;
$height = 40;
$image = imagecreate($width, $height);

// Colors
$bg = imagecolorallocate($image, 255, 255, 255); // white
$fg = imagecolorallocate($image, 0, 0, 0);       // black

// Add text
imagestring($image, 5, 20, 10, $captcha_text, $fg);

// Add some noise
for ($i=0; $i<50; $i++) {
    $x = rand(0,$width);
    $y = rand(0,$height);
    imagesetpixel($image, $x, $y, $fg);
}

// Output image
header("Content-type: image/png");
imagepng($image);
imagedestroy($image);
