<?php
include("auth.php");
include("../config.php");

// ✅ CSRF Protection
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    die("Invalid CSRF token");
}

// ✅ Validate selected students
if (empty($_POST['students']) || !is_array($_POST['students'])) {
    die("No students selected.");
}

// ✅ Fetch Settings (logo, certificate_bg, signature)
$settingsQuery = $conn->query("SELECT * FROM settings WHERE id = 1");
$settings = $settingsQuery->fetch_assoc();

$certificate_bg = !empty($settings['certificate_bg']) ? "../" . $settings['certificate_bg'] : "assets/default_certificate_bg.jpg";
$logo = !empty($settings['logo']) ? "../" . $settings['logo'] : "assets/default_logo.png";
$signature = !empty($settings['signature']) ? "../" . $settings['signature'] : "assets/default_signature.png";

// ✅ Fetch selected student data
$ids = implode(",", array_map('intval', $_POST['students']));

$q = $conn->query("
    SELECT 
        s.*,
        e.enrolment_id,
        e.cid AS course_id,
        e.bid AS batch_id,
        e.enrolment_date,
        c.name AS course_name,
        b.batch_start AS start,
        b.batch_end AS end,
        ic.certificate_no
    FROM student s
    LEFT JOIN enrolments e 
           ON e.mobile = s.mobile
    LEFT JOIN course c 
           ON c.id = e.cid
    LEFT JOIN batch b 
           ON b.id = e.bid
    LEFT JOIN issue_certificate ic 
           ON ic.mobile = s.mobile
          AND ic.cid = e.cid
          AND ic.bid = e.bid
    WHERE s.id IN($ids)
");

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Certificate Preview</title>

<style>
body {
    margin: 0;
    padding: 20px;
    background: #f2f2f2;
    font-family: "Times New Roman", serif;
}

/* ✅ A4 Portrait Page */
.page {
    width: 210mm;
    height: 297mm;
    background: white;
    margin: 0 auto 20px auto;
    box-shadow: 0 0 10px #999;
    page-break-after: always;
    padding: 0;
}

/* ✅ Each Half (for 2 certificates per page) */
.half {
    width: 100%;
    height: 50%;
    padding: 10mm;
    box-sizing: border-box;
    border-bottom: 1px dashed #aaa;
    position: relative;
}
.half:last-child {
    border-bottom: none;
}

/* ✅ Certificate Container */
.certificate {
    width: 100%;
    height: 100%;
    position: relative;
    box-sizing: border-box;
    padding: 20px 50px;
    background-repeat: no-repeat;
    background-size: cover;
    background-position: center;
    color: #222;
}

/* ✅ Print Adjustments */
@media print {
    @page { size: A4 portrait; margin: 0; }
    body { background: white !important; padding: 0; }
    .page { box-shadow: none; margin: 0; }
    .no-print { display: none !important; }
    * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }
}
</style>
</head>
<body>

<!-- ✅ Print Button -->
<div style="text-align:center;" class="no-print">
    <button onclick="window.print()" 
        style="padding:10px 20px;margin-bottom:10px; background:#4a04c3; color:white; border:none; border-radius:5px;">
        Print Certificates
    </button>
</div>

<?php
$count = 0;

while ($s = $q->fetch_assoc()) {
    $student_name = htmlspecialchars($s['name']);
    $registration_no = htmlspecialchars($s['registration_no']);
    $courseName = htmlspecialchars($s['course_name'] ?: 'N/A');

    $from = !empty($s['start']) ? date("M j, Y", strtotime($s['start'])) : 'N/A';
    $to = !empty($s['end']) ? date("M j, Y", strtotime($s['end'])) : 'N/A';

    // Optional: Generate a placeholder certificate number
    $certificate_no = !empty($s['certificate_no']) 
                    ? $s['certificate_no'] 
                    : "Not Issued";

    if ($count % 2 == 0) echo "<div class='page'>"; // open A4 page
?>
<div class="half">
    <div class="certificate" style="background-image: url('<?= $certificate_bg ?>');">

        <!-- TOP LOGO -->
        <div style="text-align:center;">
            <img src="<?= $settings['logo'] ?>" style="height:50px;">
        </div>

        <!-- TITLE -->
        <div style="text-align:center; font-size:15px; margin-top:130px;">
            This is to certify that
        </div>

        <!-- STUDENT NAME -->
        <div style="text-align:center; font-size:35px; font-weight:bold; margin-top:20px;">
            <?= $student_name ?>
        </div>

        <!-- COURSE COMPLETION -->
        <div style="text-align:center; font-size:17px; margin-top:10px;">
            Reg No: <b><?= $registration_no ?></b> has successfully completed the course
            <br>
            <b style="font-size:20px;"><?= $courseName ?></b>
        </div>

        <!-- DATE RANGE -->
        <div style="position:absolute; left:125px; bottom:70px; text-align:center; font-size:13px;">
            Dated: <br><br><b><?= $from ?></b> to <b><?= $to ?></b>
        </div>

        <!-- SIGNATURE -->
        <div style="position:absolute; right:125px; bottom:40px; text-align:center;">
            <img src="<?= htmlspecialchars($signature) ?>" alt="Signature" style="height:50px;"><br>
            <span style="font-size:14px;">Authorized Signature</span>
        </div>

        <!-- CERTIFICATE NUMBER (optional, small footer) -->
        <div style="position:absolute; bottom:10px; left:20px; font-size:11px; color:#555;">
            Certificate No: <?= htmlspecialchars($certificate_no) ?>
        </div>

    </div>
</div>
<?php
    $count++;
    if ($count % 2 == 0) echo "</div>"; // close A4 page
}
if ($count % 2 != 0) echo "</div>"; // close last page if odd
?>

</body>
</html>
