<?php  
include("auth.php");
include("../config.php");

// ✅ Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// ✅ Handle Template Update (Certificate Background or Signature)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['template_type'])) {
    header('Content-Type: application/json');
    $response = ['success' => false, 'message' => ''];

    if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Invalid CSRF token.';
        echo json_encode($response);
        exit;
    }

    $uploadDir = "../assets/img/certificate-templates/";
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    $field = $_POST['template_type'];
    if (!empty($_FILES['new_bg']['name'])) {
        $fileName = time() . "_" . basename($_FILES["new_bg"]["name"]);
        $targetFile = $uploadDir . $fileName;
        $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

        if (in_array($fileType, ['jpg', 'jpeg', 'png', 'webp'])) {
            if (move_uploaded_file($_FILES["new_bg"]["tmp_name"], $targetFile)) {
                $pathToSave = "assets/img/certificate-templates/" . $fileName;

                // ✅ Update database field based on template type
                if ($field === "certificate_bg") {
                    $stmt = $conn->prepare("UPDATE settings SET certificate_bg = ? WHERE id = 1");
                } elseif ($field === "signature") {
                    $stmt = $conn->prepare("UPDATE settings SET signature = ? WHERE id = 1");
                } else {
                    $response['message'] = 'Invalid template type.';
                    echo json_encode($response);
                    exit;
                }

                if (!$stmt) {
                    $response['message'] = 'Prepare failed: ' . $conn->error;
                } else {
                    $stmt->bind_param("s", $pathToSave);
                    if ($stmt->execute()) {
                        $response['success'] = true;
                        $response['message'] = ucfirst(str_replace('_', ' ', $field)) . ' updated successfully!';
                    } else {
                        $response['message'] = 'Database update failed: ' . $stmt->error;
                    }
                    $stmt->close();
                }
            } else {
                $response['message'] = 'Error uploading file.';
            }
        } else {
            $response['message'] = 'Invalid file format. Only JPG, PNG, WEBP allowed.';
        }
    } else {
        $response['message'] = 'No file selected.';
    }

    echo json_encode($response);
    exit;
}

// ✅ Handle batch filter (AJAX REQUEST)
if (isset($_POST['set_batch_filter'])) {
    $_SESSION['batch_filter'] = $_POST['set_batch_filter'];
    exit("OK");
}

// ✅ Get applied batch filter from session
$batch_filter = $_SESSION['batch_filter'] ?? "all";

// ✅ Fetch settings for certificate background
$settingsQuery = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($settingsQuery);
$settings = $result->fetch_assoc();

$current_cert_bg = $settings['certificate_bg'] ?? 'assets/img/no-image.png';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Generate Certificate - <?= htmlspecialchars($settings['site_name'] ?? 'Smart Institute') ?></title>

  <link href="./<?= htmlspecialchars($settings['fevicon']) ?>" rel="icon">
  <link href="./<?= htmlspecialchars($settings['fevicon']) ?>" rel="apple-touch-icon">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">

  <style>
  .certificate-preview {
    width: 350px;
    height: 250px;
    border: 2px dashed #888;
    border-radius: 8px;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8f9fa;
  }
  .certificate-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }
  .upload-message {
    display:none;
    margin-top:10px;
    padding:10px;
    border-radius:5px;
    font-weight:500;
    text-align:center;
  }
  </style>
</head>

<body>

<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">

<div class="pagetitle">
  <h1>Generate Certificate</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
      <li class="breadcrumb-item active">Generate Certificate</li>
    </ol>
  </nav>
</div>

<!-- ✅ Certificate Template + Signature Update Section -->
<div class="card mb-4 shadow-sm border-0">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h5 class="mb-0">Manage Certificate Template & Signature</h5>
  </div>
  <div class="card-body">
    <div class="row g-4 justify-content-center">

      <!-- ✅ Certificate Template Column -->
      <div class="col-md-6 text-center">
        <h6 class="fw-semibold mb-3">Current Certificate Template</h6>
        <div class="certificate-preview mx-auto mb-3">
          <img src="../<?= htmlspecialchars($current_cert_bg) ?>" 
               alt="Certificate Template" 
               onerror="this.src='assets/img/no-image.png';">
        </div>

        <form class="update-template-form" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
          <input type="hidden" name="template_type" value="certificate_bg">

          <label class="form-label fw-semibold mb-1">
            Upload New Certificate Template (A4 Landscape)
          </label>
          <input type="file" name="new_bg" class="form-control mb-2" accept=".jpg,.jpeg,.png,.webp" required>

          <div class="progress mt-2" style="height:8px; display:none;">
            <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width:0%"></div>
          </div>
          <div class="upload-message"></div>

          <button type="submit" class="btn btn-info btn-sm mt-3 px-4">
            <i class="bi bi-upload me-1"></i>Upload & Update
          </button>
        </form>
      </div>

      <!-- ✅ Signature Upload Column -->
      <div class="col-md-6 text-center">
        <h6 class="fw-semibold mb-3">Current Signature</h6>
        <div class="certificate-preview mx-auto mb-3" style="height: 180px;">
          <img src="../<?= htmlspecialchars($settings['signature'] ?? 'assets/img/no-image.png') ?>" 
               alt="Authorized Signature" 
               onerror="this.src='assets/img/no-image.png';" 
               style="object-fit: contain;">
        </div>

        <form class="update-template-form" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
          <input type="hidden" name="template_type" value="signature">

          <label class="form-label fw-semibold mb-1">
            Upload New Signature (PNG with Transparent Background Recommended)
          </label>
          <input type="file" name="new_bg" class="form-control mb-2" accept=".jpg,.jpeg,.png,.webp" required>

          <div class="progress mt-2" style="height:8px; display:none;">
            <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" style="width:0%"></div>
          </div>
          <div class="upload-message"></div>

          <button type="submit" class="btn btn-success btn-sm mt-3 px-4">
            <i class="bi bi-upload me-1"></i>Upload Signature
          </button>
        </form>
      </div>

    </div>
  </div>
</div>

<!-- ✅ Batch Filter + Student Table Section -->
<section class="section">

<form id="generateForm" action="certificate-generate.php" method="POST" target="_blank">
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

  <div class="card">
    <div class="card-header">
    
     <div class="mb-2 d-flex align-items-center">
    <label class="me-2"><strong>Batch Filter:</strong></label>
    <select id="batchFilter" class="form-select w-25">
        <option value="">Select Batch</option>
        <?php
        $batchQ = $conn->query("SELECT id, title FROM batch WHERE deleted_at IS NULL ORDER BY title ASC");
        while ($b = $batchQ->fetch_assoc()) {
            $selected = ($batch_filter == $b['id']) ? "selected" : "";
            echo "<option value='{$b['id']}' $selected>{$b['title']}</option>";
        }
        ?>
    </select>
   </div>
        
        
      <div class="mb-2"><strong>Select Students to Generate Certificate</strong></div>
      <div class="d-flex justify-content-between align-items-center">
        <input type="text" id="searchStudent" class="form-control w-50" placeholder="Search students...">
       
        <button type="submit" class="btn btn-primary" id="generateBtn">Generate Certificate</button>
        
      </div>
    </div>

    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-striped" id="studentTable">
          <thead>
            <tr>
              <th><input type="checkbox" id="checkAll"></th>
              <th><button type="button" id="bulkIssueBtn" class="btn btn-success btn-sm">Bulk Issue</button> <input type="checkbox" id="Allcheck"></th>
              <th>Action</th>
              <th>Photo</th>
              <th>Reg No</th>
              <th>Name</th>
              <th>Mobile</th>
              <th>Email</th>
              <th>Fee Status</th>
            </tr>
          </thead>
          <tbody id="studentBody">
           <tr>
             <td colspan="9" class="text-center text-muted py-4">
               Select batch to load students.
             </td>
           </tr>
          </tbody>

        </table>
      </div>
    </div>
  </div>
</form>
</section>

</main>

<?php include("templates/footer.php"); ?>

<a href="#" class="back-to-top d-flex align-items-center justify-content-center">
  <i class="bi bi-arrow-up-short"></i>
</a>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/js/main.js"></script>

<script>

// ✅ Select / Deselect All (only enabled checkboxes)
document.getElementById('checkAll').onclick = function() {
    const status = this.checked;

    document.querySelectorAll("input[name='students[]']").forEach(c => {
        if (!c.disabled) {
            c.checked = status;
        }
    });
};

document.getElementById('Allcheck').onclick = function() {
    const status = this.checked;

    document.querySelectorAll("input[name='issue_list[]']").forEach(c => {
        if (!c.disabled) {
            c.checked = status;
        }
    });
};

// ✅ Require at least one student
document.getElementById("generateForm").addEventListener("submit", function(e) {
  if (document.querySelectorAll("input[name='students[]']:checked").length === 0) {
    e.preventDefault();
    alert("Please select at least one student to generate certificates.");
  }
});

// ✅ Live Search
document.getElementById("searchStudent").addEventListener("keyup", function() {
  let input = this.value.toLowerCase();
  let rows = Array.from(document.querySelectorAll("#studentTable tbody tr"));
  let matched = [], unmatched = [];

  rows.forEach(row => {
    let text = row.innerText.toLowerCase();
    if (text.includes(input)) matched.push(row);
    else unmatched.push(row);
  });

  let tbody = document.querySelector("#studentTable tbody");
  tbody.innerHTML = "";
  matched.forEach(r => tbody.appendChild(r));
  unmatched.forEach(r => tbody.appendChild(r));
});

// ✅ Save batch filter to session and reload
document.getElementById("batchFilter").addEventListener("change", function () {
    let batch = this.value;
    let tbody = document.getElementById("studentBody");

    if (batch === "") {
        tbody.innerHTML = `
            <tr>
                <td colspan="9" class="text-center text-muted py-4">
                    Select batch to load students.
                </td>
            </tr>`;
        return;
    }

    let formData = new FormData();
    formData.append("load_students", batch);

    fetch("fetch-students-for-certificate.php", {
        method: "POST",
        body: formData
    })
        .then(resp => resp.text())
        .then(data => {
            tbody.innerHTML = data;
        });
});


// ✅ Template Upload AJAX (Certificate/Signature)
document.querySelectorAll(".update-template-form").forEach(form => {
  const progress = form.querySelector(".progress");
  const bar = form.querySelector(".progress-bar");
  const message = form.querySelector(".upload-message");
  const img = form.parentElement.querySelector("img");

  form.addEventListener("submit", function(e) {
    e.preventDefault();
    const file = form.querySelector("input[name='new_bg']").files[0];
    if (!file) return;

    const formData = new FormData(form);
    const xhr = new XMLHttpRequest();
    xhr.open("POST", "", true);

    progress.style.display = "block";
    bar.style.width = "0%";
    message.style.display = "none";

    xhr.upload.onprogress = e => {
      if (e.lengthComputable) bar.style.width = Math.round((e.loaded / e.total) * 100) + "%";
    };

    xhr.onload = () => {
      bar.style.width = "100%";
      try {
        const result = JSON.parse(xhr.responseText);
        if (result.success) {
          showMessage(result.message, "success");
          const reader = new FileReader();
          reader.onload = ev => img.src = ev.target.result;
          reader.readAsDataURL(file);
        } else showMessage("❌ " + result.message, "danger");
      } catch { showMessage("❌ Unexpected error", "danger"); }
      setTimeout(() => progress.style.display = "none", 2000);
    };
    xhr.send(formData);

    function showMessage(text, type) {
      message.textContent = text;
      message.style.display = "block";
      message.style.background = type === "success" ? "#d1e7dd" : "#f8d7da";
      message.style.color = type === "success" ? "#0f5132" : "#842029";
      message.style.border = "1px solid " + (type === "success" ? "#badbcc" : "#f5c2c7");
      setTimeout(() => {
        message.style.transition = "opacity 0.8s ease";
        message.style.opacity = "0";
        setTimeout(() => { message.style.display = "none"; message.style.opacity = "1"; }, 800);
      }, 3000);
    }
  });
});

// --------------------------------------------
// ISSUE CERTIFICATE BUTTON CLICK
// --------------------------------------------
document.addEventListener("click", function(e) {
    if (e.target.classList.contains("issueCertBtn")) {
        let btn = e.target;

        let name = btn.dataset.name;
        let mobile = btn.dataset.mobile;
        let cid = btn.dataset.cid;
        let bid = btn.dataset.bid;

        if (!confirm("Issue certificate to " + name + " ?")) return;

        let formData = new FormData();
        formData.append("mobile", mobile);
        formData.append("cid", cid);
        formData.append("bid", bid);

        fetch("issue-certificate-save.php", {
            method: "POST",
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                // alert("Certificate Issued! Certificate No: " + data.certificate_no);

                // Reload student list
                document.getElementById("batchFilter").dispatchEvent(new Event("change"));
            } else {
                alert("Error: " + data.message);
            }
        });
    }
});

</script>
<script>
document.getElementById('bulkIssueBtn').addEventListener('click', function() {
    // collect selected issue_list[] values
    const checked = Array.from(document.querySelectorAll('input[name="issue_list[]"]:checked'));
    if (checked.length === 0) {
        alert("Please select at least one student to issue.");
        return;
    }

    // build FormData
    const fd = new FormData();
    checked.forEach((el, idx) => fd.append('issue_list[]', el.value));

    // include CSRF token if needed
    const csrf = document.querySelector('input[name="csrf_token"]');
    if (csrf) fd.append('csrf_token', csrf.value);

    // show a lightweight "working" indicator (optional)
    const btn = this;
    btn.disabled = true;
    btn.innerText = 'Issuing...';

    fetch('bulk_issue.php', {
        method: 'POST',
        body: fd,
        credentials: 'same-origin' // keep session cookies
    })
    .then(resp => resp.json().catch(() => ({ success: false, message: 'Invalid JSON response' })))
    .then(data => {
        btn.disabled = false;
        btn.innerText = 'Bulk Issue';
        if (data.success) {
            alert(data.message || 'Certificates issued successfully!');
            // reload students for current batch
            document.getElementById("batchFilter").dispatchEvent(new Event("change"));
        } else {
            alert('Error: ' + (data.message || 'Unknown error'));
            console.error('bulk_issue response:', data);
        }
    })
    .catch(err => {
        btn.disabled = false;
        btn.innerText = 'Bulk Issue';
        alert('Request failed. See console for details.');
        console.error(err);
    });
});
</script>
<script>
document.addEventListener("click", function(e) {
    if (e.target.classList.contains("handoverBtn")) {

        let btn = e.target;
        let mobile = btn.dataset.mobile;
        let bid = btn.dataset.bid;
        let cid = btn.dataset.cid;

        if (!confirm("Mark certificate as handed over?")) return;

        let fd = new FormData();
        fd.append("mobile", mobile);
        fd.append("bid", bid);
        fd.append("cid", cid);

        btn.disabled = true;
        btn.innerText = "Updating...";

        fetch("update_handover.php", {
            method: "POST",
            body: fd
        })
        .then(r => r.json())
        .then(res => {
            btn.disabled = false;
            if (res.success) {
                // alert("Handover updated!");
                // reload table
                document.getElementById("batchFilter").dispatchEvent(new Event("change"));
            } else {
                alert("Error: " + res.message);
            }
        })
        .catch(err => {
            btn.disabled = false;
            alert("Request failed");
            console.error(err);
        });
    }
});
</script>

</body>
</html>
