<?php  
include("auth.php");
include("../config.php");

$content = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM content WHERE content_id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $content = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Content not found.";
        exit;
    }

    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Content <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Content</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Content</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="contents.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i> Content List</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Content Details</h5>
              
               <form class="row g-3" id="contentform">
                <div class="col-md-12">
                  <label for="title" class="form-label">Content Title <span class="text-danger">*</span></label>
                  <input type="text" class="form-control" id="content_title" name="content_title" value="<?php echo isset($content['content_title']) ? htmlspecialchars($content['content_title']) : ''; ?>" placeholder="Enter Content Title" required <?php echo ($_SESSION['role'] ?? '') !== 'Admin' ? 'readonly' : ''; ?>>
                </div>
                <div class="col-md-12">
                  <label for="Content" class="form-label">Content <span class="text-danger">*</span></label>
                  <!-- Quill editor container -->
                  <div id="quillEditor" style="height: 300px;">
                  </div>
                  <!-- Hidden input to store HTML content for backend -->
                  <input type="hidden" id="content" name="content" value="<?php echo isset($content['content']) ? htmlspecialchars($content['content']) : ''; ?>" required>
                </div>

                <div id="msg"></div>
                <div class="col-md-12">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                   <?php if(isset($_GET['id'])) {  ?>
                   <input type="hidden" class="form-control" id="id" name="id" value="<?php echo $id; ?>">
                   <input type="hidden" class="form-control" id="action" name="action" value="Edit">
                   <button class="btn btn-success" type="submit">Update</button>
                   <a href="contents.php" class="btn btn-secondary" type="button">Cancel</a>
                   
                   <?php } else { ?>
                   <input type="hidden" class="form-control" id="action" name="action" value="Add">
                   <button class="btn btn-success" type="submit">Submit</button>
                   <button class="btn btn-secondary" type="reset">Reset</button>
                   <?php } ?>
                </div>
              </form>

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script>
  // Pass PHP data to JS
  var contentData = <?php echo isset($content['content']) ? json_encode($content['content']) : '""'; ?>;
</script>
<script src="./scripts/content.js"></script>



</body>

</html>