<?php
include("auth.php");
include("../config.php");

// ✅ CSRF Protection
if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) die("Invalid CSRF");

// ✅ Check selected employees
if (!isset($_POST['employees']) || empty($_POST['employees'])) die("No employee selected.");

// ✅ Fetch current settings (for logo, site_name, address, id background, etc.)
$settingsQuery = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($settingsQuery);
$settings = $result->fetch_assoc();

$employee_bg = !empty($settings['employee_id_bg']) ? "../" . $settings['employee_id_bg'] : "assets/img/no-image.png";

$ids = implode(",", array_map('intval', $_POST['employees']));
$q = $conn->query("SELECT * FROM users WHERE user_id IN ($ids)");
?>
<!DOCTYPE html>
<html>
<head>
<title>Employee ID Card Preview (A4 Layout)</title>
<style>
body {
  margin: 0;
  padding: 20px;
  background: #f3f3f3;
  font-family: Arial, sans-serif;
}

/* A4 sheet for printing */
.sheet {
  width: 794px;
  min-height: 1123px;
  background: white;
  padding: 20px;
  margin: auto;
  box-shadow: 0 0 8px rgba(0,0,0,0.4);
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  page-break-after: always;
}

/* ID Card box */
.id-card {
  width: 241px;
  height: 351px;
  background: url('<?= htmlspecialchars($employee_bg) ?>') no-repeat center center / cover;
  border-radius: 8px;
  border: 1px solid #444;
  padding: 4px;
  overflow: hidden;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

/* Photo */
.photo {
  width: 80px;
  height: 80px;
  margin: 14px auto 0 auto;
  border: 3px solid #02317e;
  border-radius: 50%;
  overflow: hidden;
}
.photo img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 50%;
}

/* Header designation box */
.id-card h4 {
  text-align: center;
  margin: 10px auto;
  font-size: 15px;
  font-weight: bold;
  color: white;
  background: #1659c5;
  padding: 4px 10px;
  border-radius: 4px;
  width: fit-content;
  text-transform: uppercase;
  letter-spacing: 1px;
}

/* Info table */
.id-card table {
  width: 100%;
  padding: 0 10px 10px 10px;
  font-size: 12px;
}
.id-card table td {
  word-break: break-word;
  white-space: normal;
  line-height: 1.1;
  padding: 2px 3px;
}

/* Footer institute info */
.institute {
  font-size: 10px;
  text-align: center;
  margin-bottom: 8px;
  padding: 0 8px;
}

/* Print styles */
@media print {
  body {
    background: white !important;
  }
  .sheet {
    box-shadow: none !important;
    margin: 0;
    padding: 0;
    width: 100%;
    page-break-after: always;
  }
  .id-card {
    page-break-inside: avoid;
    background: url('<?= htmlspecialchars($employee_bg) ?>') no-repeat center center / cover !important;
  }
  button, .no-print {
    display: none !important;
  }
  @page {
    size: A4 portrait;
    margin: 0;
  }
  * {
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
  }
}
</style>
</head>
<body>

<div style="text-align:center; margin-bottom:20px;" class="no-print">
  <button onclick="window.print()" 
    style="padding:10px 20px; background:#4a04c3; color:white; border:none; border-radius:5px; cursor:pointer;">
    Print ID Cards
  </button>
</div>

<div class="sheet">
<?php while ($s = $q->fetch_assoc()) { ?>
  <div class="id-card">
    <div class="content-area">
      <div class="logo" style="text-align:center;">
        <img src="./<?= htmlspecialchars($settings['logo']) ?>" style="width:200px;">
      </div>
      <div class="photo">
        <img src="./<?= htmlspecialchars($s['profile_image']) ?>" alt="Photo">
      </div>
      <h4><?= htmlspecialchars($s['designation']) ?></h4>
      <table>
        <tr><td><b>Name:</b></td><td><?= htmlspecialchars($s['name']) ?></td></tr>
        <tr><td><b>Mob:</b></td><td><?= htmlspecialchars($s['phone']) ?></td></tr>
        <tr><td><b>Email:</b></td><td><?= htmlspecialchars($s['email']) ?></td></tr>
        <tr><td><b>DOB:</b></td><td><?= htmlspecialchars($s['dob']) ?></td></tr>
        <tr><td><b>BG:</b></td><td><?= htmlspecialchars($s['bgroup']) ?></td></tr>
      </table>
    </div>

    <div class="institute">
      <b><?= htmlspecialchars($settings['site_name']) ?></b><br>
      <?= nl2br(htmlspecialchars($settings['address'])) ?> - <?= htmlspecialchars($settings['phone']) ?>
    </div>
  </div>
<?php } ?>
</div>

</body>
</html>
