<?php
include("auth.php");
include("../config.php");

// ✅ CSRF Protection
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    die("Invalid CSRF token");
}

// ✅ Validate selected employees
if (empty($_POST['employees']) || !is_array($_POST['employees'])) {
    die("No employee selected.");
}

// ✅ Fetch selected employees securely
$ids = implode(",", array_map('intval', $_POST['employees']));
$q = $conn->query("SELECT * FROM users WHERE user_id IN ($ids)");

// ✅ Fetch settings for background, logo, etc.
$settingsQuery = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($settingsQuery);
$settings = $result->fetch_assoc();

$visiting_bg = htmlspecialchars($settings['visiting_card_bg']);
$logo = htmlspecialchars($settings['logo']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Employee Visiting Card Preview (A4 Layout)</title>

<style>
body {
    margin: 0;
    padding: 20px;
    background: #f3f3f3;
    font-family: Arial;
}

/* ✅ A4 container */
.sheet {
    width: 794px;
    min-height: 1123px;
    background: white;
    padding: 15px;
    margin: auto;
    box-shadow: 0 0 8px rgba(0,0,0,0.4);
    display: flex;
    flex-wrap: wrap;
    gap: 18px;
    page-break-after: always;
}

/* ✅ Visiting Card Base */
.visiting-card {
    width: 360px;
    height: 205px;
    background-image: url('../<?= $visiting_bg ?>');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
    border-radius: 10px;
    overflow: hidden;
    padding: 15px 18px;
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    color: #02244f;
    position: relative;
}

/* ✅ Layout */
.card-row {
    display: flex;
    flex-direction: row;
    justify-content: center;
    align-items: center;
    flex: 1;
    
}

/* ✅ LEFT SIDE CONTENT */
.left {
    width: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.left h2 {
    margin: 0;
    font-size: 20px;
    font-weight: bold;
}

.designation {
    margin-top: 2px;
    font-size: 14px;
    font-style: italic;
    color: #003b7a;
}

.contact {
    font-size: 13px;
    line-height: 1.3;
    margin-top: 6px;
}

/* ✅ Company Footer */
.company-footer {
    position: absolute;
    bottom: 10px;
    left: 0;
    width: 100%;
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    font-size: 12px;
    line-height: 1.25;
}

.company-footer .company-name {
    font-weight: bold;
    color: #002f6c;
    font-size: 10px;
}

.company-footer .company-contact {
    font-size: 10px;
    color: #02346b;
}

/* ✅ Logo */
.logo-top {
    width: 100%;
    text-align: center;
    margin-bottom: 5px;
}

.logo-top img {
    width: 150px;
}

/* ✅ Print Styles */
@media print {
    @page { size: A4 portrait; margin: 0; }
    body {
        margin: 0 !important;
        padding: 0 !important;
        background: white !important;
    }
    .sheet {
        box-shadow: none !important;
        padding: 10px !important;
        width: 794px !important;
        height: 1123px !important;
        gap: 18px !important;
    }
    .visiting-card {
        page-break-inside: avoid !important;
    }
    button, .no-print {
        display: none !important;
    }
}

/* ✅ Ensure background prints */
* {
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
}
</style>
</head>
<body>

<div class="no-print" style="text-align:center; margin-bottom:20px;">
    <button onclick="window.print()" 
        style="padding:10px 20px; background:#4a04c3; color:white; border:none; border-radius:5px; cursor:pointer;">
        Print Visiting Cards
    </button>
</div>

<div class="sheet">
<?php while ($s = $q->fetch_assoc()) { ?>
    <div class="visiting-card">
        <div class="logo-top">
                    <img src="./<?= htmlspecialchars($settings['logo']) ?>">
        </div>

        <div class="card-row  "> 
            <div class="left">
                <h2><?= htmlspecialchars($s['name']) ?></h2>
                <div class="designation"><?= htmlspecialchars($s['role']) ?></div>

                <div class="contact">
                    <b>Phone:</b> <?= htmlspecialchars($s['phone']) ?><br>
                    <b>Email:</b> <?= htmlspecialchars($s['email']) ?>
                </div>

                <div class="company-footer">
                    <div class="company-name"><?= htmlspecialchars($settings['site_name']) ?></div>
                    <div class="company-contact">
                        <?= htmlspecialchars($settings['address']) ?> — <?= htmlspecialchars($settings['phone']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script>
function downloadPDF() {
    const element = document.querySelector(".sheet");
    const opt = {
        margin: [0, 0, 0, 0],
        filename: 'employee-visiting-cards.pdf',
        image: { type: 'jpeg', quality: 1 },
        html2canvas: { scale: 2, useCORS: true, letterRendering: true, windowWidth: element.scrollWidth },
        jsPDF: { unit: 'px', format: [794, 1123], orientation: 'portrait' },
        pagebreak: { mode: ['css', 'legacy'], before: '.sheet' }
    };
    html2pdf().set(opt).from(element).save();
}
</script>

</body>
</html>
