<?php  
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$enquiry = []; // default empty array

// Fetch references and subjects
$references = [];
$subjects = [];

$referenceQuery = "SELECT id, reference_code, reference_title, status FROM enquiries_references WHERE status = 'Active'";
$subjectQuery = "SELECT id, subjects, status FROM enquiries_subjects WHERE status = 'Active'";

// Execute reference query
$referenceResult = $conn->query($referenceQuery);
if ($referenceResult) {
    while ($row = $referenceResult->fetch_assoc()) {
        $references[] = $row;
    }
}

// Execute subject query
$subjectResult = $conn->query($subjectQuery);
if ($subjectResult) {
    while ($row = $subjectResult->fetch_assoc()) {
        $subjects[] = $row;
    }
}

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM enquiries WHERE enquiry_id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $enquiry = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Enquiry not found.";
        exit;
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Enquiry <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Enquiry</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Enquiry</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="enquiries.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i>Enquiry List</a>
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Enquiry Details</h5>
              
<form class="row g-3" id="enquiryform">
  <div class="col-md-6">
    <label for="name" class="form-label">Name<span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="name" name="name"
      value="<?php echo isset($enquiry['name']) ? htmlspecialchars($enquiry['name']) : ''; ?>"
      placeholder="Enter name" required>
  </div>

  <div class="col-md-6">
    <label for="email" class="form-label">Email<span class="text-danger">*</span></label>
    <input type="email" class="form-control" id="email" name="email"
      value="<?php echo isset($enquiry['email']) ? htmlspecialchars($enquiry['email']) : ''; ?>"
      placeholder="Enter email" required>
  </div>

  <div class="col-md-4">
    <label for="phone" class="form-label">Phone<span class="text-danger">*</span></label>
    <input type="tel" class="form-control" id="phone" name="phone"
      value="<?php echo isset($enquiry['phone']) ? htmlspecialchars($enquiry['phone']) : ''; ?>"
      placeholder="Enter phone" required>
  </div>
  


  <div class="col-md-4">
    <label for="reference" class="form-label">Reference<span class="text-danger">*</span></label>
    <select class="form-select" id="reference" name="reference" required>
      <option value="">Select Reference</option>
      <?php foreach ($references as $reference): ?>
        <option value="<?php echo $reference['id']; ?>"
          <?php echo (isset($enquiry['reference']) && $enquiry['reference'] == $reference['id']) ? 'selected' : ''; ?>>
          <?php echo htmlspecialchars($reference['reference_title']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label for="subject" class="form-label">Subject<span class="text-danger">*</span></label>
    <select class="form-select" id="subject" name="subject" required>
      <option value="">Select Subject</option>
      <?php foreach ($subjects as $subject): ?>
        <option value="<?php echo $subject['id']; ?>"
          <?php echo (isset($enquiry['subject']) && $enquiry['subject'] == $subject['id']) ? 'selected' : ''; ?>>
          <?php echo htmlspecialchars($subject['subjects']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <!-- Dynamic Section -->
  <div class="col-md-12" id="dynamic-section" style="display:none;">
    <!-- Course Dropdown -->
    <div class="col-md-12" id="course-section" style="display:none;">
      <label for="course_id" class="form-label">Select Course</label>
      <select name="course_id" id="course_id" class="form-select">
        <option value="">Select Course</option>
        <?php
        $courseResult = $conn->query("SELECT id, name FROM course WHERE status='Active' AND deleted_at IS NULL");
        if ($courseResult) {
          while ($course = $courseResult->fetch_assoc()) {
            $selected = (isset($enquiry['course']) && $enquiry['course'] == $course['id']) ? 'selected' : '';
            echo '<option value="' . $course['id'] . '" ' . $selected . '>' . htmlspecialchars($course['name']) . '</option>';
          }
        }
        ?>
      </select>
    </div>

    <!-- Subject Description -->
    <div class="col-md-12 mt-2" id="general-section" style="display:none;">
      <label for="subject_description" class="form-label">Subject Description</label>
      <input type="text" name="subject_description" id="subject_description" class="form-control"
        value="<?php echo isset($enquiry['subject_description']) ? htmlspecialchars($enquiry['subject_description']) : ''; ?>"
        placeholder="Subject of general enquiry">
    </div>
  </div>

  <!-- Message -->
  <div class="col-md-12 mt-3">
    <label for="message" class="form-label">Message</label>
    <textarea class="form-control" id="message" name="message" rows="4"><?php echo isset($enquiry['message']) ? htmlspecialchars($enquiry['message']) : ''; ?></textarea>
  </div>



  <div id="msg"></div>

  <div class="col-md-12">
    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
    <?php if (isset($_GET['id'])) { ?>
      <input type="hidden" name="id" value="<?php echo $id; ?>">
      <input type="hidden" name="action" value="Edit">
      <button class="btn btn-success" type="submit">Update</button>
      <a href="enquiries.php" class="btn btn-secondary">Cancel</a>
    <?php } else { ?>
      <input type="hidden" name="action" value="Add">
      <input type="hidden" name="source" value="Offline">
      <button class="btn btn-success" type="submit">Submit</button>
      <button class="btn btn-secondary" type="reset">Reset</button>
    <?php } ?>
  </div>
</form>


            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script src="./scripts/enquiry.js"></script>


<script>
document.addEventListener("DOMContentLoaded", function() {
  const subjectSelect = document.getElementById("subject");
  const dynamicSection = document.getElementById("dynamic-section");
  const courseSection = document.getElementById("course-section");
  const generalSection = document.getElementById("general-section");

  function toggleSections() {
    const selected = subjectSelect.value.trim();

    courseSection.style.display = "none";
    generalSection.style.display = "none";
    dynamicSection.style.display = "none";

    if (selected === "1") { // ID 1 = Course Enquiry
      dynamicSection.style.display = "block";
      courseSection.style.display = "block";
    } else if (selected === "2") { // ID 2 = General Enquiry
      dynamicSection.style.display = "block";
      generalSection.style.display = "block";
    }
  }

  subjectSelect.addEventListener("change", toggleSections);
  toggleSections(); // for edit mode
});
</script>



</body>

</html>