<?php  
include("auth.php");
include("../config.php");

$enrolement = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM enrolments WHERE enrolment_id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $enrolement = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Enrolement not found.";
        exit;
    }

    $stmt->close();
}

$selected_mobile = '';
if (isset($_GET['mob'])) {
    $selected_mobile = base64_decode($_GET['mob']);
}

$selected_batch = '';
if (isset($_GET['batch'])) {
    $selected_batch = base64_decode($_GET['batch']);
}


// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Enrolment <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">
  <!-- Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Enrolment</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Enrolment</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="enrolements.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i>Enrolment List</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Enrolment Details</h5>
              
               <form class="row g-3" id="enrolementform">
                   

<div class="col-md-4">
  <label for="bid" class="form-label">Batch <span class="text-danger">*</span></label>
  <select class="form-control" id="bid" name="bid" required>
    <option value="">Select Batch</option>
    <?php
    $batches = $conn->query("SELECT id, cid, title FROM batch WHERE deleted_at IS NULL AND status='Active' order by title ASC");
    while ($b = $batches->fetch_assoc()) {
      $isSelected = false;

      // Priority 1: Editing an existing enrolment
      if (isset($enrolement['bid']) && $enrolement['bid'] == $b['id']) {
          $isSelected = true;
      }

      // Priority 2: Came from ?batch=
      elseif (!empty($selected_batch) && $selected_batch == $b['id']) {
          $isSelected = true;
      }

      $selected = $isSelected ? 'selected' : '';
      echo "<option value='{$b['id']}' data-cid='{$b['cid']}' $selected>{$b['title']}</option>";
    }
    ?>
  </select>
</div>


<!-- Student Dropdown -->
<div class="col-md-4">
  <label for="mobile" class="form-label">Student <span class="text-danger">*</span></label>
  <select class="form-control" id="mobile" name="mobile" required>
    <option value="">Select Student</option>
    <?php
    $students = $conn->query("SELECT id, name, mobile FROM student WHERE deleted_at IS NULL AND status='Active' order by name asc");
    while ($s = $students->fetch_assoc()) {
      $isSelected = false;

      // Priority 1: If editing an existing enrolment
      if (isset($enrolement['mobile']) && $enrolement['mobile'] == $s['mobile']) {
          $isSelected = true;
      }

      // Priority 2: If coming via ?mob=
      elseif (!empty($selected_mobile) && $selected_mobile == $s['mobile']) {
          $isSelected = true;
      }

      $selected = $isSelected ? 'selected' : '';
      echo "<option value='{$s['mobile']}' $selected>{$s['name']} ({$s['mobile']})</option>";
    }
    ?>
  </select>
</div>


  <!-- Enrollment Date -->
  <div class="col-md-4">
    <label for="enrolment_date" class="form-label">Enrolment Date <span class="text-danger">*</span></label>
    <input type="date" class="form-control" id="enrolment_date" name="enrolment_date"
      value="<?php echo isset($enrolement['enrolment_date']) ? htmlspecialchars($enrolement['enrolment_date']) : date('Y-m-d'); ?>"
      required>
  </div>




                <div id="msg"></div>
                <div class="col-md-12">
                    <!-- Hidden Course ID -->
                   <input type="hidden" id="cid" name="cid" value="<?php echo isset($enrolement['cid']) ? htmlspecialchars($enrolement['cid']) : ''; ?>">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                   <?php if(isset($_GET['id'])) {  ?>
                   <input type="hidden" class="form-control" id="id" name="id" value="<?php echo $id; ?>">
                   <input type="hidden" class="form-control" id="action" name="action" value="Edit">
                   <button class="btn btn-success" type="submit">Update</button>
                   <a href="enrolements.php" class="btn btn-secondary" type="button">Cancel</a>
                   
                   <?php } else { ?>
                   <input type="hidden" class="form-control" id="action" name="action" value="Add">
                   <button class="btn btn-success" type="submit">Submit</button>
                   <button class="btn btn-secondary" type="reset">Reset</button>
                   <?php } ?>
                </div>
              </form>

            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

<!-- jQuery (required for Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
  $('#mobile').select2({
    placeholder: "Search or select Student",
    allowClear: true,
    width: '100%'
  });
});
</script>



  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script src="./scripts/enrolement.js"></script>

</body>

</html>