<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['success' => false, 'message' => 'Invalid request method']);
  exit;
}

if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
  echo json_encode(['success' => false, 'message' => 'CSRF validation failed']);
  exit;
}

function clean($value) {
  return htmlspecialchars(trim($value), ENT_QUOTES, 'UTF-8');
}

$action = clean($_POST['action'] ?? '');
$id = intval($_POST['id'] ?? 0);
$head = clean($_POST['head'] ?? '');
$date = clean($_POST['date'] ?? '');
$amount = floatval($_POST['amount'] ?? 0);
$description = clean($_POST['description'] ?? '');
$old_attachment = clean($_POST['old_attachment'] ?? '');

// Folder setup
$uploadDir = "../uploads/expense/";
if (!is_dir($uploadDir)) {
  mkdir($uploadDir, 0777, true);
}

// Default path
$attachment = $old_attachment;

// File upload (similar to student photo/doc logic)
if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
  $fileTmp  = $_FILES['attachment']['tmp_name'];
  $fileName = basename($_FILES['attachment']['name']);
  $fileExt  = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
  $allowed  = ['jpg', 'jpeg', 'png', 'gif', 'pdf'];

  if (in_array($fileExt, $allowed)) {
    $newName = time() . '_' . uniqid() . '.' . $fileExt;
    $target  = $uploadDir . $newName;

    if (move_uploaded_file($fileTmp, $target)) {
      $attachment = 'uploads/expense/' . $newName;


      // Delete old file on edit
      if ($action == 'Edit' && !empty($old_attachment) && file_exists('../' . $old_attachment)) {
        unlink('../' . $old_attachment);
      }
    } else {
      echo json_encode(['success' => false, 'message' => 'File upload failed']);
      exit;
    }
  } else {
    echo json_encode(['success' => false, 'message' => 'Invalid file type (only image/pdf allowed)']);
    exit;
  }
}

// INSERT / UPDATE query
if ($action == 'Add') {
  $stmt = $conn->prepare("INSERT INTO expenses (head, date, amount, description, attachment) VALUES (?, ?, ?, ?, ?)");
  $stmt->bind_param("ssdss", $head, $date, $amount, $description, $attachment);
  $stmt->execute();
  $stmt->close();
  echo json_encode(['success' => true, 'message' => 'Expense added successfully.']);
  exit;
}

if ($action == 'Edit' && $id > 0) {
  $stmt = $conn->prepare("UPDATE expenses SET head=?, date=?, amount=?, description=?, attachment=? WHERE id=?");
  $stmt->bind_param("ssdssi", $head, $date, $amount, $description, $attachment, $id);
  $stmt->execute();
  $stmt->close();
  echo json_encode(['success' => true, 'message' => 'Expense updated successfully.']);
  exit;
}

echo json_encode(['success' => false, 'message' => 'Invalid action']);
