<?php  
include("auth.php");
include("../config.php");

$expense = []; // default empty array

if (isset($_GET['id'])) {
    $id = base64_decode($_GET['id']);

    // Prepare the statement
    $stmt = $conn->prepare("SELECT * FROM expenses WHERE id = ?");
    $stmt->bind_param("i", $id); // "i" = integer

    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        $expense = $result->fetch_assoc();
    } else {
        // Optionally redirect or show an error if content not found
        echo "Expense not found.";
        exit;
    }

    $stmt->close();
}

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Expense <?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
  
  <style>
.spin {
  animation: spin 1s linear infinite;
}
@keyframes spin {
  from { transform: rotate(0deg); }
  to { transform: rotate(360deg); }
}
</style>


</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><?php if(isset($_GET['id'])) echo 'Edit'; else echo "Add";   ?> Expense</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Expense</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
          <a href="expenses.php" class="btn btn-primary btn-sm"><i class="bi bi-arrow-left"></i>Expense List</a>
          
          <div class="card mt-2">
            <div class="card-body">
              <h5 class="card-title">Expense Details</h5>
              
               <form class="row g-3" id="expenseform" enctype="multipart/form-data">
    <!-- Head -->
    <div class="col-md-4">
        <label for="head" class="form-label">Expense Head <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="head" name="head" 
               placeholder="e.g., Office Supplies, Travel" 
               value="<?php echo isset($expense['head']) ? htmlspecialchars($expense['head']) : ''; ?>" required>
    </div>

    <!-- Date -->
    <div class="col-md-4">
        <label for="date" class="form-label">Date <span class="text-danger">*</span></label>
        <input type="date" class="form-control" id="date" name="date"
               value="<?php echo isset($expense['date']) ? htmlspecialchars($expense['date']) : ''; ?>" required>
    </div>

    <!-- Amount -->
    <div class="col-md-4">
        <label for="amount" class="form-label">Amount (₹) <span class="text-danger">*</span></label>
        <input type="number" class="form-control" id="amount" name="amount"
               placeholder="Enter amount" step="0.01"
               value="<?php echo isset($expense['amount']) ? htmlspecialchars($expense['amount']) : ''; ?>" required>
    </div>

    <!-- Description -->
    <div class="col-md-12">
        <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
        <textarea class="form-control" id="description" name="description" rows="3"
                  placeholder="Enter detailed description..." required><?php echo isset($expense['description']) ? htmlspecialchars($expense['description']) : ''; ?></textarea>
    </div>

<!-- Expense Attachment Upload -->
<div class="col-md-6">
  <label for="attachment" class="form-label">Upload Bill / Receipt (Image or PDF)</label>
  <input type="file" class="form-control" id="attachment" name="attachment" accept=".pdf,image/*">

  <!-- Loader -->
  <div id="uploadLoader" style="display:none;">
    <small class="text-info"><i class="bi bi-arrow-repeat spin"></i> Uploading...</small>
  </div>

  <!-- Existing file preview -->
  <?php if (!empty($expense['attachment'])) { 
    $filePath = htmlspecialchars($expense['attachment']);
    $isImage = preg_match('/\.(jpg|jpeg|png|gif)$/i', $filePath);
  ?>
    <div class="mt-2" id="filePreview">
      <?php if ($isImage) { ?>
        <img src="../<?php echo $filePath; ?>" class="img-thumbnail" style="max-width: 120px;">
      <?php } else { ?>
        <a href="../<?php echo $filePath; ?>" target="_blank" class="btn btn-sm btn-outline-primary">
          View Uploaded File
        </a>
      <?php } ?>
      <input type="hidden" name="old_attachment" value="<?php echo $filePath; ?>">
    </div>
  <?php } else { ?>
    <div id="filePreview"></div>
  <?php } ?>
</div>


    <div id="msg"></div>

    <!-- Hidden CSRF + Action Buttons -->
    <div class="col-md-12">
        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

        <?php if(isset($_GET['id'])) { ?>
            <input type="hidden" id="id" name="id" value="<?php echo $id; ?>">
            <input type="hidden" id="action" name="action" value="Edit">
            <button class="btn btn-success" type="submit">Update</button>
            <a href="expenses.php" class="btn btn-secondary" type="button">Cancel</a>
        <?php } else { ?>
            <input type="hidden" id="action" name="action" value="Add">
            <button class="btn btn-success" type="submit">Submit</button>
            <button class="btn btn-secondary" type="reset">Reset</button>
        <?php } ?>
    </div>
</form>



            </div>
          </div>
        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
  <script src="./scripts/expense.js"></script>



</body>

</html>