<?php
header('Content-Type: application/json');
include('../config.php');
session_start();

// Ensure that the request method is POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    exit(json_encode(["status" => "error", "message" => "CSRF validation failed"]));
}

$response = ['success' => false, 'message' => 'Unknown error'];

// Get POST parameters
$action = $_POST['action'] ?? '';
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$question = $_POST['question'] ?? '';
$answer = $_POST['answer'] ?? '';

// Validate that required fields are not empty
if ($action!='delete' && (empty($question) || empty($answer) ) ) {
    $response['message'] = 'FAQ question and answer cannot be empty.';
    echo json_encode($response);
    exit;
}

// Handle the delete action via POST (AJAX)
if ($action === 'delete' && $id > 0) {
    try {
        // Prepare and execute the soft delete query
        $stmt = $conn->prepare("UPDATE faq SET deleted_at = NOW() WHERE faq_id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'FAQ deleted successfully.'];
        } else {
            $response['message'] = 'Failed to delete FAQ.';
        }

        $stmt->close();
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }

    // Return JSON response after the delete action
    echo json_encode($response);
    $conn->close();
    exit;
}

// For Add and Edit actions
try {
    if ($action === 'Add') {
        // Insert new content
        $stmt = $conn->prepare("INSERT INTO faq (question, answer) VALUES (?, ?)");
        $stmt->bind_param("ss", $question, $answer);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'FAQ added successfully', 'redirect' => 'faqs.php'];
        } else {
            $response['message'] = 'Failed to add FAQ';
        }

        $stmt->close();

    } elseif ($action === 'Edit' && $id > 0) {
        // Edit existing content
        $stmt = $conn->prepare("UPDATE faq SET question=?, answer=?, updated_at=NOW() WHERE faq_id=?");
        $stmt->bind_param("ssi", $question, $answer, $id);

        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => 'FAQ updated successfully', 'redirect' => 'faqs.php'];
        } else {
            $response['message'] = 'Failed to update FAQ';
        }

        $stmt->close();

    } else {
        $response['message'] = 'Invalid action or missing FAQ ID';
    }

} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

// Return JSON response
echo json_encode($response);
$conn->close();
exit;
?>


