<?php
include("auth.php");
include("../config.php");

// CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Fee Reports - <?php echo $settings['site_name']; ?></title>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <!--<link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">-->
  <link href="assets/css/style.css" rel="stylesheet">
  
  <!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- DataTables Bootstrap 5 -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

<style>
.dataTables_length {
    margin-right: 15px !important;
}

.dt-buttons .btn {
    margin-right: 5px;
}

</style>
<style>
@media (max-width: 768px) {
    /* Container becomes flex */
    .dataTables_wrapper .dt-buttons,
    .dataTables_wrapper .dataTables_length {
        float: none;
        display: inline-flex;
        align-items: center;
        margin-bottom: 8px;
    }

    /* Put length + buttons on same row */
    .dataTables_wrapper .dataTables_length {
        margin-right: 10px;
    }

    /* Allow wrapping if needed without stacking vertically */
    .dataTables_wrapper .dt-buttons {
        flex-wrap: nowrap;
    }

    /* Search goes below */
    .dataTables_wrapper .dataTables_filter {
        float: none;
        margin-top: 10px;
        width: 100%;
        text-align: left;
    }
}
.dataTables_wrapper .dt-buttons {
    float: left;
    margin-right: 10px;
}

.dataTables_length {
    float: left !important;
}

.dataTables_filter {
    float: right !important;
}

</style>

  
  <style>.btn {
  padding: 0.375rem 0.75rem; /* py-1.5 px-3 roughly */
}
</style>
</head>

<body>
<?php include("templates/header.php"); ?>
<?php include("templates/sidebar.php"); ?>

<main id="main" class="main">
  <div class="pagetitle">
    <h1>Fee Reports</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
        <li class="breadcrumb-item active">Fee Reports</li>
      </ol>
    </nav>
  </div>

  <section class="section">
    <div class="row">

      <!-- Filter Card -->
      <div class="col-lg-12 mb-3">
        <div class="card">
          <div class="card-body">
            <h5 class="card-title mb-3">Filter Fees</h5>

            <form method="GET" class="row g-3">

              <!-- Batch Dropdown -->
              <div class="col-md-5">
                <label class="form-label">Select Batch</label>
                <select name="batch_id" class="form-select">
                  <option value="all">All Batches</option>
                  <?php
                  $batch_query = mysqli_query($conn, "SELECT id, title FROM batch WHERE deleted_at IS NULL AND status='Active'");
                  while ($b = mysqli_fetch_assoc($batch_query)) {
                    $selected = ($_GET['batch_id'] ?? '') == $b['id'] ? 'selected' : '';
                    echo "<option value='{$b['id']}' {$selected}>{$b['title']}</option>";
                  }
                  ?>
                </select>
              </div>

              <!-- Date Filter -->
              <div class="col-md-5">
                <label class="form-label">Next Payment Filter</label>
                <select name="date_filter" class="form-select">
                  <option value="">All</option>
                  <option value="today" <?php if(($_GET['date_filter'] ?? '') == 'today') echo 'selected'; ?>>Today</option>
                  <option value="week" <?php if(($_GET['date_filter'] ?? '') == 'week') echo 'selected'; ?>>This Week</option>
                  <option value="month" <?php if(($_GET['date_filter'] ?? '') == 'month') echo 'selected'; ?>>This Month</option>
                </select>
              </div>

              <div class="col-md-2 d-flex align-items-center justify-content-end">
                  <button type="submit" class="btn btn-primary me-3  mt-4 px-4 ">
                    <i class="bi bi-search"></i> Search
                  </button>
                </div>

            </form>

          </div>
        </div>
      </div>
      <!-- End Filter Card -->

      <!-- Data Table -->
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <h5 class="card-title">Fee Report List</h5>
            
           
    <button id="bulkReminderBtn" class="btn btn-danger mb-4">
        <i class="bi bi-envelope-open"></i> Send Bulk Reminder
    </button>


            <div class="table-responsive">
              <table class="table datatable">
                <thead>
                  <tr>
                    <th>#</th>
                    <th><input type="checkbox" id="select_all"></th>
                    <th>Reminder</th>
                    <th>Next Payment Date</th>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Total Fees</th>
                    <th>Paid</th>
                    <th>Balance</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $batch_id = $_GET['batch_id'] ?? 'all';
$date_filter = $_GET['date_filter'] ?? '';

$conditions = ["1"];

// Batch filter
if ($batch_id !== 'all') {
    $conditions[] = "fr.bid = '" . mysqli_real_escape_string($conn, $batch_id) . "'";
}

// Fee must be pending or partial
$conditions[] = "e.fee_status IN ('Pending', 'Partial')";

// Next Payment Date Filter
$today = date('Y-m-d');
if ($date_filter == 'today') {
    $conditions[] = "DATE(fr.next_payment_date) = '$today'";
} elseif ($date_filter == 'week') {
    $conditions[] = "YEARWEEK(fr.next_payment_date, 1) = YEARWEEK(CURDATE(), 1)";
} elseif ($date_filter == 'month') {
    $conditions[] = "MONTH(fr.next_payment_date) = MONTH(CURDATE()) AND YEAR(fr.next_payment_date) = YEAR(CURDATE())";
}

$where = implode(' AND ', $conditions);

$sql = "
SELECT
    s.name AS student_name,
    fr.mobile,
    e.enrolment_id,
    c.name AS course_name,
    SUM(fr.payment_amount) AS paid_amount,
    MAX(fr.next_payment_date) AS next_payment_date,
    (c.fees - c.discount) AS total_fees
FROM fees_receipts fr
LEFT JOIN student s ON fr.mobile = s.mobile
LEFT JOIN course c ON fr.cid = c.id
INNER JOIN enrolments e ON fr.enrolment_id = e.enrolment_id
WHERE $where
GROUP BY fr.mobile, c.id
ORDER BY s.name ASC
";


                  $result = mysqli_query($conn, $sql);
                  $sl = 1;
                  $sum_total = 0;
                  $sum_paid = 0;
                  $sum_balance = 0;

                  if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
  $total = floatval($row['total_fees']);
  $paid = floatval($row['paid_amount']);
  $balance = $total - $paid;

  $sum_total += $total;
  $sum_paid += $paid;
  $sum_balance += $balance;

$next_date = $row['next_payment_date'];
$today = date('Y-m-d');
$row_class = "";

// Highlight overdue next payment date
if ($next_date && $next_date != "0000-00-00" && $next_date <= $today) {
    $row_class = "style='background-color:#f8d7da;'"; // light red
}

          echo "
          <tr $row_class>
          <td $row_class>{$sl}</td>
          <td $row_class><input type='checkbox' class='row_check' data-mobile='{$row['mobile']}' data-enrolment='{$row['enrolment_id']}'></td>
          <td $row_class>
            <button class='btn btn-sm btn-warning sendReminder' data-mobile='{$row['mobile']}' data-enrolment='{$row['enrolment_id']}'>
                <i class='bi bi-envelope'></i> Send
            </button>
          </td>
          <td $row_class>" . ($row['next_payment_date'] && $row['next_payment_date'] != '0000-00-00'
                ? htmlspecialchars($row['next_payment_date'])
                : '-') . "</td>
          <td $row_class>" . htmlspecialchars($row['student_name'] ?? 'N/A') . "</td>
          <td $row_class>" . htmlspecialchars($row['mobile']) . "</td>
          <td $row_class>" . number_format($total, 2) . "</td>
          <td $row_class>" . number_format($paid, 2) . "</td>
          <td $row_class>" . number_format($balance, 2) . "</td>
          
          
        </tr>";
  $sl++;
}

                  } else {
                   echo "
<tr>
  <td class='text-center'>-</td>
  <td></td>
  <td></td>
  <td></td>
  <td>No records found</td>
  <td></td>
  <td></td>
  <td></td>
  <td></td>
</tr>";

                  }
                  ?>
                </tbody>
                  <tfoot>
    <tr>
      <td colspan="6" class="text-end">Total</td>
      <td><?php echo number_format($sum_total, 2); ?></td>
      <td><?php echo number_format($sum_paid, 2); ?></td>
      <td><?php echo number_format($sum_balance, 2); ?></td>
    </tr>
  </tfoot>
              </table>
            </div>

          </div>
        </div>
      </div>
      <!-- End Data Table -->

    </div>
  </section>
</main>

<?php include("templates/footer.php"); ?>

<a href="#" class="back-to-top d-flex align-items-center justify-content-center">
  <i class="bi bi-arrow-up-short"></i>
</a>

<!--<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>-->
<!--<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>-->

<script>
$(document).ready(function() {
    $('.datatable').DataTable({
        dom: 'lBfrtip', // show buttons
         buttons: [
        {
            extend: 'csvHtml5',
            text: '<i class="bi bi-file-earmark-spreadsheet"></i>',
            className: 'btn btn-light btn-sm border'

        },
        {
            extend: 'pdfHtml5',
            orientation: 'landscape',
            pageSize: 'A4',
            text: '<i class="bi bi-file-earmark-pdf"></i>',
            className: 'btn btn-light btn-sm border'

        },
        {
            extend: 'print',
            text: '<i class="bi bi-printer"></i>',
            className: 'btn btn-light btn-sm border'

        }
    ],
        language: {
            emptyTable: "",  
            zeroRecords: ""
        },
         initComplete: function () {
        // Remove label text ("Search:")
        $('.dataTables_filter label').contents().filter(function() {
            return this.nodeType === 3;
        }).remove();

        // Add placeholder for search
        $('.dataTables_filter input').attr('placeholder', 'Search here...');

        // Remove text from "Show X entries" label
        $('.dataTables_length label').contents().filter(function() {
            return this.nodeType === 3;
        }).remove();
    }
    });
});
</script>

<script>
/*
  Requires: jQuery loaded before this block.
  - Uses delegated handlers to survive DOM changes by datatables.
  - Expects send-fee-reminder.php to return JSON { status: "success" } or { status: "error", message: "..." }
*/

$(function () {

  // Select All (delegated)
  $(document).on('change', '#select_all', function() {
    let checked = $(this).prop('checked');
    // target only visible row_check inputs inside the current table (avoid hidden clones)
    $('.table tbody .row_check').prop('checked', checked);
  });

  // If any row unchecked => uncheck the header checkbox
  $(document).on('change', '.row_check', function () {
    if (!$(this).prop("checked")) {
      $('#select_all').prop('checked', false);
    } else {
      // if all visible are checked, set header to checked
      let all = $('.table tbody .row_check').length;
      let checked = $('.table tbody .row_check:checked').length;
      if (all > 0 && all === checked) $('#select_all').prop('checked', true);
    }
  });

  // Individual Reminder (delegated)
  $(document).on('click', '.sendReminder', function (e) {
    e.preventDefault();
    let $btn = $(this);
    let mobile = $btn.data('mobile');
    let enrol = $btn.data('enrolment');


    // disable button to prevent double-click
    $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Sending');

    $.ajax({
      url: 'send-fee-reminder.php',
      method: 'POST',
      data: {mobile: mobile,enrolment_id: enrol},
      dataType: 'json',
      success: function(res) {
        if (res && res.status === 'success') {
          alert('Reminder sent to ' + mobile);
        } else {
          alert('Failed to send reminder: ' + (res.message || 'Unknown error'));
        }
      },
      error: function() {
        alert('Network error. Try again.');
      },
      complete: function() {
        $btn.prop('disabled', false).html('<i class="bi bi-envelope"></i> Send');
      }
    });
  });

  // Bulk Reminder
  $('#bulkReminderBtn').on('click', function (e) {
    e.preventDefault();
    let selected = [];
    // only pick visible/checked rows
    $('.table tbody .row_check:checked').each(function () {
      selected.push({
        mobile: $(this).data('mobile'),
        enrolment_id: $(this).data('enrolment')
      });

    });

    if (selected.length === 0) {
      alert('Please select at least one student.');
      return;
    }

    let $btn = $(this);
    $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Sending...');

    $.ajax({
      url: 'send-fee-reminder.php',
      method: 'POST',
      data: { items: selected }, // PHP will receive $_POST['mobiles'] as array
      dataType: 'json',
      success: function(res) {
        if (res && res.status === 'success') {
          alert('Bulk reminder sent to ' + selected.length + ' students.');
          // optionally uncheck all
          $('#select_all').prop('checked', false);
          $('.table tbody .row_check').prop('checked', false);
        } else {
          alert('Bulk send failed: ' + (res.message || 'Unknown error'));
        }
      },
      error: function() {
        alert('Network error. Try again.');
      },
      complete: function() {
        $btn.prop('disabled', false).html('<i class="bi bi-envelope-open"></i> Send Bulk Reminder');
      }
    });
  });

});
</script>

<script src="assets/js/main.js"></script>


</body>
</html>
