<?php
include("auth.php");
include("../config.php");

// Decode ID from link
$id = isset($_GET['id']) ? base64_decode($_GET['id']) : 0;
if (!$id) {
  die("<div class='alert alert-danger m-3'>Invalid Receipt ID</div>");
}

// Fetch the receipt with all related data
$query = "
  SELECT 
    f.id AS receipt_id,
    f.enrolment_id,
    f.cid,
    f.bid,
    f.mobile,
    f.payment_date,
    f.next_payment_date,
    f.payment_mode,
    f.payment_source,
    f.reference,
    f.payment_amount,
    f.payment_status,
    s.name AS student_name,
    s.registration_no,
    s.email,
    s.dob,
    s.photo,
    c.name AS course_name,
    c.fees AS course_fees,
    c.discount,
    b.title AS batch_title
  FROM fees_receipts f
  LEFT JOIN student s ON s.mobile = f.mobile
  LEFT JOIN enrolments e ON e.enrolment_id = f.enrolment_id
  LEFT JOIN course c ON c.id = f.cid
  LEFT JOIN batch b ON b.id = f.bid
  WHERE f.id = ?
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$receipt = $result->fetch_assoc();
$stmt->close();

if (!$receipt) {
  die("<div class='alert alert-danger m-3'>Receipt not found.</div>");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Fee Receipt Print - <?php echo $settings['site_name']; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.snow.css" rel="stylesheet">
  <link href="assets/vendor/quill/quill.bubble.css" rel="stylesheet">
  <link href="assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="assets/vendor/simple-datatables/style.css" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="assets/css/style.css" rel="stylesheet">
<style>
    body {
      background-color: #f8f9fa;
      font-family: 'Poppins', sans-serif;
    }
    .receipt-container {
      background: #fff;
      border-radius: 10px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      margin: 30px auto;
      padding: 35px;
      max-width: 800px;
    }

.receipt-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    border-bottom: 3px solid #0d6efd;
    padding: 10px 0 2px 0; /* extra bottom padding */
    margin-bottom: 25px;
    flex-wrap: wrap;
    gap: 10px;
}

.receipt-header-left {
    flex: 1;
    min-width: 250px;
}

.receipt-header-left h2 {
    font-weight: 700;
    color: #0d6efd;
    margin-bottom: 6px;
    font-size: 24px;
    word-break: break-word;
}

.receipt-header-left small {
    display: block;
    color: #555;
    line-height: 1.4;
    word-break: break-word;
}

.receipt-header-right img {
    height: 70px;
    width: auto;
    max-width: 140px;
    object-fit: contain;
}

@media (max-width: 576px) {
    .receipt-header {
        flex-direction: column;
        align-items: center;
        text-align: center;
    }
    .receipt-header-right img {
        margin-top: 10px;
        height: 60px;
    }
}


    .receipt-title {
      text-align: center;
      margin-bottom: 20px;
      font-size: 22px;
      font-weight: 600;
      color: #212529;
      text-decoration: underline;
    }
    .table td, .table th {
      vertical-align: middle;
    }
    .student-photo {
      width: 90px;
      height: 90px;
      border-radius: 8px;
      object-fit: cover;
    }
    .footer {
      text-align: center;
      font-size: 13px;
      color: #6c757d;
      margin-top: 30px;
      border-top: 1px dashed #ccc;
      padding-top: 10px;
    }
@media print {
  body * {
    visibility: hidden; /* hide everything by default */
  }
  #receipt-container, #receipt-container * {
    visibility: visible; /* show only the receipt */
  }
  #receipt-container {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    padding: 0;
    margin: 0;
  }
  .print-btn { display: none; }
}
@media print {
  #receipt-container {
    width: 100%;
  }
  .row.no-wrap {
    flex-wrap: nowrap !important;
  }
  .row.no-wrap > [class*="col-"] {
    float: left;
    width: 50% !important;
  }
}

  </style>
</head>

<body>

  <?php include("templates/header.php"); ?>
 

  <?php include("templates/sidebar.php"); ?>
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Fee Receipt</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Fee Receipt</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">
           
<div id="receipt-container" class="receipt-container ">

<div class="receipt-header">
    <div class="receipt-header-left">
        <h2><?php echo $settings['site_name']; ?></h2>
        <small><?php echo $settings['address']; ?></small>
        <small>Email: <?php echo $settings['email']; ?> | Phone: <?php echo $settings['phone']; ?></small>
    </div>
    <div class="receipt-header-right">
        <img src="./<?php echo $settings['logo']; ?>" alt="Logo">
    </div>
</div>


    <div class="receipt-title">FEE RECEIPT</div>

    <!-- Top Info -->
    <div class="row mb-3 no-wrap">
      <div class="col-md-6">
        <strong>Receipt No:</strong> <?php echo sprintf("FR%05d", $receipt['receipt_id']); ?><br>
        <strong>Payment Date:</strong> <?php echo date("d M Y", strtotime($receipt['payment_date'])); ?><br>
        <strong>Next Payment:</strong> 
<?php 
if (empty($receipt['next_payment_date']) || $receipt['next_payment_date'] === '0000-00-00') {
    echo 'NA';
} else {
    echo date("d M Y", strtotime($receipt['next_payment_date']));
}
?><br>

      </div>
      <div class="col-md-6 text-end">
        <strong>Registration No:</strong> <?php echo htmlspecialchars($receipt['registration_no']); ?><br>
        <strong>Payment Mode:</strong> <?php echo htmlspecialchars($receipt['payment_mode']); ?><br>
        <strong>Status:</strong> 
        <?php
        $statusColor = ($receipt['payment_status'] === 'Paid') ? 'success' :
                       (($receipt['payment_status'] === 'Pending') ? 'danger' : 'warning');
        ?>
        <span class="badge bg-<?php echo $statusColor; ?>">
          <?php echo htmlspecialchars($receipt['payment_status']); ?>
        </span>
      </div>
    </div>

    <!-- Student Info -->
    <h5>Student Details</h5>
    <table class="table table-bordered">
      <tr>
        <td rowspan="4" style="width:120px;">
          <?php if (!empty($receipt['photo'])): ?>
            <img src="<?php echo htmlspecialchars($receipt['photo']); ?>" class="student-photo" alt="Student Photo">
          <?php else: ?>
            <img src="assets/img/default-avatar.png" class="student-photo" alt="Student">
          <?php endif; ?>
        </td>
        <td><strong>Name:</strong> <?php echo htmlspecialchars($receipt['student_name']); ?></td>
      </tr>
      <tr><td><strong>Email:</strong> <?php echo htmlspecialchars($receipt['email']); ?></td></tr>
      <tr><td><strong>Mobile:</strong> <?php echo htmlspecialchars($receipt['mobile']); ?></td></tr>
      <tr><td><strong>DOB:</strong> <?php echo date("d M Y", strtotime($receipt['dob'])); ?></td></tr>
    </table>

    <!-- Course & Batch -->
    <h5>Course Details</h5>
    <table class="table table-bordered">
      <tr>
        <th>Course Name</th>
        <td><?php echo htmlspecialchars($receipt['course_name']); ?></td>
        <th>Batch</th>
        <td><?php echo htmlspecialchars($receipt['batch_title']); ?></td>
      </tr>
      <tr>
        <th>Course Fees</th>
        <td colspan="3">₹ <?php echo number_format($receipt['course_fees']-$receipt['discount'], 2); ?></td>
      </tr>
    </table>

    <!-- Payment Info -->
    <h5>Payment Details</h5>
    <table class="table table-bordered">
      <tr>
        <!--<th>Payment Mode</th>-->
        <!--<td><?php echo htmlspecialchars($receipt['payment_mode']); ?></td>-->
        <th>Ref / Trn ID</th>
        <td><?php echo htmlspecialchars($receipt['reference']); ?></td>
      </tr>
      <tr>
        <th>Amount Paid</th>
        <td colspan="3"><strong>₹ <?php echo number_format($receipt['payment_amount'], 2); ?></strong></td>
      </tr>
      <!--<tr>-->
      <!--  <th>Payment Source</th>-->
      <!--  <td colspan="3"><?php echo htmlspecialchars($receipt['payment_source']); ?></td>-->
      <!--</tr>-->
    </table>

    <div class="footer">
      This is a computer-generated receipt. No signature required.<br>
      <strong>Thank you for your payment!</strong>
    </div>

  </div>
<div class="text-center mt-4">
  <button class="btn btn-primary" onclick="window.print()">
    <i class="bi bi-printer"></i> Print / Save as PDF
  </button>
</div>


        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/quill/quill.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/vendor/tinymce/tinymce.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>

  <!-- Template Main JS File -->
  <script src="assets/js/main.js"></script>
<script>
function printReceipt() {
    // Get the receipt container HTML
    var receiptContent = document.getElementById('receipt-container').innerHTML;

    // Open a new window for printing
    var printWindow = window.open('', '', 'height=600,width=800');

    // Write the content and styles
    printWindow.document.write('<html><head><title>Fee Receipt</title>');
    // Optionally include Bootstrap CSS if needed for styling
    printWindow.document.write('<link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">');
    printWindow.document.write('<style>body{padding:20px;} .receipt-header{border-bottom:2px solid #000;padding-bottom:10px;}</style>');
    printWindow.document.write('</head><body>');
    printWindow.document.write(receiptContent);
    printWindow.document.write('</body></html>');

    // Print the window
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();
}
</script>
</body>

</html>