<?php
include("../config.php");

$batch = $_POST['load_students'] ?? '';

if ($batch == "") {
    echo "<tr><td colspan='8' class='text-center text-danger'>Select batch to load students.</td></tr>";
    exit;
}

$q = $conn->query("
    SELECT 
        s.*, 
        e.fee_status,
        e.cid,
        e.bid
    FROM student s
    INNER JOIN enrolments e ON e.mobile = s.mobile
    WHERE e.bid = '$batch' 
      AND s.deleted_at IS NULL
    ORDER BY s.id DESC
");

if ($q->num_rows == 0) {
    echo "<tr><td colspan='8' class='text-center text-danger'>No students found for this batch.</td></tr>";
    exit;
}

while ($row = $q->fetch_assoc()) {

    $mobile = $row['mobile'];
    $cid = $row['cid'];
    $bid = $row['bid'];

    // -------------------------------------------
    // CHECK IF CERTIFICATE ALREADY ISSUED
    // -------------------------------------------
    $cert_sql = $conn->query("
        SELECT certificate_no
        FROM issue_certificate
        WHERE mobile = '$mobile'
          AND bid = '$bid'
          AND cid = '$cid'
          AND deleted_at IS NULL
        LIMIT 1
    ");

    $certificate_issued = ($cert_sql->num_rows > 0);
    $certificate_no = "";

    if ($certificate_issued) {
        $cert_row = $cert_sql->fetch_assoc();
        $certificate_no = $cert_row['certificate_no'];
    }
?>
<tr>
    <td>
    <input 
        type="checkbox" 
        name="students[]" 
        value="<?= $row['id'] ?>"
        <?= $certificate_issued ? '' : 'disabled' ?>
        title="<?= $certificate_issued ? 'Select for certificate generation' : 'Certificate not issued yet' ?>"
    >
   </td>


    <!-- ACTION COLUMN -->
    <td>
            
        <?php if ($certificate_issued): ?>
            <span class="badge bg-info">Issued</span><br>
            <small>Cert No: <strong><?= htmlspecialchars($certificate_no) ?></strong></small>
        <?php else: ?>
            <button type="button" class="btn btn-primary btn-sm issueCertBtn" 
                data-name="<?= htmlspecialchars($row['name']) ?>"
                data-mobile="<?= htmlspecialchars($row['mobile']) ?>"
                data-cid="<?= htmlspecialchars($cid) ?>"
                data-bid="<?= htmlspecialchars($bid) ?>">
                Issue Certificate
            </button>
            <input 
    type="checkbox" 
    name="issue_list[]" 
    value="<?= $row['mobile'] . '|' . $cid . '|' . $bid ?>"
    <?= $certificate_issued ? 'disabled' : '' ?>>
        <?php endif; ?>
        

    </td>
    
  <?php
// GET HANDOVER STATUS
$handover_sql = $conn->query("
    SELECT id,handover, handover_date 
    FROM issue_certificate
    WHERE mobile = '$mobile'
      AND bid = '$bid'
      AND cid = '$cid'
      AND deleted_at IS NULL
    LIMIT 1
");

$handoverwith = 0;
$handover_date = null;

if ($handover_sql->num_rows > 0) {
    $ho = $handover_sql->fetch_assoc();
    $handoverwith = $ho['handover'];
    $handover_date = $ho['handover_date'];
}
?>

<!-- NEW COLUMN: HANDOVER STATUS -->
<td>
    <?php if ($certificate_issued): ?>

        <?php if ($handoverwith == 1): ?>
            <span class="badge bg-success">Handover Completed</span><br>
            <small><?= date("d-M-Y", strtotime($handover_date)) ?></small>
        <?php else: ?>
            <button 
                type="button" 
                class="btn btn-secondary btn-sm handoverBtn"
                data-mobile="<?= $mobile ?>"
                data-bid="<?= $bid ?>"
                data-cid="<?= $cid ?>"
            >
                Handover
            </button>
        <?php endif; ?>

    <?php else: ?>
        <span class="badge bg-secondary">Issue Certificate First</span>
    <?php endif; ?>
</td>
  
    
    

    <td><img src="./<?= htmlspecialchars($row['photo']) ?>" width="60" height="60" class="rounded"></td>

    <td><?= htmlspecialchars($row['registration_no']) ?></td>

    <td><?= htmlspecialchars($row['name']) ?></td>

    <td><?= htmlspecialchars($row['mobile']) ?></td>

    <td><?= htmlspecialchars($row['email']) ?></td>

    <td>
        <?php 
            $status = htmlspecialchars($row['fee_status']);
            if ($status == 'Paid') {
                echo "<span class='badge bg-success'>Paid</span>";
            } elseif ($status == 'Pending') {
                echo "<span class='badge bg-danger'>Unpaid</span>";
            } elseif ($status == 'Partial') {
                echo "<span class='badge bg-warning'>Partially Paid</span>";
            } else {
                echo "<span class='badge bg-secondary'>Unknown</span>";
            }
        ?>
    </td>

</tr>
<?php
}
?>

