<?php
include("auth.php");
include("../config.php");

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Get date filters safely
$from_date = mysqli_real_escape_string($conn, $_GET['from_date'] ?? '');
$to_date   = mysqli_real_escape_string($conn, $_GET['to_date'] ?? '');

// If not filtered, show last 30 days automatically
if (empty($from_date) || empty($to_date)) {
  $to_date = date('Y-m-d');
  $from_date = date('Y-m-d', strtotime('-30 days'));
}

// ----- Total Collection -----
$collection_sql = "
  SELECT IFNULL(SUM(payment_amount), 0) AS total_collection
  FROM fees_receipts
  WHERE deleted_at IS NULL
  AND DATE(payment_date) BETWEEN '$from_date' AND '$to_date'
";
$collection_result = mysqli_query($conn, $collection_sql);
$total_collection = ($collection_result && $row = mysqli_fetch_assoc($collection_result))
  ? $row['total_collection']
  : 0;

// ----- Total Expense -----
$expense_sql = "
  SELECT IFNULL(SUM(amount), 0) AS total_expense
  FROM expenses
  WHERE deleted_at IS NULL
  AND DATE(date) BETWEEN '$from_date' AND '$to_date'
";
$expense_result = mysqli_query($conn, $expense_sql);
$total_expense = ($expense_result && $row = mysqli_fetch_assoc($expense_result))
  ? $row['total_expense']
  : 0;

// ----- Balance -----
$balance = $total_collection - $total_expense;
$is_profit = $balance >= 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Fundflow Reports - <?php echo $settings['site_name']; ?></title>

  <link href="./<?php echo $settings['fevicon']; ?>" rel="icon">
  <link href="./<?php echo $settings['fevicon']; ?>" rel="apple-touch-icon">

  <!-- Fonts & CSS -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Nunito:300,400,600,700|Poppins:300,400,500,600,700" rel="stylesheet">
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
  <?php include("templates/header.php"); ?>
  <?php include("templates/sidebar.php"); ?>

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Fundflow Reports</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
          <li class="breadcrumb-item active">Fundflow Reports</li>
        </ol>
      </nav>
    </div>

    <section class="section">
      <div class="row">

        <!-- Filter Card -->
        <div class="col-lg-12 mb-3">
          <div class="card">
            <div class="card-body">
              <h5 class="card-title mb-3">Filter by Date</h5>

              <form method="GET" class="row g-3">
                <div class="col-md-4">
                  <label class="form-label">From Date</label>
                  <input type="date" name="from_date" value="<?php echo htmlspecialchars($from_date); ?>" class="form-control">
                </div>
                <div class="col-md-4">
                  <label class="form-label">To Date</label>
                  <input type="date" name="to_date" value="<?php echo htmlspecialchars($to_date); ?>" class="form-control">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                  <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search"></i> Search
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <!-- End Filter Card -->

        <!-- Cards Row -->
        <div class="col-lg-4 col-md-6">
          <div class="card text-center border-success">
            <div class="card-body">
              <h5 class="card-title text-success"><i class="bi bi-cash-stack"></i> Total Collection</h5>
              <h3 class="fw-bold">₹<?php echo number_format($total_collection, 2); ?></h3>
              <p class="text-muted">From <?php echo htmlspecialchars($from_date); ?> to <?php echo htmlspecialchars($to_date); ?></p>
            </div>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="card text-center border-danger">
            <div class="card-body">
              <h5 class="card-title text-danger"><i class="bi bi-wallet2"></i> Total Expense</h5>
              <h3 class="fw-bold">₹<?php echo number_format($total_expense, 2); ?></h3>
              <p class="text-muted">From <?php echo htmlspecialchars($from_date); ?> to <?php echo htmlspecialchars($to_date); ?></p>
            </div>
          </div>
        </div>

        <div class="col-lg-4 col-md-12">
          <div class="card text-center <?php echo $is_profit ? 'border-success' : 'border-danger'; ?>">
            <div class="card-body">
              <h5 class="card-title <?php echo $is_profit ? 'text-success' : 'text-danger'; ?>">
                <i class="bi <?php echo $is_profit ? 'bi-graph-up-arrow' : 'bi-graph-down-arrow'; ?>"></i>
                <?php echo $is_profit ? 'Total Balance (Profit)' : 'Total Balance (Loss)'; ?>
              </h5>
              <h3 class="fw-bold text-<?php echo $is_profit ? 'success' : 'danger'; ?>">
                ₹<?php echo number_format(abs($balance), 2); ?>
              </h3>
              <p class="text-muted">From <?php echo htmlspecialchars($from_date); ?> to <?php echo htmlspecialchars($to_date); ?></p>
            </div>
          </div>
        </div>
        <!-- End Cards Row -->

      </div>
    </section>
  </main>

  <?php include("templates/footer.php"); ?>

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
  <script src="assets/vendor/chart.js/chart.umd.js"></script>
  <script src="assets/vendor/echarts/echarts.min.js"></script>
  <script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
  <script src="assets/js/main.js"></script>
</body>
</html>
