<?php
include("../config.php");
session_start();
header('Content-Type: application/json');

// --- Basic CSRF check ---
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo json_encode(["success" => false, "message" => "Security verification failed."]);
    exit;
}

$action = $_POST['action'] ?? '';
$response = ["success" => false, "message" => "Invalid action."];

// Common fields
$type = trim($_POST['type'] ?? '');
$tag = trim($_POST['tag'] ?? '');
$updated_at = date('Y-m-d H:i:s');

if ($action === 'Add' || $action === 'Edit') {
    if (empty($type) || empty($tag)) {
        echo json_encode(["success" => false, "message" => "Type and Tag are required."]);
        exit;
    }

    $upload_dir = "./assets/img/gallery/";
    $db_path = "assets/img/gallery/";
    $image_path = "";
    $video_link = trim($_POST['video_link'] ?? '');

    // Handle Add case first
    if ($action === 'Add') {
        if ($type === 'Image') {
            if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
                $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
                $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                if (!in_array($ext, $allowed)) {
                    echo json_encode(["success" => false, "message" => "Please upload a valid image file."]);
                    exit;
                }

                $newname = uniqid('Gallery_', true) . '.' . $ext;
                if (!move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $newname)) {
                    echo json_encode(["success" => false, "message" => "Error saving image file."]);
                    exit;
                }
                $image_path = $db_path . $newname;
            } else {
                echo json_encode(["success" => false, "message" => "Please upload an image file."]);
                exit;
            }
        } elseif ($type === 'Video') {
            if (empty($video_link)) {
                echo json_encode(["success" => false, "message" => "Please enter a video link."]);
                exit;
            }
            $image_path = $video_link;
        }

        $stmt = $conn->prepare("INSERT INTO gallery (type, tag, image_path, updated_at) VALUES (?,?,?,?)");
        $stmt->bind_param("ssss", $type, $tag, $image_path, $updated_at);
        if ($stmt->execute()) {
            $response = ["success" => true, "message" => "Gallery item added successfully!", "redirect" => "gallery.php"];
        } else {
            $response = ["success" => false, "message" => "Error saving data."];
        }
        $stmt->close();
    }

    // Handle Edit case
elseif ($action === 'Edit') {
    $id = intval($_POST['id'] ?? 0);
    if ($id <= 0) {
        echo json_encode(["success" => false, "message" => "Invalid ID."]);
        exit;
    }

    // Fetch existing record
    $res = $conn->query("SELECT * FROM gallery WHERE id=$id LIMIT 1");
    if (!$res || $res->num_rows === 0) {
        echo json_encode(["success" => false, "message" => "Gallery record not found."]);
        exit;
    }
    $old = $res->fetch_assoc();
    
    // Prevent updating from Video → Image without image upload
if ($old['type'] === 'Video' && $type === 'Image' && (!isset($_FILES['image']) || $_FILES['image']['error'] !== 0)) {
    echo json_encode(["success" => false, "message" => "Please upload an image when switching from Video to Image."]);
    exit;
}


    $image_path = $old['image_path']; // start with old path

    // === CASE 1: Type = Image ===
    if ($type === 'Image') {
        // User uploaded a new image
        if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
            $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (!in_array($ext, $allowed)) {
                echo json_encode(["success" => false, "message" => "Invalid image format."]);
                exit;
            }

            $newname = uniqid('Gallery_', true) . '.' . $ext;
            $upload_dir = "./assets/img/gallery/";
            $db_path = "assets/img/gallery/";

            if (!move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $newname)) {
                echo json_encode(["success" => false, "message" => "Error saving new image."]);
                exit;
            }

            $image_path = $db_path . $newname;
        } else {
            // ✅ If previous type was Video and no image uploaded,
            // clear the video link because there's no valid image.
            if ($old['type'] === 'Video') {
                $image_path = ''; // empty path instead of old video link
            }
        }
    }

    // === CASE 2: Type = Video ===
    elseif ($type === 'Video') {
        if (empty($video_link)) {
            echo json_encode(["success" => false, "message" => "Video link is required."]);
            exit;
        }
        $image_path = $video_link;
    }

    // --- Update record ---
    $sql = "UPDATE gallery 
            SET type=?, tag=?, image_path=?, updated_at=? 
            WHERE id=?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        echo json_encode(["success" => false, "message" => "Database prepare failed: " . $conn->error]);
        exit;
    }

    $stmt->bind_param("ssssi", $type, $tag, $image_path, $updated_at, $id);

    if ($stmt->execute()) {
        $response = ["success" => true, "message" => "Gallery item updated successfully!", "redirect" => "gallery.php"];
    } else {
        $response = ["success" => false, "message" => "Error updating record: " . $stmt->error];
    }
    $stmt->close();
}



}

// Handle DELETE
elseif ($action === 'delete') {
    $id = intval($_POST['id'] ?? 0);
    if ($id <= 0) {
        echo json_encode(["success" => false, "message" => "Invalid ID."]);
        exit;
    }

    $stmt = $conn->prepare("UPDATE gallery SET deleted_at = NOW() WHERE id=?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        $response = ["success" => true, "message" => "Gallery item deleted successfully!"];
    } else {
        $response = ["success" => false, "message" => "Error deleting record."];
    }
    $stmt->close();
}

echo json_encode($response);
?>










